/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NumericConstraint<T>
implements Predicate<Value>,
com.google.common.base.Predicate<Value> {
    private static final Logger log = LoggerFactory.getLogger(NumericConstraint.class);
    private boolean invalid;
    private boolean lowerInclusive;
    private T lowerBound;
    private T upperBound;
    private boolean upperInclusive;

    protected NumericConstraint(String definition) {
        Pattern pattern = Pattern.compile("([\\(\\[])([^,]*),([^\\)\\]]*)([\\)\\]])");
        Matcher matcher = pattern.matcher(definition);
        if (matcher.matches()) {
            try {
                this.lowerInclusive = "[".equals(matcher.group(1));
                this.lowerBound = this.getBound(matcher.group(2));
                this.upperBound = this.getBound(matcher.group(3));
                this.upperInclusive = "]".equals(matcher.group(4));
            }
            catch (NumberFormatException e) {
                this.invalid(definition);
            }
        } else {
            this.invalid(definition);
        }
    }

    private void invalid(String definition) {
        this.invalid = true;
        log.warn('\'' + definition + "' is not a valid value constraint format for numeric values");
    }

    protected abstract T getBound(String var1);

    @Override
    public boolean test(@Nullable Value value) {
        if (value == null || this.invalid) {
            return false;
        }
        try {
            T t = this.getValue(value);
            if (this.lowerBound != null && (this.lowerInclusive ? this.less(t, this.lowerBound) : this.lessOrEqual(t, this.lowerBound))) {
                return false;
            }
            return this.upperBound == null || !(this.upperInclusive ? this.greater(t, this.upperBound) : this.greaterOrEqual(t, this.upperBound));
        }
        catch (RepositoryException e) {
            log.warn("Error checking numeric constraint " + this, (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public boolean apply(@Nullable Value value) {
        GuavaDeprecation.handleCall("OAK-8874");
        return this.test(value);
    }

    protected abstract T getValue(Value var1) throws RepositoryException;

    protected abstract boolean less(T var1, T var2);

    protected boolean greater(T val, T bound) {
        return this.less(bound, val);
    }

    protected boolean equals(T val, T bound) {
        return val.equals(bound);
    }

    protected boolean greaterOrEqual(T val, T bound) {
        return this.greater(val, bound) || this.equals(val, bound);
    }

    protected boolean lessOrEqual(T val, T bound) {
        return this.less(val, bound) || this.equals(val, bound);
    }

    public String toString() {
        return (this.lowerInclusive ? "[" : "(") + (this.lowerBound == null ? "" : this.lowerBound) + ", " + (this.upperBound == null ? "" : this.upperBound) + (this.upperInclusive ? "]" : ")");
    }
}

