/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.osgi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiWhiteboard
implements Whiteboard {
    private static final Logger log = LoggerFactory.getLogger(OsgiWhiteboard.class);
    private final BundleContext context;

    public OsgiWhiteboard(@NotNull BundleContext context) {
        this.context = (BundleContext)Preconditions.checkNotNull((Object)context);
    }

    @Override
    public <T> Registration register(final Class<T> type, final T service, Map<?, ?> properties) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(properties);
        Preconditions.checkArgument((boolean)type.isInstance(service));
        Hashtable dictionary = new Hashtable();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            ((Dictionary)dictionary).put(entry.getKey(), entry.getValue());
        }
        final ServiceRegistration registration = this.context.registerService(type.getName(), service, dictionary);
        return new Registration(){
            private volatile boolean unregistered;

            @Override
            public void unregister() {
                try {
                    if (!this.unregistered) {
                        registration.unregister();
                        this.unregistered = true;
                    } else {
                        log.warn("Service {} of type {} unregistered multiple times", service, (Object)type);
                    }
                }
                catch (IllegalStateException ex) {
                    log.warn("Error unregistering service: {} of type {}", new Object[]{service, type.getName(), ex});
                }
            }
        };
    }

    @Override
    public <T> Tracker<T> track(Class<T> type) {
        return this.track(type, Collections.emptyMap());
    }

    @Override
    public <T> Tracker<T> track(Class<T> type, Map<String, String> filterProperties) {
        return this.track(type, OsgiUtil.getFilter(type, filterProperties));
    }

    private <T> Tracker<T> track(final Class<T> type, Filter filter) {
        Preconditions.checkNotNull(type);
        final AtomicReference list = new AtomicReference(Collections.emptyList());
        ServiceTrackerCustomizer customizer = new ServiceTrackerCustomizer(){
            private final Map<ServiceReference, T> services = Maps.newHashMap();

            public synchronized Object addingService(ServiceReference reference) {
                Object service = OsgiWhiteboard.this.context.getService(reference);
                if (type.isInstance(service)) {
                    this.services.put(reference, service);
                    list.set(OsgiWhiteboard.getServiceList(this.services));
                    return service;
                }
                OsgiWhiteboard.this.context.ungetService(reference);
                return null;
            }

            public synchronized void modifiedService(ServiceReference reference, Object service) {
                this.services.remove(reference);
                this.services.put(reference, service);
                list.set(OsgiWhiteboard.getServiceList(this.services));
            }

            public synchronized void removedService(ServiceReference reference, Object service) {
                this.services.remove(reference);
                list.set(OsgiWhiteboard.getServiceList(this.services));
                OsgiWhiteboard.this.context.ungetService(reference);
            }
        };
        final ServiceTracker tracker = new ServiceTracker(this.context, filter, customizer);
        tracker.open();
        return new Tracker<T>(){

            @Override
            public List<T> getServices() {
                return (List)list.get();
            }

            @Override
            public void stop() {
                tracker.close();
            }
        };
    }

    private static <T> List<T> getServiceList(Map<ServiceReference, T> services) {
        switch (services.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(services.values().iterator().next());
            }
        }
        TreeMap sorted = Maps.newTreeMap();
        sorted.putAll(services);
        return Lists.newArrayList(sorted.values());
    }
}

