/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionManagerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionDelegate
extends NodeDelegate {
    private VersionDelegate(SessionDelegate sessionDelegate, Tree tree) {
        super((SessionDelegate)Preconditions.checkNotNull((Object)sessionDelegate), (Tree)Preconditions.checkNotNull((Object)tree));
    }

    static VersionDelegate create(@NotNull SessionDelegate sessionDelegate, @NotNull Tree tree) {
        return new VersionDelegate(sessionDelegate, tree);
    }

    @NotNull
    NodeDelegate getFrozenNode() throws RepositoryException {
        NodeDelegate frozenNode = this.getChild("jcr:frozenNode");
        if (frozenNode == null) {
            throw new RepositoryException("Inconsistent version storage. Version at " + this.getPath() + " does not have a jcr:frozenNode");
        }
        return frozenNode;
    }

    @NotNull
    public Iterable<VersionDelegate> getPredecessors() throws RepositoryException {
        PropertyDelegate p = this.getPropertyOrNull("jcr:predecessors");
        if (p == null) {
            throw new RepositoryException("Inconsistent version storage. Version does not have a jcr:predecessors property.");
        }
        ArrayList predecessors = Lists.newArrayList();
        VersionManagerDelegate vMgr = VersionManagerDelegate.create(this.sessionDelegate);
        for (String id : p.getMultiState().getValue(Type.REFERENCES)) {
            predecessors.add(vMgr.getVersionByIdentifier(id));
        }
        return predecessors;
    }

    @Nullable
    public VersionDelegate getLinearPredecessor() throws RepositoryException {
        Iterable<VersionDelegate> predecessors = this.getPredecessors();
        if (predecessors.iterator().hasNext()) {
            return predecessors.iterator().next();
        }
        return null;
    }
}

