/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.ImportConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.ProtectedItemImporter;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceImporter
implements Importer {
    private static Logger log = LoggerFactory.getLogger(WorkspaceImporter.class);
    private final NodeState importTarget;
    private final WorkspaceImpl wsp;
    private final SessionImpl session;
    private final InternalVersionManager versionManager;
    private final HierarchyManager hierMgr;
    private final BatchedItemOperations itemOps;
    private final int uuidBehavior;
    private boolean aborted;
    private final Stack<NodeState> parents;
    private final ReferenceChangeTracker refTracker;

    public WorkspaceImporter(Path parentPath, WorkspaceImpl wsp, SessionContext sessionContext, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this(parentPath, wsp, sessionContext, uuidBehavior, null);
    }

    public WorkspaceImporter(Path parentPath, WorkspaceImpl wsp, SessionContext sessionContext, int uuidBehavior, ImportConfig config) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.wsp = wsp;
        this.session = sessionContext.getSessionImpl();
        this.versionManager = this.session.getInternalVersionManager();
        this.uuidBehavior = uuidBehavior;
        this.itemOps = new BatchedItemOperations(wsp.getItemStateManager(), sessionContext);
        this.hierMgr = wsp.getHierarchyManager();
        this.itemOps.verifyCanWrite(parentPath);
        this.importTarget = this.itemOps.getNodeState(parentPath);
        this.aborted = false;
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(this.importTarget);
        if (config != null) {
            List<? extends ProtectedItemImporter> pi = config.getProtectedItemImporters();
            for (ProtectedItemImporter protectedItemImporter : pi) {
                if (!protectedItemImporter.init(this.session, this.session, true, uuidBehavior, this.refTracker)) continue;
                log.warn("Protected item importer configured is not supported by workspace import.");
            }
        }
    }

    protected NodeState resolveUUIDConflict(NodeState parent, NodeState conflicting, NodeInfo nodeInfo) throws RepositoryException {
        NodeState node;
        if (this.uuidBehavior == 0) {
            this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 17);
            node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), null);
            EffectiveNodeType ent = this.itemOps.getEffectiveNodeType(node);
            if (ent.includesNodeType(NameConstants.MIX_REFERENCEABLE)) {
                this.refTracker.mappedId(nodeInfo.getId(), node.getNodeId());
            }
        } else {
            if (this.uuidBehavior == 3) {
                if (conflicting.isShareable()) {
                    this.itemOps.clone(conflicting, parent, nodeInfo.getName());
                    return null;
                }
                String msg = "a node with uuid " + nodeInfo.getId() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                Path p0 = this.hierMgr.getPath(this.importTarget.getNodeId());
                Path p1 = this.hierMgr.getPath(conflicting.getNodeId());
                try {
                    if (p1.equals(p0) || p1.isAncestorOf(p0)) {
                        String msg = "cannot remove ancestor node";
                        log.debug(msg);
                        throw new ConstraintViolationException(msg);
                    }
                }
                catch (MalformedPathException mpe) {
                    String msg = "internal error: failed to determine degree of relationship";
                    log.error(msg, (Throwable)((Object)mpe));
                    throw new RepositoryException(msg, (Throwable)((Object)mpe));
                }
                this.itemOps.checkRemoveNode(conflicting, 407);
                this.itemOps.removeNodeState(conflicting);
                this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 17);
                node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else if (this.uuidBehavior == 2) {
                NodeId parentId = conflicting.getParentId();
                if (parentId == null) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                try {
                    parent = this.itemOps.getNodeState(parentId);
                }
                catch (ItemNotFoundException infe) {
                    String msg = "internal error: failed to retrieve parent state";
                    log.error(msg, (Throwable)infe);
                    throw new RepositoryException(msg, (Throwable)infe);
                }
                this.itemOps.checkRemoveNode(conflicting, 407);
                ChildNodeEntry cneConflicting = parent.getChildNodeEntry(nodeInfo.getId());
                ArrayList<ChildNodeEntry> cneList = new ArrayList<ChildNodeEntry>(parent.getChildNodeEntries());
                this.itemOps.removeNodeState(conflicting);
                this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 407);
                node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
                if (cneConflicting.getName().equals(nodeInfo.getName())) {
                    parent.setChildNodeEntries(cneList);
                } else {
                    parent.removeAllChildNodeEntries();
                    for (ChildNodeEntry cne : cneList) {
                        if (cne.getId().equals(nodeInfo.getId())) {
                            parent.addChildNodeEntry(nodeInfo.getName(), nodeInfo.getId());
                            continue;
                        }
                        parent.addChildNodeEntry(cne.getName(), cne.getId());
                    }
                }
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return node;
    }

    protected void postProcessNode(NodeState node) throws RepositoryException {
        EffectiveNodeType ent = this.itemOps.getEffectiveNodeType(node);
        if (ent.includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE)) {
            VersionHistoryInfo history = this.versionManager.getVersionHistory(this.session, node, null);
            InternalValue historyId = InternalValue.create(history.getVersionHistoryId());
            InternalValue versionId = InternalValue.create(history.getRootVersionId());
            this.conditionalAddProperty(node, NameConstants.JCR_ISCHECKEDOUT, 6, false, InternalValue.create(true));
            if (ent.includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                this.conditionalAddProperty(node, NameConstants.JCR_VERSIONHISTORY, 9, false, historyId);
                this.conditionalAddProperty(node, NameConstants.JCR_BASEVERSION, 9, false, versionId);
                this.conditionalAddProperty(node, NameConstants.JCR_PREDECESSORS, 9, true, versionId);
            }
        }
    }

    protected void processProperty(NodeState node, PropInfo pInfo) throws RepositoryException {
        TextValue[] values;
        QPropertyDefinition def;
        PropertyState prop;
        Name name = pInfo.getName();
        int type = pInfo.getType();
        if (node.hasPropertyName(name)) {
            PropertyId idExisting = new PropertyId(node.getNodeId(), name);
            prop = (PropertyState)this.itemOps.getItemState(idExisting);
            def = this.itemOps.findApplicablePropertyDefinition(prop.getName(), prop.getType(), prop.isMultiValued(), node);
            if (def.isProtected()) {
                log.debug("skipping protected property " + this.itemOps.safeGetJCRPath(idExisting));
                return;
            }
            if (!def.isAutoCreated() || prop.getType() != type && type != 0 || def.isMultiple() != prop.isMultiValued()) {
                throw new ItemExistsException(this.itemOps.safeGetJCRPath(prop.getPropertyId()));
            }
        } else {
            def = pInfo.getApplicablePropertyDef(this.itemOps.getEffectiveNodeType(node));
            if (def.isProtected()) {
                log.debug("skipping protected property " + name);
                return;
            }
            prop = this.itemOps.createPropertyState(node, name, type, def);
        }
        if ((values = pInfo.getTextValues()).length != 1 && !def.isMultiple()) {
            throw new ConstraintViolationException(this.itemOps.safeGetJCRPath(prop.getPropertyId()) + " is not multi-valued");
        }
        int targetType = pInfo.getTargetType(def);
        InternalValue[] iva = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            iva[i] = values[i].getInternalValue(targetType);
        }
        prop.setValues(iva);
        this.itemOps.validate(prop);
        if (prop.getType() == 9 || prop.getType() == 10) {
            this.refTracker.processedReference(prop);
        }
        this.itemOps.store(prop);
    }

    private void conditionalAddProperty(NodeState node, Name name, int type, boolean multiple, InternalValue value) throws RepositoryException {
        if (!node.hasPropertyName(name)) {
            QPropertyDefinition def = this.itemOps.findApplicablePropertyDefinition(name, type, multiple, node);
            PropertyState prop = this.itemOps.createPropertyState(node, name, type, def);
            prop.setValues(new InternalValue[]{value});
        }
    }

    @Override
    public void start() throws RepositoryException {
        try {
            this.itemOps.edit();
        }
        catch (IllegalStateException ise) {
            this.aborted = true;
            String msg = "internal error: failed to start update operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startNode(NodeInfo nodeInfo, List<PropInfo> propInfos) throws RepositoryException {
        if (this.aborted) {
            return;
        }
        succeeded = false;
        this.wsp.sanityCheck();
        parent = this.parents.peek();
        node = null;
        id = nodeInfo.getId();
        nodeName = nodeInfo.getName();
        ntName = nodeInfo.getNodeTypeName();
        mixins = nodeInfo.getMixinNames();
        if (parent == null) {
            this.parents.push(null);
            succeeded = true;
            WorkspaceImporter.log.debug("skipping node " + nodeName);
            if (succeeded != false) return;
            this.aborted = true;
        }
        ** GOTO lbl-1000
        {
            block19: {
                block20: {
                    catch (Throwable var15_16) {
                        throw var15_16;
                    }
                    this.itemOps.cancel();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (!parent.hasChildNodeEntry(nodeName) || (def = this.itemOps.findApplicableNodeDefinition(nodeName, (existing = (NodeState)this.itemOps.getItemState(idExisting = (entry = parent.getChildNodeEntry(nodeName, 1)).getId())).getNodeTypeName(), parent)).allowsSameNameSiblings()) ** GOTO lbl42
                        entExisting = this.itemOps.getEffectiveNodeType(existing);
                        if (!def.isProtected() || !entExisting.includesNodeType(ntName)) ** GOTO lbl-1000
                        this.parents.push(null);
                        succeeded = true;
                        WorkspaceImporter.log.debug("skipping protected node " + this.itemOps.safeGetJCRPath(existing.getNodeId()));
                        if (succeeded != false) return;
                        this.aborted = true;
                    }
                    this.itemOps.cancel();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (def.isAutoCreated() && entExisting.includesNodeType(ntName)) {
                            node = existing;
                        } else {
                            if (idExisting.equals(id) == false) throw new ItemExistsException(this.itemOps.safeGetJCRPath(existing.getNodeId()));
                            if (this.uuidBehavior != 1 && this.uuidBehavior != 2) {
                                throw new ItemExistsException(this.itemOps.safeGetJCRPath(existing.getNodeId()));
                            }
                        }
lbl42:
                        // 4 sources

                        if (node != null) ** GOTO lbl86
                        if (id != null) break block19;
                        def = this.itemOps.findApplicableNodeDefinition(nodeName, ntName, parent);
                        if (!def.isProtected()) break block20;
                        this.parents.push(null);
                        succeeded = true;
                        WorkspaceImporter.log.debug("skipping protected node " + nodeName);
                        if (succeeded != false) return;
                        this.aborted = true;
                    }
                    this.itemOps.cancel();
                    return;
                }
                this.itemOps.checkAddNode(parent, nodeName, ntName, 17);
                node = this.itemOps.createNodeState(parent, nodeName, ntName, mixins, null, def);
                ** GOTO lbl86
            }
            conflicting = this.itemOps.getNodeState(id);
            node = this.resolveUUIDConflict(parent, conflicting, nodeInfo);
            if (node == null) {
                this.parents.push(null);
                succeeded = true;
                WorkspaceImporter.log.debug("skipping existing node: " + nodeName);
                if (succeeded != false) return;
                this.aborted = true;
                this.itemOps.cancel();
                return;
            }
            ** GOTO lbl86
            {
                catch (ItemNotFoundException e) {}
                def = this.itemOps.findApplicableNodeDefinition(nodeName, ntName, parent);
                if (def.isProtected()) {
                    this.parents.push(null);
                    succeeded = true;
                    WorkspaceImporter.log.debug("skipping protected node " + nodeName);
                    if (succeeded != false) return;
                    this.aborted = true;
                    this.itemOps.cancel();
                    return;
                }
                ** try [egrp 6[TRYBLOCK] [6 : 654->761)] { 
lbl84:
                // 1 sources

                this.itemOps.checkAddNode(parent, nodeName, ntName, 17);
                node = this.itemOps.createNodeState(parent, nodeName, ntName, mixins, id, def);
lbl86:
                // 5 sources

                for (PropInfo propInfo : propInfos) {
                    this.processProperty(node, propInfo);
                }
                this.itemOps.store(node);
                this.itemOps.store(parent);
                this.parents.push(node);
                return;
lbl94:
                // 1 sources

                finally {
                    if (!succeeded) {
                        this.aborted = true;
                        this.itemOps.cancel();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endNode(NodeInfo nodeInfo) throws RepositoryException {
        if (this.aborted) {
            return;
        }
        NodeState node = this.parents.pop();
        if (node == null) {
            return;
        }
        boolean succeeded = false;
        try {
            this.wsp.sanityCheck();
            this.postProcessNode(node);
            this.itemOps.validate(node);
            this.itemOps.store(node);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() throws RepositoryException {
        if (this.aborted) {
            return;
        }
        boolean succeeded = false;
        try {
            this.wsp.sanityCheck();
            Iterator<Object> iter = this.refTracker.getProcessedReferences();
            while (iter.hasNext()) {
                PropertyState prop = (PropertyState)iter.next();
                if (prop.getType() != 9 && prop.getType() != 10) continue;
                boolean modified = false;
                InternalValue[] values = prop.getValues();
                InternalValue[] newVals = new InternalValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    NodeId adjusted = this.refTracker.getMappedId(values[i].getNodeId());
                    if (adjusted != null) {
                        newVals[i] = InternalValue.create(adjusted, prop.getType() != 9);
                        modified = true;
                        continue;
                    }
                    newVals[i] = values[i];
                }
                if (!modified) continue;
                prop.setValues(newVals);
                this.itemOps.store(prop);
            }
            this.refTracker.clear();
            this.itemOps.validate(this.importTarget);
            this.itemOps.store(this.importTarget);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
        if (!this.aborted) {
            this.itemOps.update();
        }
    }
}

