/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockHelper {
    private final ResourceResolver resolver;
    private final Stack<Description> stack = new Stack();

    private MockHelper(ResourceResolver r) {
        this.resolver = r;
    }

    @NotNull
    public static MockHelper create(@NotNull ResourceResolver resolver) {
        return new MockHelper(resolver);
    }

    @NotNull
    public MockHelper resource(@NotNull String path) {
        Description d;
        String fullPath;
        if (path.startsWith("/")) {
            fullPath = path;
        } else if (path.startsWith(".")) {
            d = this.stack.peek();
            fullPath = ResourceUtil.normalize((String)(d.path + "/../" + path.substring(1)));
        } else {
            d = this.stack.peek();
            fullPath = d.path + "/" + path;
        }
        d = new Description();
        d.path = fullPath;
        this.stack.push(d);
        return this;
    }

    @NotNull
    public MockHelper p(@NotNull String name, @Nullable Object value) {
        Description d = this.stack.peek();
        d.properties.put(name, value);
        return this;
    }

    public void add() throws PersistenceException {
        for (int i = 0; i < this.stack.size(); ++i) {
            Description d = (Description)this.stack.get(i);
            this.create(d.path, d.properties);
        }
        this.stack.clear();
    }

    public void commit() throws PersistenceException {
        this.add();
        this.resolver.commit();
    }

    private void create(@NotNull String path, @NotNull Map<String, Object> properties) throws PersistenceException {
        String parentPath = ResourceUtil.getParent((String)path);
        String name = ResourceUtil.getName((String)path);
        Resource parent = this.resolver.getResource(parentPath);
        this.resolver.create(parent, name, properties);
    }

    private static final class Description {
        public String path;
        public Map<String, Object> properties = new HashMap<String, Object>();

        private Description() {
        }
    }
}

