/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.resourceresolver.MockFindResourcesHandler;
import org.apache.sling.testing.resourceresolver.MockPropertyResource;
import org.apache.sling.testing.resourceresolver.MockQueryResourceHandler;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactory;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactoryOptions;
import org.apache.sling.testing.resourceresolver.NamespaceMangler;
import org.apache.sling.testing.resourceresolver.ResourceTypeUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class MockResourceResolver
extends SlingAdaptable
implements ResourceResolver {
    private final Map<String, Map<String, Object>> resources;
    private final Map<String, Map<String, Object>> temporaryResources = new LinkedHashMap<String, Map<String, Object>>();
    private final Set<String> deletedResources = new HashSet<String>();
    private final MockResourceResolverFactoryOptions options;
    private final MockResourceResolverFactory factory;
    private final Map<String, Object> attributes;
    private final List<MockFindResourcesHandler> findResourcesHandlers = new ArrayList<MockFindResourcesHandler>();
    private final List<MockQueryResourceHandler> queryResourcesHandlers = new ArrayList<MockQueryResourceHandler>();

    public MockResourceResolver(MockResourceResolverFactoryOptions options, MockResourceResolverFactory factory, Map<String, Map<String, Object>> resources) {
        this(options, factory, resources, Collections.emptyMap());
    }

    public MockResourceResolver(MockResourceResolverFactoryOptions options, MockResourceResolverFactory factory, Map<String, Map<String, Object>> resources, Map<String, Object> attributes) {
        this.factory = factory;
        this.options = options;
        this.resources = resources;
        this.attributes = attributes;
    }

    @NotNull
    public Resource resolve(@NotNull HttpServletRequest request, @NotNull String absPath) {
        Resource resource;
        String path = absPath;
        if (path == null) {
            path = "/";
        }
        String urlRemainder = null;
        int urlRemainderPos = Math.min(path.indexOf(63), path.indexOf(35));
        if (urlRemainderPos >= 0) {
            urlRemainder = path.substring(urlRemainderPos);
            path = path.substring(0, urlRemainderPos);
        }
        if (this.options.isMangleNamespacePrefixes()) {
            path = NamespaceMangler.unmangleNamespaces(path);
        }
        if ((resource = this.getResource(path = path + (urlRemainder != null ? urlRemainder : ""))) == null) {
            resource = new NonExistingResource((ResourceResolver)this, absPath);
        }
        return resource;
    }

    @NotNull
    public Resource resolve(@NotNull String absPath) {
        return this.resolve(null, absPath);
    }

    @NotNull
    public String map(@NotNull String resourcePath) {
        return this.map(null, resourcePath);
    }

    public String map(@NotNull HttpServletRequest request, @NotNull String resourcePath) {
        String path = resourcePath;
        String urlRemainder = null;
        int urlRemainderPos = Math.min(path.indexOf(63), path.indexOf(35));
        if (urlRemainderPos >= 0) {
            urlRemainder = path.substring(urlRemainderPos);
            path = path.substring(0, urlRemainderPos);
        }
        if (this.options.isMangleNamespacePrefixes()) {
            path = NamespaceMangler.mangleNamespaces(path);
        }
        return path + (urlRemainder != null ? urlRemainder : "");
    }

    public Resource getResource(@NotNull String path) {
        String parentPath;
        Resource resource = this.getResourceInternal(path);
        if (resource == null && path != null && (parentPath = ResourceUtil.getParent((String)path)) != null) {
            ValueMap props;
            String name = ResourceUtil.getName((String)path);
            Resource parentResource = this.getResourceInternal(parentPath);
            if (parentResource != null && (props = ResourceUtil.getValueMap((Resource)parentResource)).containsKey((Object)name)) {
                return new MockPropertyResource(path, props, this);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResourceInternal(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = ResourceUtil.normalize((String)path);
        if (normalizedPath == null) {
            return null;
        }
        if (normalizedPath.startsWith("/")) {
            if (this.deletedResources.contains(normalizedPath)) {
                return null;
            }
            Map<String, Object> tempProps = this.temporaryResources.get(normalizedPath);
            if (tempProps != null) {
                return this.newMockResource(normalizedPath, tempProps, this);
            }
            Map<String, Map<String, Object>> map = this.resources;
            synchronized (map) {
                Map<String, Object> props = this.resources.get(normalizedPath);
                if (props != null) {
                    return this.newMockResource(normalizedPath, props, this);
                }
            }
        } else {
            for (String s : this.getSearchPath()) {
                Resource rsrc = this.getResource(s + '/' + normalizedPath);
                if (rsrc == null) continue;
                return rsrc;
            }
        }
        return null;
    }

    public Resource getResource(Resource base, @NotNull String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (path.startsWith("/")) {
            return this.getResource(path);
        }
        if (base.getPath().equals("/")) {
            return this.getResource(base.getPath() + path);
        }
        return this.getResource(base.getPath() + '/' + path);
    }

    public String @NotNull [] getSearchPath() {
        return this.options.getSearchPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Iterator<Resource> listChildren(@NotNull Resource parent) {
        String pathPrefix = "/".equals(parent.getPath()) ? "" : parent.getPath();
        Pattern childPathMatcher = Pattern.compile("^" + Pattern.quote(pathPrefix) + "/[^/]+$");
        LinkedHashMap<String, Map<String, Object>> candidates = new LinkedHashMap<String, Map<String, Object>>();
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (Map.Entry<String, Map<String, Object>> entry : this.resources.entrySet()) {
                if (!childPathMatcher.matcher(entry.getKey()).matches() || this.deletedResources.contains(entry.getKey())) continue;
                candidates.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Map<String, Object>> entry : this.temporaryResources.entrySet()) {
                if (!childPathMatcher.matcher(entry.getKey()).matches() || this.deletedResources.contains(entry.getKey())) continue;
                candidates.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<Resource> children = new ArrayList<Resource>();
        for (Map.Entry<String, Map<String, Object>> entry : candidates.entrySet()) {
            children.add(this.newMockResource(entry.getKey(), entry.getValue(), this));
        }
        return children.iterator();
    }

    private Resource newMockResource(String path, Map<String, Object> properties, ResourceResolver resolver) {
        return this.options.getMockResourceFactory().newMockResource(path, properties, resolver);
    }

    @NotNull
    public Iterable<Resource> getChildren(final @NotNull Resource parent) {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return MockResourceResolver.this.listChildren(parent);
            }
        };
    }

    public boolean isLive() {
        return true;
    }

    public void close() {
        this.factory.closed(this);
    }

    public String getUserID() {
        return null;
    }

    @NotNull
    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(@NotNull String name) {
        return this.attributes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@NotNull Resource resource) throws PersistenceException {
        this.deletedResources.add(resource.getPath());
        this.temporaryResources.remove(resource.getPath());
        String prefixPath = resource.getPath() + '/';
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (Map.Entry<String, Map<String, Object>> e : this.resources.entrySet()) {
                if (!e.getKey().startsWith(prefixPath)) continue;
                this.deletedResources.add(e.getKey());
            }
            Iterator<Map.Entry<String, Map<String, Object>>> i = this.temporaryResources.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Map<String, Object>> e;
                e = i.next();
                if (!e.getKey().startsWith(prefixPath)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource create(@NotNull Resource parent, @NotNull String name, Map<String, Object> properties) throws PersistenceException {
        String path;
        String string = path = parent.getPath().equals("/") ? parent.getPath() + name : parent.getPath() + '/' + name;
        if (this.temporaryResources.containsKey(path)) {
            throw new PersistenceException("Path already exists: " + path);
        }
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            if (this.resources.containsKey(path) && !this.deletedResources.contains(path)) {
                throw new PersistenceException("Path already exists: " + path);
            }
        }
        this.deletedResources.remove(path);
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        Resource mockResource = this.newMockResource(path, properties, this);
        this.temporaryResources.put(path, (Map<String, Object>)ResourceUtil.getValueMap((Resource)mockResource));
        return mockResource;
    }

    public void revert() {
        this.deletedResources.clear();
        this.temporaryResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws PersistenceException {
        EventAdmin eventAdmin = this.options.getEventAdmin();
        Map<String, Map<String, Object>> map = this.resources;
        synchronized (map) {
            for (String path : this.deletedResources) {
                if (this.resources.remove(path) != null && eventAdmin != null) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("path", path);
                    Event e = new Event("org/apache/sling/api/resource/Resource/REMOVED", props);
                    eventAdmin.sendEvent(e);
                }
                this.temporaryResources.remove(path);
            }
            for (String path : this.temporaryResources.keySet()) {
                boolean changed = this.resources.containsKey(path);
                this.resources.put(path, this.temporaryResources.get(path));
                if (eventAdmin == null) continue;
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("path", path);
                if (this.resources.get(path).get("sling:resourceType") != null) {
                    ((Dictionary)props).put("resourceType", this.resources.get(path).get("sling:resourceType"));
                }
                Event e = new Event(changed ? "org/apache/sling/api/resource/Resource/CHANGED" : "org/apache/sling/api/resource/Resource/ADDED", props);
                eventAdmin.sendEvent(e);
            }
        }
        this.revert();
    }

    public boolean hasChanges() {
        return this.temporaryResources.size() > 0 || this.deletedResources.size() > 0;
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        boolean result = false;
        if (resource != null && resourceType != null) {
            if (ResourceTypeUtil.areResourceTypesEqual(resourceType, resource.getResourceType(), this.getSearchPath())) {
                result = true;
            } else {
                HashSet<String> superTypesChecked = new HashSet<String>();
                String superType = this.getParentResourceType(resource);
                while (!result && superType != null) {
                    if (ResourceTypeUtil.areResourceTypesEqual(resourceType, superType, this.getSearchPath())) {
                        result = true;
                        continue;
                    }
                    superTypesChecked.add(superType);
                    if ((superType = this.getParentResourceType(superType)) == null || !superTypesChecked.contains(superType)) continue;
                    throw new SlingException("Cyclic dependency for resourceSuperType hierarchy detected on resource " + resource.getPath()){
                        private static final long serialVersionUID = 1L;
                    };
                }
            }
        }
        return result;
    }

    public void refresh() {
    }

    public void addChanged(String path, Map<String, Object> props) {
        this.temporaryResources.put(path, props);
    }

    public String getParentResourceType(Resource resource) {
        String resourceSuperType = null;
        if (resource != null && (resourceSuperType = resource.getResourceSuperType()) == null) {
            resourceSuperType = this.getParentResourceType(resource.getResourceType());
        }
        return resourceSuperType;
    }

    public String getParentResourceType(String resourceType) {
        Resource rtResource;
        String rtPath = resourceType == null ? null : ResourceUtil.resourceTypeToPath((String)resourceType);
        String resourceSuperType = null;
        if (rtPath != null && (rtResource = this.getResource(rtPath)) != null) {
            resourceSuperType = rtResource.getResourceSuperType();
        }
        return resourceSuperType;
    }

    public boolean hasChildren(@NotNull Resource resource) {
        return this.listChildren(resource).hasNext();
    }

    public Resource getParent(@NotNull Resource child) {
        String parentPath = ResourceUtil.getParent((String)child.getPath());
        if (parentPath == null) {
            return null;
        }
        return this.getResource(parentPath);
    }

    @NotNull
    public Iterator<Resource> findResources(@NotNull String query, String language) {
        return this.findResourcesHandlers.stream().map((? super T handler) -> handler.findResources(query, language)).filter(Objects::nonNull).findFirst().orElse(Collections.emptyIterator());
    }

    public void addFindResourceHandler(@NotNull MockFindResourcesHandler handler) {
        this.findResourcesHandlers.add(handler);
    }

    @NotNull
    public Iterator<Map<String, Object>> queryResources(@NotNull String query, String language) {
        return this.queryResourcesHandlers.stream().map((? super T handler) -> handler.queryResources(query, language)).filter(Objects::nonNull).findFirst().orElse(Collections.emptyIterator());
    }

    public void addQueryResourceHandler(@NotNull MockQueryResourceHandler handler) {
        this.queryResourcesHandlers.add(handler);
    }

    @Deprecated
    @NotNull
    public Resource resolve(@NotNull HttpServletRequest request) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        throw new UnsupportedOperationException();
    }

    public Resource copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    public Resource move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        throw new UnsupportedOperationException();
    }
}

