/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.paxexam;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Dictionary;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.sling.testing.paxexam.SlingOptions;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.ModifiableCompositeOption;
import org.ops4j.pax.exam.util.PathUtils;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class TestSupport {
    private final String workingDirectory = String.format("%s/target/paxexam/%s/%s", PathUtils.getBaseDir(), this.getClass().getSimpleName(), UUID.randomUUID());
    @Inject
    protected ConfigurationAdmin configurationAdmin;

    protected String workingDirectory() {
        return this.workingDirectory;
    }

    protected synchronized int findFreePort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int httpPort() throws IOException {
        Dictionary properties = this.configurationAdmin.getConfiguration("org.apache.felix.http").getProperties();
        return Integer.parseInt(properties.get("org.osgi.service.http.port").toString());
    }

    protected ModifiableCompositeOption baseConfiguration() {
        return CoreOptions.composite((Option[])new Option[]{this.failOnUnresolvedBundles(), CoreOptions.keepCaches(), this.localMavenRepo(), CoreOptions.repository((String)"https://repository.apache.org/snapshots/").id("apache-snapshots").allowSnapshots(), CoreOptions.workingDirectory((String)this.workingDirectory()), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.testing.paxexam").versionAsInProject(), SlingOptions.paxTinybundles(), SlingOptions.backing(), SlingOptions.spyfly()});
    }

    protected Option failOnUnresolvedBundles() {
        return CoreOptions.systemProperty((String)"pax.exam.osgi.unresolved.fail").value("true");
    }

    protected Option localMavenRepo() {
        String localRepository = System.getProperty("maven.repo.local", "");
        return CoreOptions.when((localRepository.length() > 0 ? 1 : 0) != 0).useOptions(new Option[]{CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.localRepository").value(localRepository)});
    }

    protected Option testBundle(String systemProperty) {
        String filename = System.getProperty(systemProperty);
        File file = new File(filename);
        return CoreOptions.bundle((String)file.toURI().toString());
    }

    protected Option buildBundleWithBnd(Class ... classes) {
        TinyBundle bundle = TinyBundles.bundle();
        for (Class clazz : classes) {
            bundle.add(clazz);
        }
        return (Option)CoreOptions.streamBundle((InputStream)bundle.build((BuildStrategy)TinyBundles.withBnd())).start();
    }
}

