/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1Optional;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceSuperInterface3;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class Service3OsgiR6 {
    @Reference
    private ServiceInterface1 reference1;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile ServiceInterface1Optional reference1Optional;
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ServiceReference<ServiceInterface2>> references2 = new ArrayList<ServiceReference<ServiceInterface2>>();
    @Reference(service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ServiceSuperInterface3> references3;
    @Reference(service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, target="(prop1=abc)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ServiceSuperInterface3> references3Filtered;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, name="reference3DynamicFiltered")
    private volatile ServiceSuperInterface3 reference3DynamicFiltered;
    @Reference(service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, fieldOption=FieldOption.UPDATE)
    private volatile Set<ServiceSuperInterface3> references3Set;
    @Reference(service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile Collection<ServiceSuperInterface3> references3Collection;
    private ComponentContext componentContext;
    private Map<String, Object> config;

    @Activate
    private void activate(ComponentContext ctx) {
        this.componentContext = ctx;
        this.config = new HashMap<String, Object>();
        Enumeration keys = ctx.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.config.put(key, ctx.getProperties().get(key));
        }
    }

    @Deactivate
    private void deactivate(ComponentContext ctx) {
        this.componentContext = null;
    }

    @Modified
    private void modified(Map<String, Object> newConfig) {
        this.config = newConfig;
    }

    public ServiceInterface1 getReference1() {
        return this.reference1;
    }

    public ServiceInterface1Optional getReference1Optional() {
        return this.reference1Optional;
    }

    public List<ServiceInterface2> getReferences2() {
        ArrayList<ServiceInterface2> services = new ArrayList<ServiceInterface2>();
        for (ServiceReference<ServiceInterface2> serviceReference : this.references2) {
            services.add((ServiceInterface2)this.componentContext.getBundleContext().getService(serviceReference));
        }
        return services;
    }

    public List<ServiceSuperInterface3> getReferences3() {
        return this.references3;
    }

    public List<ServiceSuperInterface3> getReferences3Filtered() {
        return this.references3Filtered;
    }

    public ServiceSuperInterface3 getReference3DynamicFiltered() {
        return this.reference3DynamicFiltered;
    }

    public Set<ServiceSuperInterface3> getReferences3Set() {
        return this.references3Set;
    }

    public Collection<ServiceSuperInterface3> getReferences3Collection() {
        return this.references3Collection;
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }
}

