/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sling.testing.mock.osgi.config.AbstractConfigTypeReflectionProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractConfigTypeReflectionProviderTest {
    @Test
    public void testAnnotationTypedConfig() throws Exception {
        AbstractConfigTypeReflectionProvider provider = AbstractConfigTypeReflectionProvider.getInstance(AnnotationConfig.class);
        Assert.assertTrue((boolean)provider.isValidConfigType());
        Assert.assertEquals(AnnotationConfig.class, (Object)provider.getConfigType());
        Assert.assertEquals(Map.of("size", 10, "name", "Fred"), (Object)provider.getPropertyMap((Object)HasAnnotationConfig.class.getAnnotation(AnnotationConfig.class)));
        Assert.assertEquals(Map.of("size", 5, "name", "Dave"), (Object)provider.getDefaults(Collections.emptyMap()));
        HasAnnotationConfig config = new HasAnnotationConfig();
        Method inaccessibleMethod = HasAnnotationConfig.class.getDeclaredMethod("getInaccessibleValue", new Class[0]);
        Method invocationTargetValue = HasAnnotationConfig.class.getDeclaredMethod("getInvocationTargetValue", new Class[0]);
        Assert.assertNull((Object)provider.invokeAttribute(inaccessibleMethod, (Object)config));
        Assert.assertNull((Object)provider.invokeAttribute(invocationTargetValue, (Object)config));
    }

    @Test
    public void testInvalidAnnotationTypedConfig() {
        AbstractConfigTypeReflectionProvider provider = AbstractConfigTypeReflectionProvider.getInstance(InvalidAnnotationConfig.class);
        Assert.assertFalse((boolean)provider.isValidConfigType());
        Assert.assertEquals(InvalidAnnotationConfig.class, (Object)provider.getConfigType());
        Assert.assertEquals(Map.of("size", 10, "name", "Fred"), (Object)provider.getPropertyMap((Object)HasAnnotationConfig.class.getAnnotation(InvalidAnnotationConfig.class)));
        Assert.assertEquals(Collections.emptyMap(), (Object)provider.getDefaults(Collections.emptyMap()));
        Assert.assertFalse((boolean)provider.addSingleDefault("other.config", (Object)HasAnnotationConfig.class.getAnnotation(InvalidAnnotationConfig.class).other_config(), Collections.emptyMap()));
    }

    @Test
    public void testInterfaceTypedConfig() {
        AbstractConfigTypeReflectionProvider provider = AbstractConfigTypeReflectionProvider.getInstance(InterfaceConfig.class);
        Assert.assertTrue((boolean)provider.isValidConfigType());
        Assert.assertEquals(InterfaceConfig.class, (Object)provider.getConfigType());
        Assert.assertEquals(Collections.emptyMap(), (Object)provider.getDefaults(Collections.emptyMap()));
        InterfaceConfig mocked = (InterfaceConfig)Mockito.mock(InterfaceConfig.class);
        ((InterfaceConfig)Mockito.doReturn((Object)10).when((Object)mocked)).size();
        Assert.assertEquals(Map.of("size", 10), (Object)provider.getPropertyMap((Object)mocked));
        AbstractConfigTypeReflectionProvider invalidProvider = AbstractConfigTypeReflectionProvider.getInstance(InvalidInterfaceConfig.class);
        Assert.assertFalse((boolean)invalidProvider.isValidConfigType());
        Assert.assertEquals(InvalidInterfaceConfig.class, (Object)invalidProvider.getConfigType());
    }

    public static interface InvalidInterfaceConfig {
        public int size();

        public String name();

        public void setName(String var1);
    }

    public static interface InterfaceConfig {
        public int size();

        public String name();
    }

    @AnnotationConfig(size=10, name="Fred")
    @InvalidAnnotationConfig(size=10, name="Fred", other_config=@AnnotationConfig(size=2, name="Willy"))
    public static class HasAnnotationConfig {
        private String getInaccessibleValue() {
            return "";
        }

        public String getInvocationTargetValue() {
            throw new NotImplementedException("not implemented!");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InvalidAnnotationConfig {
        public int size() default 5;

        public String name() default "Dave";

        public AnnotationConfig other_config() default @AnnotationConfig(size=3, name="Alice");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AnnotationConfig {
        public int size() default 5;

        public String name() default "Dave";
    }
}

