/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3OsgiR6;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3OsgiR6ComponentServiceObjectsImpl;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3OsgiR6Impl;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service4;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service5;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceFactory1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface5;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OsgiServiceUtilTest {
    private BundleContext bundleContext = MockOsgi.newBundleContext();
    private Service1 service1;
    private Service2 service2;

    @Before
    public void setUp() {
        this.service1 = new Service1();
        this.service2 = new Service2();
        this.bundleContext.registerService(ServiceInterface1.class.getName(), (Object)this.service1, null);
        this.bundleContext.registerService(ServiceInterface2.class.getName(), (Object)this.service2, null);
        this.bundleContext.registerService(ServiceInterface3.class.getName(), (Object)this.service2, null);
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testService3() {
        Service3 service3 = new Service3();
        Assert.assertTrue((boolean)MockOsgi.injectServices((Object)service3, (BundleContext)this.bundleContext));
        Hashtable<String, String> service3Config = new Hashtable<String, String>();
        ((Dictionary)service3Config).put("prop1", "value1");
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service3, (BundleContext)this.bundleContext, service3Config));
        Assert.assertNotNull((Object)service3.getComponentContext());
        Assert.assertEquals(((Dictionary)service3Config).get("prop1"), service3.getComponentContext().getProperties().get("prop1"));
        Assert.assertSame((Object)this.service1, (Object)service3.getReference1());
        List references2 = service3.getReferences2();
        Assert.assertEquals((long)1L, (long)references2.size());
        Assert.assertSame((Object)this.service2, references2.get(0));
        List references3 = service3.getReferences3();
        Assert.assertEquals((long)1L, (long)references3.size());
        Assert.assertSame((Object)this.service2, references3.get(0));
        List reference3Configs = service3.getReference3Configs();
        Assert.assertEquals((long)1L, (long)reference3Configs.size());
        Set references3Set = service3.getReferences3Set();
        Assert.assertEquals((long)1L, (long)references3Set.size());
        Assert.assertSame((Object)this.service2, references3Set.iterator().next());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service3, (BundleContext)this.bundleContext));
        Assert.assertNull((Object)service3.getComponentContext());
    }

    @Test
    public void testService3OsgiR6() {
        this.testService3OsgiR6((Service3OsgiR6)new Service3OsgiR6Impl());
    }

    @Test
    public void testService3OsgiR6ComponentServiceObjects() {
        this.testService3OsgiR6((Service3OsgiR6)new Service3OsgiR6ComponentServiceObjectsImpl());
    }

    private void testService3OsgiR6(Service3OsgiR6 service3) {
        Assert.assertTrue((boolean)MockOsgi.injectServices((Object)service3, (BundleContext)this.bundleContext));
        Hashtable<String, String> service3Config = new Hashtable<String, String>();
        ((Dictionary)service3Config).put("prop1", "value1");
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service3, (BundleContext)this.bundleContext, service3Config));
        Assert.assertNotNull((Object)service3.getComponentContext());
        Assert.assertEquals(((Dictionary)service3Config).get("prop1"), service3.getComponentContext().getProperties().get("prop1"));
        Assert.assertSame((Object)this.service1, (Object)service3.getReference1());
        List references2 = service3.getReferences2();
        Assert.assertEquals((long)1L, (long)references2.size());
        Assert.assertSame((Object)this.service2, references2.get(0));
        List references3 = service3.getReferences3();
        Assert.assertEquals((long)1L, (long)references3.size());
        Assert.assertSame((Object)this.service2, references3.get(0));
        Set references3Set = service3.getReferences3Set();
        Assert.assertEquals((long)1L, (long)references3Set.size());
        Assert.assertSame((Object)this.service2, references3Set.iterator().next());
        Collection references3Collection = service3.getReferences3Collection();
        Assert.assertEquals((long)1L, (long)references3Collection.size());
        Assert.assertSame((Object)this.service2, references3Collection.iterator().next());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service3, (BundleContext)this.bundleContext));
        Assert.assertNull((Object)service3.getComponentContext());
    }

    @Test
    public void testService3_Config() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        ImmutableMap initialProperites = ImmutableMap.of((Object)"prop1", (Object)"value1");
        Service3 service3 = new Service3();
        MockOsgi.activate((Object)service3, (BundleContext)bundleContext, (Map)initialProperites);
        Assert.assertEquals(initialProperites.get("prop1"), service3.getConfig().get("prop1"));
        ImmutableMap newProperties = ImmutableMap.of((Object)"prop2", (Object)"value2");
        MockOsgi.modified((Object)service3, (BundleContext)bundleContext, (Map)newProperties);
        Assert.assertEquals(newProperties.get("prop2"), service3.getConfig().get("prop2"));
        newProperties = ImmutableMap.of((Object)"prop3", (Object)"value3");
        Hashtable newPropertiesDictonary = new Hashtable(newProperties);
        MockOsgi.modified((Object)service3, (BundleContext)bundleContext, newPropertiesDictonary);
        Assert.assertEquals(newProperties.get("prop3"), service3.getConfig().get("prop3"));
        MockOsgi.modified((Object)service3, (BundleContext)bundleContext, (Object[])new Object[]{"prop3", "value4"});
        Assert.assertEquals((Object)"value4", service3.getConfig().get("prop3"));
    }

    @Test
    public void testService4() {
        Service4 service4 = new Service4();
        Assert.assertTrue((boolean)MockOsgi.injectServices((Object)service4, (BundleContext)this.bundleContext));
        Assert.assertFalse((boolean)MockOsgi.activate((Object)service4, (BundleContext)this.bundleContext));
        Assert.assertSame((Object)this.service1, (Object)service4.getReference1());
    }

    @Test(expected=NoScrMetadataException.class)
    public void testInjectServicesNoMetadata() {
        MockOsgi.injectServices((Object)new Object(), (BundleContext)MockOsgi.newBundleContext());
    }

    @Test(expected=NoScrMetadataException.class)
    public void testActivateNoMetadata() {
        MockOsgi.activate((Object)new Object(), (BundleContext)this.bundleContext);
    }

    @Test(expected=NoScrMetadataException.class)
    public void testDeactivateNoMetadata() {
        MockOsgi.deactivate((Object)new Object(), (BundleContext)this.bundleContext);
    }

    @Test(expected=NoScrMetadataException.class)
    public void testModifiedNoMetadata() {
        MockOsgi.modified((Object)new Object(), (BundleContext)MockOsgi.newBundleContext(), (Map)ImmutableMap.of());
    }

    @Test
    public void testMockedService() {
        Service5 service5 = (Service5)Mockito.spy((Object)new Service5());
        ((Service5)Mockito.doReturn((Object)true).when((Object)service5)).doRemoteThing();
        MockOsgi.injectServices((Object)service5, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)service5, (BundleContext)this.bundleContext, (Dictionary)null);
        this.bundleContext.registerService(ServiceInterface5.class.getName(), (Object)service5, null);
        Assert.assertSame((Object)service5, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(ServiceInterface5.class.getName())));
        Assert.assertEquals((Object)true, (Object)service5.doRemoteThing());
    }

    @Test
    public void testServiceFactoryViaScr() {
        ServiceFactory1 serviceFactory1 = new ServiceFactory1();
        MockOsgi.injectServices((Object)serviceFactory1, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)serviceFactory1, (BundleContext)this.bundleContext, (Dictionary)null);
        this.bundleContext.registerService(ServiceFactory1.class.getName(), (Object)serviceFactory1, null);
        Assert.assertSame((Object)serviceFactory1, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(ServiceFactory1.class.getName())));
    }

    @Test
    public void testServiceFactoryViaManualRegistration() {
        final ServiceFactory1 serviceFactory1 = new ServiceFactory1();
        this.bundleContext.registerService(ServiceFactory1.class.getName(), (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return serviceFactory1;
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, null);
        Assert.assertSame((Object)serviceFactory1, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(ServiceFactory1.class.getName())));
    }
}

