/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MatchAllFilter;
import org.apache.sling.testing.mock.osgi.MockBundle;
import org.apache.sling.testing.mock.osgi.MockConfigurationAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.MockServiceReference;
import org.apache.sling.testing.mock.osgi.MockServiceRegistration;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import osgimock.org.apache.felix.framework.FilterImpl;

class MockBundleContext
implements BundleContext {
    private final MockBundle bundle;
    private final SortedSet<MockServiceRegistration> registeredServices = new ConcurrentSkipListSet<MockServiceRegistration>();
    private final Map<ServiceListener, Filter> serviceListeners = new ConcurrentHashMap<ServiceListener, Filter>();
    private final Queue<BundleListener> bundleListeners = new ConcurrentLinkedQueue<BundleListener>();
    private final ConfigurationAdmin configAdmin = new MockConfigurationAdmin(this);
    private File dataFileBaseDir;
    private final Bundle systemBundle;
    private static final Logger log = LoggerFactory.getLogger(MockBundleContext.class);
    private static final Comparator<ServiceReference> SR_COMPARATOR_HIGHEST_RANKING_FIRST = new Comparator<ServiceReference>(){

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o2.compareTo((Object)o1);
        }
    };

    public MockBundleContext() {
        log.debug("Creating MockBundleContext, bundleContext={}", (Object)this);
        this.systemBundle = new MockBundle(this, 0L);
        this.bundle = new MockBundle(this);
        this.registerService(ConfigurationAdmin.class.getName(), (Object)this.configAdmin, null);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Filter createFilter(String s) throws InvalidSyntaxException {
        if (s == null) {
            return new MatchAllFilter();
        }
        return new FilterImpl(s);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = StringUtils.isBlank((CharSequence)clazz) ? new String[]{} : new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        if (log.isDebugEnabled()) {
            log.debug("Register {} ({}), bundleContext={}", new Object[]{service.getClass().getName(), StringUtils.join((Object[])clazzes, (String)","), this});
        }
        MockServiceRegistration<Object> registration = new MockServiceRegistration<Object>(this.bundle, clazzes, service, properties, this);
        this.registeredServices.add(registration);
        this.handleRefsUpdateOnRegister(registration);
        this.notifyServiceListeners(1, registration.getReference());
        return registration;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), factory, properties);
    }

    private void handleRefsUpdateOnRegister(MockServiceRegistration<?> registration) {
        List<OsgiServiceUtil.ReferenceInfo<?>> affectedDynamicReferences = OsgiServiceUtil.getMatchingDynamicReferences(this.registeredServices, registration);
        block8: for (OsgiServiceUtil.ReferenceInfo<?> referenceInfo : affectedDynamicReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            Object o = referenceInfo.getServiceRegistration().getProperties().get(reference.getName() + ".target");
            if (o instanceof String) {
                reference = new OsgiMetadataUtil.DynamicReference(reference, (String)o);
            }
            if (!reference.matchesTargetFilter(registration.getReference())) continue;
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: {
                    continue block8;
                }
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    OsgiServiceUtil.invokeBindMethod(reference, referenceInfo.getServiceRegistration().getService(), new OsgiServiceUtil.ServiceInfo(registration));
                    continue block8;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
        List<OsgiServiceUtil.ReferenceInfo<?>> affectedStaticGreedyReferences = OsgiServiceUtil.getMatchingStaticGreedyReferences(this.registeredServices, registration);
        HashSet servicesToRestart = new HashSet();
        block9: for (OsgiServiceUtil.ReferenceInfo<?> referenceInfo : affectedStaticGreedyReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            if (!reference.matchesTargetFilter(registration.getReference())) continue;
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: {
                    continue block9;
                }
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    servicesToRestart.add(referenceInfo.getServiceRegistration());
                    continue block9;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
        servicesToRestart.forEach(this::restartService);
    }

    void unregisterService(MockServiceRegistration<?> registration) {
        boolean wasRemoved;
        if (log.isDebugEnabled()) {
            Object componentInstance = registration.getService();
            log.debug("Unregister {} ({}), bundleContext={}", new Object[]{componentInstance != null ? componentInstance.getClass() : "", StringUtils.join(registration.getClasses(), (String)","), this});
        }
        if (!(wasRemoved = this.registeredServices.remove(registration))) {
            throw new IllegalStateException("Service was already unregistered");
        }
        this.handleRefsUpdateOnUnregister(registration);
        this.notifyServiceListeners(4, registration.getReference());
    }

    void restartService(@NotNull MockServiceRegistration<?> registration) {
        Class<?> serviceClass = registration.getService().getClass();
        Map<String, Object> properties = registration.getPropertiesAsMap();
        MockOsgi.deactivate(registration.getService(), this);
        this.unregisterService(registration);
        Object newService = MockOsgi.activateInjectServices(serviceClass, (BundleContext)this, properties);
        String[] serviceInterfaces = registration.getClasses().toArray(new String[registration.getClasses().size()]);
        this.registerService(serviceInterfaces, newService, MapUtil.toDictionary(properties));
    }

    private void handleRefsUpdateOnUnregister(MockServiceRegistration<?> registration) {
        List<OsgiServiceUtil.ReferenceInfo<?>> affectedDynamicReferences = OsgiServiceUtil.getMatchingDynamicReferences(this.registeredServices, registration);
        block6: for (OsgiServiceUtil.ReferenceInfo<?> referenceInfo : affectedDynamicReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            if (!reference.matchesTargetFilter(registration.getReference())) continue;
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: 
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    OsgiServiceUtil.invokeUnbindMethod(reference, referenceInfo.getServiceRegistration().getService(), new OsgiServiceUtil.ServiceInfo(registration));
                    continue block6;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
        List<OsgiServiceUtil.ReferenceInfo<?>> affectedStaticGreedyReferences = OsgiServiceUtil.getMatchingStaticGreedyReferences(this.registeredServices, registration);
        HashSet servicesToRestart = new HashSet();
        block7: for (OsgiServiceUtil.ReferenceInfo<?> referenceInfo : affectedStaticGreedyReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            if (!reference.matchesTargetFilter(registration.getReference())) continue;
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: 
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    servicesToRestart.add(referenceInfo.getServiceRegistration());
                    continue block7;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
        servicesToRestart.forEach(this::restartService);
    }

    public ServiceReference getServiceReference(String clazz) {
        try {
            ServiceReference[] serviceRefs = this.getServiceReferences(clazz, null);
            if (serviceRefs != null && serviceRefs.length > 0) {
                return serviceRefs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return null;
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        TreeSet<ServiceReference> result = new TreeSet<ServiceReference>(SR_COMPARATOR_HIGHEST_RANKING_FIRST);
        for (MockServiceRegistration serviceRegistration : this.registeredServices) {
            if (!serviceRegistration.matches(clazz, filter)) continue;
            result.add(serviceRegistration.getReference());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference[] result = this.getServiceReferences(clazz.getName(), filter);
        if (result == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(result);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(clazz, filter);
    }

    public <S> S getService(ServiceReference<S> serviceReference) {
        return (S)((MockServiceReference)serviceReference).getService();
    }

    public boolean ungetService(ServiceReference serviceReference) {
        return false;
    }

    public void addServiceListener(ServiceListener serviceListener) {
        try {
            this.addServiceListener(serviceListener, null);
        }
        catch (InvalidSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addServiceListener(ServiceListener serviceListener, String filter) throws InvalidSyntaxException {
        this.serviceListeners.put(serviceListener, this.createFilter(filter));
    }

    public void removeServiceListener(ServiceListener serviceListener) {
        this.serviceListeners.remove(serviceListener);
    }

    void notifyServiceListeners(int eventType, ServiceReference serviceReference) {
        ServiceEvent event = new ServiceEvent(eventType, serviceReference);
        for (Map.Entry<ServiceListener, Filter> entry : this.serviceListeners.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().match(serviceReference)) continue;
            entry.getKey().serviceChanged(event);
        }
    }

    public void addBundleListener(BundleListener bundleListener) {
        if (!this.bundleListeners.contains(bundleListener)) {
            this.bundleListeners.add(bundleListener);
        }
    }

    public void removeBundleListener(BundleListener bundleListener) {
        this.bundleListeners.remove(bundleListener);
    }

    void sendBundleEvent(BundleEvent bundleEvent) {
        for (BundleListener bundleListener : this.bundleListeners) {
            bundleListener.bundleChanged(bundleEvent);
        }
    }

    public void addFrameworkListener(FrameworkListener frameworkListener) {
    }

    public void removeFrameworkListener(FrameworkListener frameworkListener) {
    }

    <S> S locateService(String name, ServiceReference<S> reference) {
        for (MockServiceRegistration serviceRegistration : this.registeredServices) {
            if (serviceRegistration.getReference() != reference) continue;
            return (S)serviceRegistration.getService();
        }
        return null;
    }

    public Bundle[] getBundles() {
        return new Bundle[0];
    }

    public String getProperty(String s) {
        return System.getProperty(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataFile(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        MockBundleContext mockBundleContext = this;
        synchronized (mockBundleContext) {
            if (this.dataFileBaseDir == null) {
                try {
                    this.dataFileBaseDir = Files.createTempDirectory("osgi-mock", new FileAttribute[0]).toFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error creating temp. directory.", ex);
                }
            }
        }
        if (path.isEmpty()) {
            return this.dataFileBaseDir;
        }
        return new File(this.dataFileBaseDir, path);
    }

    public void shutdown() {
        log.debug("Shutting down MockBundleContext, bundleContext={}", (Object)this);
        ArrayList<MockServiceRegistration> reversedRegisteredServices = new ArrayList<MockServiceRegistration>(this.registeredServices);
        Collections.reverse(reversedRegisteredServices);
        HashSet deactivatedComponents = new HashSet();
        for (MockServiceRegistration serviceRegistration : reversedRegisteredServices) {
            Object componentInstance = serviceRegistration.getService();
            if (deactivatedComponents.contains(componentInstance)) continue;
            try {
                MockOsgi.deactivate(componentInstance, (BundleContext)this, serviceRegistration.getProperties());
            }
            catch (NoScrMetadataException noScrMetadataException) {
                // empty catch block
            }
            deactivatedComponents.add(componentInstance);
        }
        if (this.dataFileBaseDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.dataFileBaseDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Bundle getBundle(long bundleId) {
        if (bundleId == 0L) {
            return this.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(String location) {
        if (StringUtils.equals((CharSequence)location, (CharSequence)"System Bundle")) {
            return this.systemBundle;
        }
        return null;
    }

    public <S> ServiceObjects<S> getServiceObjects(final ServiceReference<S> reference) {
        return new ServiceObjects<S>(){

            public S getService() {
                return MockBundleContext.this.getService(reference);
            }

            public void ungetService(S service) {
                MockBundleContext.this.ungetService(reference);
            }

            public ServiceReference<S> getServiceReference() {
                return reference;
            }
        };
    }

    public Bundle installBundle(String s) {
        throw new UnsupportedOperationException();
    }

    public Bundle installBundle(String s, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

