/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestScanner {
    private static final Logger log = LoggerFactory.getLogger(ManifestScanner.class);

    private ManifestScanner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Collection<String> getValues(@NotNull String attributeName) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        try {
            Enumeration<URL> resEnum = ManifestScanner.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    try {
                        Manifest manifest = new Manifest(is);
                        Attributes mainAttribs = manifest.getMainAttributes();
                        String valueList = mainAttribs.getValue(attributeName);
                        String[] valueArray = StringUtils.split((String)valueList, (String)",");
                        if (valueArray == null) continue;
                        for (String value : valueArray) {
                            if (StringUtils.isBlank((CharSequence)value)) continue;
                            values.add(StringUtils.trim((String)value));
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Throwable ex) {
                    log.warn("Unable to read JAR manifest.", ex);
                }
            }
        }
        catch (IOException ex) {
            log.warn("Unable to read JAR manifests.", (Throwable)ex);
        }
        return values;
    }
}

