/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.bindunbind.Service1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.bindunbind.Service2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.bindunbind.Service3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.bindunbind.Service4;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.bindunbind.Service5;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@RunWith(value=MockitoJUnitRunner.class)
public class OsgiServiceUtilBindUnbindTest {
    private BundleContext bundleContext;
    private ServiceRegistration<ServiceInterface1> reg1a;
    private ServiceRegistration<ServiceInterface1> reg1b;
    private Map<String, Object> props1a = MapUtil.toMap((Object[])new Object[]{"prop1", "1a"});
    private Map<String, Object> props1b = MapUtil.toMap((Object[])new Object[]{"prop1", "1b"});
    private Map<String, Object> props1c = MapUtil.toMap((Object[])new Object[]{"prop1", "1c"});
    @Mock
    private ServiceInterface1 instance1a;
    @Mock
    private ServiceInterface1 instance1b;
    @Mock
    private ServiceInterface1 instance1c;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
        this.reg1a = this.registerReference(this.instance1a, this.props1a);
        this.reg1b = this.registerReference(this.instance1b, this.props1b);
    }

    @Test
    public void testService1() {
        Service1 service = this.registerInjectService(new Service1());
        this.assertItems(service.getInstances(), this.instance1a, this.instance1b);
        this.registerReference(this.instance1c, this.props1c);
        this.assertItems(service.getInstances(), this.instance1a, this.instance1b, this.instance1c);
        this.reg1a.unregister();
        this.assertItems(service.getInstances(), this.instance1b, this.instance1c);
    }

    @Test
    public void testService2() {
        Service2 service = this.registerInjectService(new Service2());
        this.assertItems(service.getReferences(), this.reg1a.getReference(), this.reg1b.getReference());
        ServiceRegistration<ServiceInterface1> reg1c = this.registerReference(this.instance1c, this.props1c);
        this.assertItems(service.getReferences(), this.reg1a.getReference(), this.reg1b.getReference(), reg1c.getReference());
        this.reg1a.unregister();
        this.assertItems(service.getReferences(), this.reg1b.getReference(), reg1c.getReference());
    }

    @Test
    public void testService3() {
        Service3 service = this.registerInjectService(new Service3());
        this.assertItems(service.getReferences(), this.reg1a.getReference(), this.reg1b.getReference());
        this.assertItems(service.getInstances(), this.instance1a, this.instance1b);
        ServiceRegistration<ServiceInterface1> reg1c = this.registerReference(this.instance1c, this.props1c);
        this.assertItems(service.getInstances(), this.instance1a, this.instance1b, this.instance1c);
        this.assertItems(service.getReferences(), this.reg1a.getReference(), this.reg1b.getReference(), reg1c.getReference());
        this.reg1a.unregister();
        this.assertItems(service.getInstances(), this.instance1b, this.instance1c);
        this.assertItems(service.getReferences(), this.reg1b.getReference(), reg1c.getReference());
    }

    @Test
    public void testService4() {
        Service4 service = this.registerInjectService(new Service4());
        this.assertMaps(service.getConfigs(), this.props1a, this.props1b);
        this.registerReference(this.instance1c, this.props1c);
        this.assertMaps(service.getConfigs(), this.props1a, this.props1b, this.props1c);
        this.reg1a.unregister();
        this.assertMaps(service.getConfigs(), this.props1b, this.props1c);
    }

    @Test
    public void testService5() {
        Service5 service = this.registerInjectService(new Service5());
        this.assertItems(service.getReferences(), this.reg1a.getReference(), this.reg1b.getReference());
        this.assertItems(service.getInstances(), this.instance1a, this.instance1b);
        this.assertMaps(service.getConfigs(), this.props1a, this.props1b);
        ServiceRegistration<ServiceInterface1> reg1c = this.registerReference(this.instance1c, this.props1c);
        this.assertItems(service.getInstances(), this.instance1a, this.instance1b, this.instance1c);
        this.assertItems(service.getReferences(), this.reg1a.getReference(), this.reg1b.getReference(), reg1c.getReference());
        this.assertMaps(service.getConfigs(), this.props1a, this.props1b, this.props1c);
        this.reg1a.unregister();
        this.assertItems(service.getInstances(), this.instance1b, this.instance1c);
        this.assertItems(service.getReferences(), this.reg1b.getReference(), reg1c.getReference());
        this.assertMaps(service.getConfigs(), this.props1b, this.props1c);
    }

    private <T> T registerInjectService(T service) {
        MockOsgi.injectServices(service, (BundleContext)this.bundleContext);
        this.bundleContext.registerService(service.getClass(), service, (Dictionary)null);
        return service;
    }

    private <T extends ServiceInterface1> ServiceRegistration<ServiceInterface1> registerReference(T instance, Map<String, Object> props) {
        return this.bundleContext.registerService(ServiceInterface1.class, instance, MapUtil.toDictionary(props));
    }

    @SafeVarargs
    private final <T> void assertItems(List<T> actual, T ... expected) {
        Assert.assertEquals((Object)ImmutableSet.copyOf((Object[])expected), (Object)ImmutableSet.copyOf(actual));
    }

    @SafeVarargs
    private final <T> void assertMaps(List<Map<String, Object>> actual, Map<String, Object> ... expected) {
        List actualFiltered = actual.stream().map(actualItem -> Maps.filterEntries((Map)actualItem, item -> ((String)item.getKey()).equals("prop1"))).collect(Collectors.toList());
        this.assertItems(actualFiltered, expected);
    }
}

