/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sling.testing.mock.osgi.context.AbstractContextPlugin;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContextPlugins {
    @NotNull
    private final List<ContextPlugin<? extends OsgiContextImpl>> plugins = new ArrayList<ContextPlugin<? extends OsgiContextImpl>>();

    public ContextPlugins() {
    }

    public <T extends OsgiContextImpl> ContextPlugins(@NotNull ContextCallback<T> afterSetUpCallback) {
        this.addAfterSetUpCallback(afterSetUpCallback);
    }

    public <U extends OsgiContextImpl, V extends OsgiContextImpl> ContextPlugins(@NotNull ContextCallback<U> afterSetUpCallback, @NotNull ContextCallback<V> beforeTearDownCallback) {
        this.addAfterSetUpCallback(afterSetUpCallback);
        this.addBeforeTearDownCallback(beforeTearDownCallback);
    }

    @SafeVarargs
    public final <T extends OsgiContextImpl> void addPlugin(ContextPlugin<T> ... plugin) {
        for (ContextPlugin<T> item : plugin) {
            if (item == null) continue;
            this.plugins.add(item);
        }
    }

    @SafeVarargs
    public final <T extends OsgiContextImpl> void addBeforeSetUpCallback(ContextCallback<T> ... beforeSetUpCallback) {
        for (final ContextCallback<T> item : beforeSetUpCallback) {
            if (item == null) continue;
            this.plugins.add(new AbstractContextPlugin<T>(){

                @Override
                public void beforeSetUp(@NotNull T context) throws Exception {
                    item.execute(context);
                }

                public String toString() {
                    return item.toString();
                }
            });
        }
    }

    @SafeVarargs
    public final <T extends OsgiContextImpl> void addAfterSetUpCallback(ContextCallback<T> ... afterSetUpCallback) {
        for (final ContextCallback<T> item : afterSetUpCallback) {
            if (item == null) continue;
            this.plugins.add(new AbstractContextPlugin<T>(){

                @Override
                public void afterSetUp(@NotNull T context) throws Exception {
                    item.execute(context);
                }

                public String toString() {
                    return item.toString();
                }
            });
        }
    }

    @SafeVarargs
    public final <T extends OsgiContextImpl> void addBeforeTearDownCallback(ContextCallback<T> ... beforeTearDownCallback) {
        for (final ContextCallback<T> item : beforeTearDownCallback) {
            if (item == null) continue;
            this.plugins.add(new AbstractContextPlugin<T>(){

                @Override
                public void beforeTearDown(@NotNull T context) throws Exception {
                    item.execute(context);
                }

                public String toString() {
                    return item.toString();
                }
            });
        }
    }

    @SafeVarargs
    public final <T extends OsgiContextImpl> void addAfterTearDownCallback(ContextCallback<T> ... afterTearDownCallback) {
        for (final ContextCallback<T> item : afterTearDownCallback) {
            if (item == null) continue;
            this.plugins.add(new AbstractContextPlugin<T>(){

                @Override
                public void afterTearDown(@NotNull T context) throws Exception {
                    item.execute(context);
                }

                public String toString() {
                    return item.toString();
                }
            });
        }
    }

    @NotNull
    public Collection<ContextPlugin<? extends OsgiContextImpl>> getPlugins() {
        return this.plugins;
    }

    public <T extends OsgiContextImpl> void executeBeforeSetUpCallback(@NotNull T context) {
        for (ContextPlugin<? extends OsgiContextImpl> plugin : this.plugins) {
            try {
                plugin.beforeSetUp(context);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Before setup failed (" + plugin.toString() + "): " + ex.getMessage(), ex);
            }
        }
    }

    public <T extends OsgiContextImpl> void executeAfterSetUpCallback(@NotNull T context) {
        for (ContextPlugin<? extends OsgiContextImpl> plugin : this.plugins) {
            try {
                plugin.afterSetUp(context);
            }
            catch (Throwable ex) {
                throw new RuntimeException("After setup failed (" + plugin.toString() + "): " + ex.getMessage(), ex);
            }
        }
    }

    public <T extends OsgiContextImpl> void executeBeforeTearDownCallback(@NotNull T context) {
        for (ContextPlugin<? extends OsgiContextImpl> plugin : this.plugins) {
            try {
                plugin.beforeTearDown(context);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Before teardown failed (" + plugin.toString() + "): " + ex.getMessage(), ex);
            }
        }
    }

    public <T extends OsgiContextImpl> void executeAfterTearDownCallback(@NotNull T context) {
        for (ContextPlugin<? extends OsgiContextImpl> plugin : this.plugins) {
            try {
                plugin.afterTearDown(context);
            }
            catch (Throwable ex) {
                throw new RuntimeException("After teardown failed (" + plugin.toString() + "): " + ex.getMessage(), ex);
            }
        }
    }
}

