/*
 * Decompiled with CFR 0.152.
 */
package osgimock.org.apache.felix.framework.wiring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import osgimock.org.apache.felix.framework.capabilityset.SimpleFilter;
import osgimock.org.apache.felix.framework.util.ImmutableMap;
import osgimock.org.apache.felix.framework.util.Util;
import osgimock.org.apache.felix.framework.util.manifestparser.ManifestParser;

public class BundleCapabilityImpl
implements BundleCapability {
    public static final String VERSION_ATTR = "version";
    private final BundleRevision m_revision;
    private final String m_namespace;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;
    private final List<String> m_uses;
    private final List<List<String>> m_includeFilter;
    private final List<List<String>> m_excludeFilter;
    private final Set<String> m_mandatory;

    public BundleCapabilityImpl(BundleRevision revision, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        List<String> substrings;
        int filterIdx;
        List<String> filters;
        this.m_namespace = namespace;
        this.m_revision = revision;
        this.m_dirs = ImmutableMap.newInstance(dirs);
        this.m_attrs = ImmutableMap.newInstance(attrs);
        ArrayList<String> uses = Collections.EMPTY_LIST;
        String value = this.m_dirs.get("uses");
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            uses = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreTokens()) {
                uses.add(tok.nextToken().trim());
            }
        }
        this.m_uses = uses;
        value = this.m_dirs.get("include");
        if (value != null) {
            filters = ManifestParser.parseDelimitedString(value, ",");
            this.m_includeFilter = new ArrayList<List<String>>(filters.size());
            for (filterIdx = 0; filterIdx < filters.size(); ++filterIdx) {
                substrings = SimpleFilter.parseSubstring(filters.get(filterIdx));
                this.m_includeFilter.add(substrings);
            }
        } else {
            this.m_includeFilter = null;
        }
        if ((value = this.m_dirs.get("exclude")) != null) {
            filters = ManifestParser.parseDelimitedString(value, ",");
            this.m_excludeFilter = new ArrayList<List<String>>(filters.size());
            for (filterIdx = 0; filterIdx < filters.size(); ++filterIdx) {
                substrings = SimpleFilter.parseSubstring(filters.get(filterIdx));
                this.m_excludeFilter.add(substrings);
            }
        } else {
            this.m_excludeFilter = null;
        }
        HashSet<String> mandatory = Collections.EMPTY_SET;
        value = this.m_dirs.get("mandatory");
        if (value != null) {
            List<String> names = ManifestParser.parseDelimitedString(value, ",");
            mandatory = new HashSet<String>(names.size());
            for (String name : names) {
                if (this.m_attrs.containsKey(name)) {
                    mandatory.add(name);
                    continue;
                }
                throw new IllegalArgumentException("Mandatory attribute '" + name + "' does not exist.");
            }
        }
        this.m_mandatory = mandatory;
    }

    public BundleRevision getResource() {
        return this.m_revision;
    }

    public BundleRevision getRevision() {
        return this.m_revision;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    public boolean isAttributeMandatory(String name) {
        return !this.m_mandatory.isEmpty() && this.m_mandatory.contains(name);
    }

    public List<String> getUses() {
        return this.m_uses;
    }

    public boolean isIncluded(String name) {
        if (this.m_includeFilter == null && this.m_excludeFilter == null) {
            return true;
        }
        String className = Util.getClassName(name);
        boolean included = this.m_includeFilter == null;
        for (int i = 0; !included && this.m_includeFilter != null && i < this.m_includeFilter.size(); ++i) {
            included = SimpleFilter.compareSubstring(this.m_includeFilter.get(i), className);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && this.m_excludeFilter != null && i < this.m_excludeFilter.size(); ++i) {
            excluded = SimpleFilter.compareSubstring(this.m_excludeFilter.get(i), className);
        }
        return included && !excluded;
    }

    public String toString() {
        if (this.m_revision == null) {
            return this.m_attrs.toString();
        }
        return "[" + this.m_revision + "] " + this.m_namespace + "; " + this.m_attrs;
    }
}

