/*
 * Decompiled with CFR 0.152.
 */
package osgimock.org.apache.felix.framework.cache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import osgimock.org.apache.felix.framework.Logger;
import osgimock.org.apache.felix.framework.cache.BundleArchiveRevision;
import osgimock.org.apache.felix.framework.cache.BundleCache;
import osgimock.org.apache.felix.framework.cache.DirectoryRevision;
import osgimock.org.apache.felix.framework.cache.JarRevision;
import osgimock.org.apache.felix.framework.util.WeakZipFileFactory;

public class BundleArchive {
    public static final transient String FILE_PROTOCOL = "file:";
    public static final transient String REFERENCE_PROTOCOL = "reference:";
    public static final transient String INPUTSTREAM_PROTOCOL = "inputstream:";
    private static final transient String BUNDLE_INFO_FILE = "bundle.info";
    private static final transient String REVISION_LOCATION_FILE = "revision.location";
    private static final transient String REVISION_DIRECTORY = "version";
    private static final transient String DATA_DIRECTORY = "data";
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final File m_archiveRootDir;
    private final boolean m_isSingleBundleFile;
    private long m_id = -1L;
    private String m_originalLocation = null;
    private int m_persistentState = -1;
    private int m_startLevel = -1;
    private long m_lastModified = -1L;
    private long m_refreshCount = -1L;
    private final SortedMap<Long, BundleArchiveRevision> m_revisions = new TreeMap<Long, BundleArchiveRevision>();
    private static final transient String BUNDLE_ID_FILE = "bundle.id";
    private static final transient String BUNDLE_LOCATION_FILE = "bundle.location";
    private static final transient String BUNDLE_STATE_FILE = "bundle.state";
    private static final transient String BUNDLE_START_LEVEL_FILE = "bundle.startlevel";
    private static final transient String BUNDLE_LASTMODIFIED_FILE = "bundle.lastmodified";
    private static final transient String REFRESH_COUNTER_FILE = "refresh.counter";
    private static final transient String ACTIVE_STATE = "active";
    private static final transient String STARTING_STATE = "starting";
    private static final transient String INSTALLED_STATE = "installed";
    private static final transient String UNINSTALLED_STATE = "uninstalled";

    public BundleArchive(Logger logger, Map configMap, WeakZipFileFactory zipFactory, File archiveRootDir, long id, int startLevel, String location, InputStream is) throws Exception {
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_zipFactory = zipFactory;
        this.m_archiveRootDir = archiveRootDir;
        this.m_id = id;
        if (this.m_id <= 0L) {
            throw new IllegalArgumentException("Bundle ID cannot be less than or equal to zero.");
        }
        this.m_originalLocation = location;
        this.m_persistentState = 2;
        this.m_startLevel = startLevel;
        this.m_lastModified = System.currentTimeMillis();
        this.m_refreshCount = 0L;
        String s = (String)this.m_configMap.get("felix.cache.singlebundlefile");
        this.m_isSingleBundleFile = s == null || s.equalsIgnoreCase("true");
        this.initialize();
        this.reviseInternal(false, new Long(0L), this.m_originalLocation, is);
    }

    public BundleArchive(Logger logger, Map configMap, WeakZipFileFactory zipFactory, File archiveRootDir) throws Exception {
        File[] children;
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_zipFactory = zipFactory;
        this.m_archiveRootDir = archiveRootDir;
        String s = (String)this.m_configMap.get("felix.cache.singlebundlefile");
        boolean bl = this.m_isSingleBundleFile = s == null || s.equalsIgnoreCase("true");
        if (this.m_isSingleBundleFile) {
            this.readBundleInfo();
        }
        for (File child : children = this.m_archiveRootDir.listFiles()) {
            int idx;
            if (!child.getName().startsWith(REVISION_DIRECTORY) || !child.isDirectory() || (idx = child.getName().lastIndexOf(46)) <= 0) continue;
            Long revNum = Long.decode(child.getName().substring(idx + 1));
            this.m_revisions.put(revNum, null);
        }
        if (this.m_revisions.isEmpty()) {
            throw new Exception("No valid revisions in bundle archive directory: " + archiveRootDir);
        }
        Long currentRevNum = this.m_revisions.lastKey();
        this.m_revisions.remove(currentRevNum);
        this.reviseInternal(true, currentRevNum, this.getRevisionLocation(currentRevNum), null);
    }

    public synchronized long getId() throws Exception {
        if (this.m_id <= 0L) {
            this.m_id = this.readId();
        }
        return this.m_id;
    }

    public synchronized String getLocation() throws Exception {
        if (this.m_originalLocation == null) {
            this.m_originalLocation = this.readLocation();
        }
        return this.m_originalLocation;
    }

    public synchronized int getPersistentState() throws Exception {
        if (this.m_persistentState < 0) {
            this.m_persistentState = this.readPersistentState();
        }
        return this.m_persistentState;
    }

    public synchronized void setPersistentState(int state) throws Exception {
        if (this.m_persistentState != state) {
            this.m_persistentState = state;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writePersistentState();
            }
        }
    }

    public synchronized int getStartLevel() throws Exception {
        if (this.m_startLevel < 0) {
            this.m_startLevel = this.readStartLevel();
        }
        return this.m_startLevel;
    }

    public synchronized void setStartLevel(int level) throws Exception {
        if (this.m_startLevel != level) {
            this.m_startLevel = level;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeStartLevel();
            }
        }
    }

    public synchronized long getLastModified() throws Exception {
        if (this.m_lastModified < 0L) {
            this.m_lastModified = this.readLastModified();
        }
        return this.m_lastModified;
    }

    public synchronized void setLastModified(long lastModified) throws Exception {
        if (this.m_lastModified != lastModified) {
            this.m_lastModified = lastModified;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeLastModified();
            }
        }
    }

    private long getRefreshCount() throws Exception {
        if (this.m_refreshCount < 0L) {
            this.m_refreshCount = this.readRefreshCount();
        }
        return this.m_refreshCount;
    }

    private void setRefreshCount(long count) throws Exception {
        if (this.m_refreshCount != count) {
            this.m_refreshCount = count;
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeRefreshCount();
            }
        }
    }

    public synchronized File getDataFile(String fileName) throws Exception {
        if (fileName.length() > 0 && fileName.charAt(0) == File.separatorChar) {
            throw new IllegalArgumentException("The data file path must be relative, not absolute.");
        }
        if (fileName.indexOf("..") >= 0) {
            throw new IllegalArgumentException("The data file path cannot contain a reference to the \"..\" directory.");
        }
        File dataDir = new File(this.m_archiveRootDir, DATA_DIRECTORY);
        if (!BundleCache.getSecureAction().fileExists(dataDir) && !BundleCache.getSecureAction().mkdir(dataDir)) {
            throw new IOException("Unable to create bundle data directory.");
        }
        return new File(dataDir, fileName);
    }

    public synchronized Long getCurrentRevisionNumber() {
        return this.m_revisions.isEmpty() ? null : this.m_revisions.lastKey();
    }

    public synchronized BundleArchiveRevision getCurrentRevision() {
        return this.m_revisions.isEmpty() ? null : (BundleArchiveRevision)this.m_revisions.get(this.m_revisions.lastKey());
    }

    public synchronized boolean isRemovalPending() {
        return this.m_revisions.size() > 1;
    }

    public synchronized void revise(String location, InputStream is) throws Exception {
        Long revNum = this.m_revisions.isEmpty() ? new Long(0L) : new Long(this.m_revisions.lastKey() + 1L);
        this.reviseInternal(false, revNum, location, is);
    }

    private void reviseInternal(boolean isReload, Long revNum, String location, InputStream is) throws Exception {
        BundleArchiveRevision revision;
        if (is != null) {
            location = INPUTSTREAM_PROTOCOL;
        }
        if ((revision = this.createRevisionFromLocation(location, is, revNum)) == null) {
            throw new Exception("Unable to revise archive.");
        }
        if (!isReload) {
            this.setRevisionLocation(location, revNum);
        }
        this.m_revisions.put(revNum, revision);
    }

    public synchronized boolean rollbackRevise() throws Exception {
        if (this.m_revisions.size() <= 1) {
            return false;
        }
        Long revNum = this.m_revisions.lastKey();
        BundleArchiveRevision revision = (BundleArchiveRevision)this.m_revisions.remove(revNum);
        try {
            revision.close();
        }
        catch (Exception ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to dispose latest revision", ex);
        }
        File revisionDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revNum.toString());
        if (BundleCache.getSecureAction().fileExists(revisionDir)) {
            BundleCache.deleteDirectoryTree(revisionDir);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getRevisionLocation(Long revNum) throws Exception {
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revNum.toString()), REVISION_LOCATION_FILE));
            br = new BufferedReader(new InputStreamReader(is));
            String string = br.readLine();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setRevisionLocation(String location, Long revNum) throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(new File(new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revNum.toString()), REVISION_LOCATION_FILE));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            bw.write(location, 0, location.length());
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public synchronized void close() {
        for (BundleArchiveRevision revision : this.m_revisions.values()) {
            if (revision == null) continue;
            try {
                revision.close();
            }
            catch (Exception ex) {
                this.m_logger.log(1, "Unable to close revision - " + revision.getRevisionRootDir(), ex);
            }
        }
    }

    public synchronized void closeAndDelete() {
        this.close();
        if (!BundleCache.deleteDirectoryTree(this.m_archiveRootDir)) {
            this.m_logger.log(1, "Unable to delete archive directory - " + this.m_archiveRootDir);
        }
    }

    public synchronized void purge() throws Exception {
        Long currentRevNum = this.getCurrentRevisionNumber();
        boolean hasNativeLibs = this.getCurrentRevision().getManifestHeader().containsKey("Bundle-NativeCode");
        this.close();
        long refreshCount = this.getRefreshCount();
        for (Long revNum : this.m_revisions.keySet()) {
            if (revNum.equals(currentRevNum)) continue;
            File revisionDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + refreshCount + "." + revNum.toString());
            if (!BundleCache.getSecureAction().fileExists(revisionDir)) continue;
            BundleCache.deleteDirectoryTree(revisionDir);
        }
        if (hasNativeLibs) {
            this.setRefreshCount(refreshCount + 1L);
            File currentDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + (refreshCount + 1L) + "." + currentRevNum.toString());
            File revisionDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + refreshCount + "." + currentRevNum.toString());
            BundleCache.getSecureAction().renameFile(revisionDir, currentDir);
        }
        this.m_revisions.clear();
        BundleArchiveRevision revision = this.createRevisionFromLocation(this.getRevisionLocation(currentRevNum), null, currentRevNum);
        this.m_revisions.put(currentRevNum, revision);
    }

    private void initialize() throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            if (BundleCache.getSecureAction().fileExists(this.m_archiveRootDir)) {
                return;
            }
            if (!BundleCache.getSecureAction().mkdir(this.m_archiveRootDir)) {
                this.m_logger.log(1, this.getClass().getName() + ": Unable to create archive directory.");
                throw new IOException("Unable to create archive directory.");
            }
            if (this.m_isSingleBundleFile) {
                this.writeBundleInfo();
            } else {
                this.writeId();
                this.writeLocation();
                this.writePersistentState();
                this.writeStartLevel();
                this.writeLastModified();
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private BundleArchiveRevision createRevisionFromLocation(String location, InputStream is, Long revNum) throws Exception {
        File revisionRootDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revNum.toString());
        BundleArchiveRevision result = null;
        try {
            if (location != null && location.startsWith(REFERENCE_PROTOCOL)) {
                if (!(location = location.substring(REFERENCE_PROTOCOL.length())).startsWith(FILE_PROTOCOL)) {
                    throw new IOException("Reference URLs can only be files: " + location);
                }
                location = BundleArchive.decode(location);
                File file = new File(location.substring(FILE_PROTOCOL.length()));
                if (!BundleCache.getSecureAction().fileExists(file)) {
                    throw new IOException("Referenced file does not exist: " + file);
                }
                result = BundleCache.getSecureAction().isFileDirectory(file) ? new DirectoryRevision(this.m_logger, this.m_configMap, this.m_zipFactory, revisionRootDir, location) : new JarRevision(this.m_logger, this.m_configMap, this.m_zipFactory, revisionRootDir, location, true, null);
            } else {
                result = location.startsWith(INPUTSTREAM_PROTOCOL) ? new JarRevision(this.m_logger, this.m_configMap, this.m_zipFactory, revisionRootDir, location, false, is) : new JarRevision(this.m_logger, this.m_configMap, this.m_zipFactory, revisionRootDir, location, false, null);
            }
        }
        catch (Exception ex) {
            if (BundleCache.getSecureAction().fileExists(revisionRootDir) && !BundleCache.deleteDirectoryTree(revisionRootDir)) {
                this.m_logger.log(1, this.getClass().getName() + ": Unable to delete revision directory - " + revisionRootDir);
            }
            throw ex;
        }
        return result;
    }

    private static String decode(String s) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= s.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = Character.digit(s.charAt(i + 1), 16);
                    int d2 = Character.digit(s.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + s.substring(i, i + 3) + ") at: " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                result.append(out.toString("UTF-8"));
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBundleInfo() throws Exception {
        File infoFile = new File(this.m_archiveRootDir, BUNDLE_INFO_FILE);
        FileInputStream is = null;
        BufferedReader br = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(infoFile);
            br = new BufferedReader(new InputStreamReader(is));
            this.m_id = Long.parseLong(br.readLine());
            this.m_originalLocation = br.readLine();
            this.m_persistentState = Integer.parseInt(br.readLine());
            this.m_startLevel = Integer.parseInt(br.readLine());
            this.m_lastModified = Long.parseLong(br.readLine());
            this.m_refreshCount = Long.parseLong(br.readLine());
        }
        catch (FileNotFoundException ex) {
            this.m_id = this.readId();
            this.m_originalLocation = this.readLocation();
            this.m_persistentState = this.readPersistentState();
            this.m_startLevel = this.readStartLevel();
            this.m_lastModified = this.readLastModified();
            this.m_refreshCount = this.readRefreshCount();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    private void writeBundleInfo() throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_INFO_FILE));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            String s = Long.toString(this.m_id);
            bw.write(s, 0, s.length());
            bw.newLine();
            s = this.m_originalLocation == null ? "" : this.m_originalLocation;
            bw.write(s, 0, s.length());
            bw.newLine();
            s = Integer.toString(this.m_persistentState);
            bw.write(s, 0, s.length());
            bw.newLine();
            s = Integer.toString(this.m_startLevel);
            bw.write(s, 0, s.length());
            bw.newLine();
            s = Long.toString(this.m_lastModified);
            bw.write(s, 0, s.length());
            bw.newLine();
            s = Long.toString(this.m_refreshCount);
            bw.write(s, 0, s.length());
            bw.newLine();
        }
        catch (IOException ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to cache bundle info - " + ex);
            throw ex;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private void writeId() throws Exception {
        FileOutputStream os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_ID_FILE));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        bw.write(Long.toString(this.m_id), 0, Long.toString(this.m_id).length());
        bw.close();
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readId() throws Exception {
        long id;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_ID_FILE));
            br = new BufferedReader(new InputStreamReader(is));
            id = Long.parseLong(br.readLine());
        }
        catch (FileNotFoundException ex) {
            id = Long.parseLong(this.m_archiveRootDir.getName().substring("bundle".length()));
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return id;
    }

    private void writeLocation() throws Exception {
        FileOutputStream os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_LOCATION_FILE));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        bw.write(this.m_originalLocation, 0, this.m_originalLocation.length());
        bw.close();
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLocation() throws Exception {
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_LOCATION_FILE));
            br = new BufferedReader(new InputStreamReader(is));
            String string = br.readLine();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private void writePersistentState() throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_STATE_FILE));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            String s = null;
            switch (this.m_persistentState) {
                case 32: {
                    s = ACTIVE_STATE;
                    break;
                }
                case 8: {
                    s = STARTING_STATE;
                    break;
                }
                case 1: {
                    s = UNINSTALLED_STATE;
                    break;
                }
                default: {
                    s = INSTALLED_STATE;
                }
            }
            bw.write(s, 0, s.length());
        }
        catch (IOException ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to record state - " + ex);
            throw ex;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPersistentState() throws Exception {
        int state = 2;
        File stateFile = new File(this.m_archiveRootDir, BUNDLE_STATE_FILE);
        if (BundleCache.getSecureAction().fileExists(stateFile)) {
            FileInputStream is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(stateFile);
                br = new BufferedReader(new InputStreamReader(is));
                String s = br.readLine();
                state = s != null && s.equals(ACTIVE_STATE) ? 32 : (s != null && s.equals(STARTING_STATE) ? 8 : (s != null && s.equals(UNINSTALLED_STATE) ? 1 : 2));
            }
            catch (Exception ex) {
                state = 2;
            }
            finally {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return state;
    }

    private void writeStartLevel() throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_START_LEVEL_FILE));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            String s = Integer.toString(this.m_startLevel);
            bw.write(s, 0, s.length());
        }
        catch (IOException ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to record start level - " + ex);
            throw ex;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readStartLevel() throws Exception {
        int level = -1;
        File levelFile = new File(this.m_archiveRootDir, BUNDLE_START_LEVEL_FILE);
        if (!BundleCache.getSecureAction().fileExists(levelFile)) {
            level = -1;
        } else {
            FileInputStream is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(levelFile);
                br = new BufferedReader(new InputStreamReader(is));
                level = Integer.parseInt(br.readLine());
            }
            finally {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return level;
    }

    private void writeLastModified() throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_LASTMODIFIED_FILE));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            String s = Long.toString(this.m_lastModified);
            bw.write(s, 0, s.length());
        }
        catch (IOException ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to record start level - " + ex);
            throw ex;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLastModified() throws Exception {
        long last = 0L;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_LASTMODIFIED_FILE));
            br = new BufferedReader(new InputStreamReader(is));
            last = Long.parseLong(br.readLine());
        }
        catch (Exception ex) {
            last = 0L;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return last;
    }

    private void writeRefreshCount() throws Exception {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, REFRESH_COUNTER_FILE));
            bw = new BufferedWriter(new OutputStreamWriter(os));
            String s = Long.toString(this.m_refreshCount);
            bw.write(s, 0, s.length());
        }
        catch (IOException ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to write refresh count: " + ex);
            throw ex;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readRefreshCount() throws Exception {
        long count = 0L;
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, REFRESH_COUNTER_FILE));
            br = new BufferedReader(new InputStreamReader(is));
            count = Long.parseLong(br.readLine());
        }
        catch (Exception ex) {
            count = 0L;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return count;
    }
}

