/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MockBundle;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MockBundleTest {
    private MockBundle bundle;

    @Before
    public void setUp() {
        this.bundle = (MockBundle)MockOsgi.newBundleContext().getBundle();
    }

    @Test
    public void testBundleId() {
        Assert.assertTrue((this.bundle.getBundleId() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBundleContxt() {
        Assert.assertNotNull((Object)this.bundle.getBundleContext());
    }

    @Test
    public void testGetEntry() {
        Assert.assertNotNull((Object)this.bundle.getEntry("/META-INF/test.txt"));
        Assert.assertNotNull((Object)this.bundle.getEntry("META-INF/test.txt"));
        Assert.assertNull((Object)this.bundle.getEntry("/invalid"));
    }

    @Test
    public void testGetStatie() {
        Assert.assertEquals((long)32L, (long)this.bundle.getState());
    }

    @Test
    public void testGetHeaders() {
        this.bundle.setHeaders((Map)ImmutableMap.of((Object)"prop1", (Object)"value1"));
        Assert.assertEquals((Object)"value1", this.bundle.getHeaders().get("prop1"));
        Assert.assertEquals((Object)"value1", this.bundle.getHeaders("en").get("prop1"));
    }

    @Test
    public void testGetSymbolicName() throws Exception {
        this.bundle.setSymbolicName("name-1");
        Assert.assertEquals((Object)"name-1", (Object)this.bundle.getSymbolicName());
    }

    @Test
    public void testGetLastModified() {
        this.bundle.setLastModified(42L);
        Assert.assertEquals((long)42L, (long)this.bundle.getLastModified());
    }

    @Test
    public void getEntryPaths_noMatches() {
        Assert.assertNull((Object)this.bundle.getEntryPaths("resources"));
    }

    @Test
    public void getEntryPaths() {
        Enumeration entryPaths = this.bundle.getEntryPaths("bundleData");
        ArrayList paths = Collections.list(entryPaths);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertTrue((boolean)paths.contains("bundleData/nested/"));
    }

    @Test
    public void getEntryPaths_leadingSlash() {
        Enumeration entryPaths = this.bundle.getEntryPaths("bundleData");
        ArrayList paths = Collections.list(entryPaths);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertTrue((boolean)paths.contains("bundleData/nested/"));
    }

    @Test
    public void getEntryPaths_slash() {
        Enumeration entryPaths = this.bundle.getEntryPaths("/");
        ArrayList paths = Collections.list(entryPaths);
        Assert.assertTrue((paths.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expect OSGI-INF/ in " + paths), (boolean)paths.contains("OSGI-INF/"));
        Assert.assertTrue((String)("Expect META-INF/ in " + paths), (boolean)paths.contains("META-INF/"));
    }

    @Test
    public void getEntryPaths_empty() {
        Enumeration entryPaths = this.bundle.getEntryPaths("");
        ArrayList paths = Collections.list(entryPaths);
        Assert.assertTrue((paths.size() >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expect OSGI-INF/ in " + paths), (boolean)paths.contains("OSGI-INF/"));
        Assert.assertTrue((String)("Expect META-INF/ in " + paths), (boolean)paths.contains("META-INF/"));
    }

    @Test
    public void getEntryPaths_noMatch() {
        Assert.assertNull((Object)this.bundle.getEntryPaths("/EMPTY"));
        Assert.assertNull((Object)this.bundle.getEntryPaths("EMPTY"));
    }

    @Test
    public void getEntryPaths_Nested() {
        Enumeration entryPaths = this.bundle.getEntryPaths("bundleData/nested");
        ArrayList paths = Collections.list(entryPaths);
        Assert.assertEquals((long)2L, (long)paths.size());
        Assert.assertTrue((boolean)paths.contains("bundleData/nested/first.txt"));
        Assert.assertTrue((boolean)paths.contains("bundleData/nested/second.txt"));
    }
}

