/*
 * Decompiled with CFR 0.152.
 */
package osgimock.org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import osgimock.org.apache.felix.framework.Felix;
import osgimock.org.apache.felix.framework.URLHandlers;
import osgimock.org.apache.felix.framework.URLHandlersBundleURLConnection;
import osgimock.org.apache.felix.framework.util.SecureAction;
import osgimock.org.apache.felix.framework.util.Util;

class URLHandlersBundleStreamHandler
extends URLStreamHandler {
    private final Felix m_framework;
    private final SecureAction m_action;

    public URLHandlersBundleStreamHandler(Felix framework) {
        this.m_framework = framework;
        this.m_action = null;
    }

    public URLHandlersBundleStreamHandler(SecureAction action) {
        this.m_framework = null;
        this.m_action = action;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (!"felix".equals(url.getAuthority())) {
            this.checkPermission(url);
        }
        if (this.m_framework != null) {
            return new URLHandlersBundleURLConnection(url, this.m_framework);
        }
        Object framework = URLHandlers.getFrameworkFromContext();
        if (framework != null) {
            if (framework instanceof Felix) {
                return new URLHandlersBundleURLConnection(url, (Felix)framework);
            }
            try {
                Class<?> targetClass = framework.getClass().getClassLoader().loadClass(URLHandlersBundleURLConnection.class.getName());
                Constructor constructor = this.m_action.getConstructor(targetClass, new Class[]{URL.class, framework.getClass().getClassLoader().loadClass(Felix.class.getName())});
                this.m_action.setAccesssible(constructor);
                return (URLConnection)this.m_action.invoke(constructor, new Object[]{url, framework});
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
        }
        throw new IOException("No framework context found");
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        super.parseURL(u, spec, start, limit);
        if (this.checkPermission(u)) {
            super.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), "felix", u.getUserInfo(), u.getPath(), u.getQuery(), u.getRef());
        }
    }

    @Override
    protected String toExternalForm(URL u) {
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append("://");
        result.append(u.getHost());
        result.append(':');
        result.append(u.getPort());
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    @Override
    protected InetAddress getHostAddress(URL u) {
        return null;
    }

    private boolean checkPermission(URL u) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Object framework = this.m_framework;
            if (framework == null && !((framework = URLHandlers.getFrameworkFromContext()) instanceof Felix)) {
                return false;
            }
            Object felix = framework;
            long bundleId = Util.getBundleIdFromRevisionId(u.getHost());
            Bundle bundle = ((Felix)felix).getBundle(bundleId);
            if (bundle != null) {
                sm.checkPermission((Permission)new AdminPermission(bundle, "resource"));
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

