/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.MockNamespaceRegistry;
import org.apache.sling.testing.mock.jcr.MockNodeTypeManager;
import org.apache.sling.testing.mock.jcr.MockNodeTypes;
import org.apache.sling.testing.mock.jcr.MockObservationManager;
import org.apache.sling.testing.mock.jcr.MockSession;

class MockRepository
implements Repository {
    private final Map<String, ItemData> items = new LinkedHashMap<String, ItemData>();
    private final NamespaceRegistry namespaceRegistry = new MockNamespaceRegistry();
    private final ObservationManager observationManager = new MockObservationManager();
    private final NodeTypeManager nodeTypeManager = new MockNodeTypeManager();

    public MockRepository() {
        this.items.put("/", ItemData.newNode("/", MockNodeTypes.NT_UNSTRUCTURED));
    }

    public Session login() throws RepositoryException {
        return this.login(null, null);
    }

    public Session login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(Credentials credentials, String workspaceName) throws RepositoryException {
        String userId = null;
        if (credentials instanceof SimpleCredentials) {
            userId = ((SimpleCredentials)credentials).getUserID();
        }
        return new MockSession(this, this.items, StringUtils.defaultString((String)userId, (String)"admin"), StringUtils.defaultString((String)workspaceName, (String)"mockedWorkspace"));
    }

    public String[] getDescriptorKeys() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public boolean isStandardDescriptor(String key) {
        return false;
    }

    public boolean isSingleValueDescriptor(String key) {
        return false;
    }

    public Value getDescriptorValue(String key) {
        return null;
    }

    public Value[] getDescriptorValues(String key) {
        return null;
    }

    public String getDescriptor(String key) {
        return null;
    }

    NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    ObservationManager getObservationManager() {
        return this.observationManager;
    }

    NodeTypeManager getNodeTypeManager() {
        return this.nodeTypeManager;
    }
}

