/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.Reader;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.query.QueryManager;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.sling.testing.mock.jcr.MockNodeTypeManager;
import org.apache.sling.testing.mock.jcr.MockQuery;
import org.apache.sling.testing.mock.jcr.MockQueryManager;
import org.apache.sling.testing.mock.jcr.MockQueryResult;
import org.apache.sling.testing.mock.jcr.MockQueryResultHandler;
import org.apache.sling.testing.mock.jcr.MockRepository;
import org.apache.sling.testing.mock.jcr.MockSession;
import org.apache.sling.testing.mock.jcr.MockTemplateBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public final class MockJcr {
    public static final String DEFAULT_WORKSPACE = "mockedWorkspace";
    public static final String DEFAULT_USER_ID = "admin";

    private MockJcr() {
    }

    @NotNull
    public static Repository newRepository() {
        return new MockRepository();
    }

    @NotNull
    public static Session newSession() {
        return MockJcr.newSession(null, null);
    }

    @NotNull
    public static Session newSession(@Nullable String userId, @Nullable String workspaceName) {
        try {
            return MockJcr.newRepository().login((Credentials)new SimpleCredentials(StringUtils.defaultString((String)userId, (String)DEFAULT_USER_ID), new char[0]), StringUtils.defaultString((String)workspaceName, (String)DEFAULT_WORKSPACE));
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Creating mocked JCR session failed.", ex);
        }
    }

    public static void setQueryResult(@NotNull Session session, @NotNull List<Node> resultList) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), resultList);
    }

    public static void setQueryResult(@NotNull Session session, @NotNull List<Node> resultList, boolean simulateUnknownSize) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), resultList, simulateUnknownSize);
    }

    public static void setQueryResult(@NotNull QueryManager queryManager, @NotNull List<Node> resultList) {
        MockJcr.setQueryResult(queryManager, resultList, false);
    }

    public static void setQueryResult(@NotNull QueryManager queryManager, @NotNull List<Node> resultList, boolean simulateUnknownSize) {
        MockJcr.addQueryResultHandler(queryManager, (MockQuery query) -> {
            MockQueryResult result = new MockQueryResult(resultList);
            result.setSimulateUnknownSize(simulateUnknownSize);
            return result;
        });
    }

    public static void setQueryResult(@NotNull Session session, @NotNull String statement, @NotNull String language, @NotNull List<Node> resultList) {
        MockJcr.setQueryResult(session, statement, language, resultList, false);
    }

    public static void setQueryResult(@NotNull Session session, @NotNull String statement, @NotNull String language, @NotNull List<Node> resultList, boolean simulateUnknownSize) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), statement, language, resultList, simulateUnknownSize);
    }

    public static void setQueryResult(@NotNull QueryManager queryManager, @NotNull String statement, @NotNull String language, @NotNull List<Node> resultList) {
        MockJcr.setQueryResult(queryManager, statement, language, resultList, false);
    }

    public static void setQueryResult(@NotNull QueryManager queryManager, @NotNull String statement, @NotNull String language, @NotNull List<Node> resultList, boolean simulateUnknownSize) {
        MockJcr.addQueryResultHandler(queryManager, (MockQuery query) -> {
            if (StringUtils.equals((CharSequence)query.getStatement(), (CharSequence)statement) && StringUtils.equals((CharSequence)query.getLanguage(), (CharSequence)language)) {
                MockQueryResult mockQueryResult = new MockQueryResult(resultList);
                mockQueryResult.setSimulateUnknownSize(simulateUnknownSize);
                return mockQueryResult;
            }
            return null;
        });
    }

    public static void addQueryResultHandler(@NotNull Session session, @NotNull MockQueryResultHandler resultHandler) {
        MockJcr.addQueryResultHandler(MockJcr.getQueryManager(session), resultHandler);
    }

    public static void addQueryResultHandler(@NotNull QueryManager queryManager, @NotNull MockQueryResultHandler resultHandler) {
        ((MockQueryManager)queryManager).addResultHandler(resultHandler);
    }

    @NotNull
    private static QueryManager getQueryManager(@NotNull Session session) {
        try {
            return session.getWorkspace().getQueryManager();
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to access query manager.", ex);
        }
    }

    public static void loadNodeTypeDefs(@NotNull Session session, @NotNull Reader reader) throws ParseException, RepositoryException {
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        ((MockNodeTypeManager)nodeTypeManager).setMode(MockNodeTypeManager.ResolveMode.ONLY_REGISTERED);
        MockTemplateBuilderFactory factory = new MockTemplateBuilderFactory(session);
        CompactNodeTypeDefReader cndReader = new CompactNodeTypeDefReader(reader, "cnd input stream", (DefinitionBuilderFactory)factory);
        List nodeTypeDefinitions = cndReader.getNodeTypeDefinitions();
        for (NodeTypeTemplate nodeTypeDefinition : nodeTypeDefinitions) {
            nodeTypeManager.registerNodeType((NodeTypeDefinition)nodeTypeDefinition, true);
        }
    }

    public static void setAccessControlManager(@NotNull Session session, @Nullable AccessControlManager acm) {
        ((MockSession)session).setAccessControlManager(acm);
    }
}

