/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.Objects;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.MockSession;
import org.apache.sling.testing.mock.jcr.ResourceUtil;

abstract class AbstractItem
implements Item {
    protected final ItemData itemData;
    private final Session session;

    protected AbstractItem(ItemData itemData, Session session) {
        this.itemData = itemData;
        this.session = session;
    }

    public String getName() throws RepositoryException {
        return this.itemData.getName();
    }

    public String getPath() throws RepositoryException {
        return this.itemData.getPath();
    }

    public Node getParent() throws RepositoryException {
        return (Node)this.getSession().getItem(ResourceUtil.getParent(this.getPath()));
    }

    public Session getSession() throws RepositoryException {
        return this.session;
    }

    public boolean isModified() {
        return this.itemData.isChanged();
    }

    public boolean isNew() {
        return this.itemData.isNew();
    }

    public Item getAncestor(int depth) throws RepositoryException {
        if (depth < 0 || depth > this.getDepth()) {
            throw new ItemNotFoundException();
        }
        return this.session.getItem(ResourceUtil.getParent(this.getPath(), this.getDepth() - depth));
    }

    protected String makeAbsolutePath(String relativePath) throws RepositoryException {
        String absolutePath = relativePath;
        if (!StringUtils.startsWith((CharSequence)absolutePath, (CharSequence)"/")) {
            absolutePath = this.getPath() + "/" + absolutePath;
        }
        return ResourceUtil.normalize(absolutePath);
    }

    protected MockSession getMockedSession() {
        return (MockSession)this.session;
    }

    public void remove() throws RepositoryException {
        this.getSession().removeItem(this.getPath());
    }

    public int getDepth() throws RepositoryException {
        if (StringUtils.equals((CharSequence)"/", (CharSequence)this.getPath())) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)this.getPath(), (CharSequence)"/");
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        boolean same = false;
        if (Objects.equals(this.getSession().getRepository(), otherItem.getSession().getRepository()) && Objects.equals(this.getSession().getWorkspace().getName(), otherItem.getSession().getWorkspace().getName())) {
            if (this.isNode() && otherItem.isNode()) {
                if (Objects.equals(((Node)this).getIdentifier(), ((Node)otherItem).getIdentifier())) {
                    same = true;
                }
            } else if (!this.isNode() && !otherItem.isNode() && Objects.equals(this.getName(), otherItem.getName()) && this.getParent().isSame((Item)otherItem.getParent())) {
                same = true;
            }
        }
        return same;
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void save() throws RepositoryException {
        throw new UnsupportedOperationException();
    }
}

