/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.Bundle;

public class BundleInfo {
    private JsonNode bundle;

    public BundleInfo(JsonNode root) throws ClientException {
        if (root.get("id") != null) {
            if (root.get("id") == null) {
                throw new ClientException("No Bundle Info returned");
            }
            this.bundle = root;
        } else {
            if (root.get("data") == null && root.get("data").size() < 1) {
                throw new ClientException("No Bundle Info returned");
            }
            this.bundle = root.get("data").get(0);
        }
    }

    public int getId() {
        return this.bundle.get("id").intValue();
    }

    public String getName() {
        return this.bundle.get("name").textValue();
    }

    public String getVersion() {
        return this.bundle.get("version").textValue();
    }

    public boolean isFragment() {
        return this.bundle.get("fragment").booleanValue();
    }

    public Bundle.Status getStatus() {
        return Bundle.Status.value(this.bundle.get("state").textValue());
    }

    public String getSymbolicName() {
        return this.bundle.get("symbolicName").textValue();
    }

    public String getCategory() {
        return this.bundle.get("category").textValue();
    }

    public String getProperty(String key) {
        Map<String, String> props = this.getProperties();
        return props.get(key);
    }

    public Map<String, String> getProperties() {
        JsonNode props = this.bundle.get("props");
        HashMap<String, String> entries = new HashMap<String, String>();
        if (props != null) {
            Iterator it = props.elements();
            while (it.hasNext()) {
                JsonNode n = (JsonNode)it.next();
                entries.put(n.get("key").textValue(), n.get("value").textValue());
            }
        }
        return entries;
    }
}

