/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.query.servlet.QueryServlet;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryClient
extends SlingClient {
    private static final Logger LOG = LoggerFactory.getLogger(QueryClient.class);
    private static final String BUNDLE_BSN = "org.apache.sling.testing.clients.query";
    private static final String BUNDLE_NAME = "Sling Testing Clients Query Servlet";
    private static final String BUNDLE_VERSION = "1.0.0";
    private static final long BUNDLE_START_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);

    public QueryClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public QueryClient(URI url, String user, String password) throws ClientException {
        super(url, user, password);
    }

    public JsonNode doQuery(String query, QueryType type) throws ClientException, InterruptedException {
        return this.doQuery(query, type, true, false);
    }

    public long doCount(String query, QueryType type) throws ClientException, InterruptedException {
        return this.doQuery(query, type, false, false).get("total").getLongValue();
    }

    public String getPlan(String query, QueryType type) throws ClientException, InterruptedException {
        return this.doQuery(query, type, false, true).get("plan").toString();
    }

    protected JsonNode doQuery(String query, QueryType type, boolean showResults, boolean explain) throws ClientException, InterruptedException {
        List<NameValuePair> params = URLParameterBuilder.create().add("query", query).add("type", type.toString()).add("showresults", Boolean.toString(showResults)).add("explain", Boolean.toString(explain)).getList();
        try {
            SlingHttpResponse response = this.doGet("/system/testing/query", params, 200);
            return JsonUtils.getJsonNodeFromString(response.getContent());
        }
        catch (ClientException e) {
            if (e.getHttpStatusCode() == 404) {
                LOG.info("Could not find query servlet, will try to install it");
                this.installServlet();
                LOG.info("Retrying the query");
                SlingHttpResponse response = this.doGet("/system/testing/query", params, 200);
                return JsonUtils.getJsonNodeFromString(response.getContent());
            }
            throw e;
        }
    }

    public QueryClient installServlet() throws ClientException, InterruptedException {
        InputStream bundleStream = TinyBundles.bundle().set("Bundle-SymbolicName", BUNDLE_BSN).set("Bundle-Version", BUNDLE_VERSION).set("Bundle-Name", BUNDLE_NAME).add(QueryServlet.class).build((BuildStrategy)TinyBundles.withBnd());
        try {
            File bundleFile = File.createTempFile("org.apache.sling.testing.clients.query-1.0.0", ".jar");
            Files.copy(bundleStream, bundleFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.adaptTo(OsgiConsoleClient.class).installBundle(bundleFile, true);
            this.adaptTo(OsgiConsoleClient.class).waitBundleStarted(BUNDLE_BSN, BUNDLE_START_TIMEOUT, 100L);
            LOG.info("query servlet installed at {}", (Object)this.getUrl("/system/testing/query"));
        }
        catch (IOException e) {
            throw new ClientException("Failed to create the query servlet bundle", e);
        }
        catch (TimeoutException e) {
            throw new ClientException("The query servlet bundle did not successfully start", e);
        }
        return this;
    }

    public QueryClient uninstallServlet() throws ClientException {
        this.adaptTo(OsgiConsoleClient.class).uninstallBundle(BUNDLE_BSN);
        return this;
    }

    public static enum QueryType {
        SQL2("JCR-SQL2"),
        SQL("sql"),
        XPATH("xpath"),
        JQOM("JCR-JQOM");

        private final String name;

        private QueryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

