/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.interceptors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.sling.testing.clients.interceptors.HttpRequestResponseInterceptor;
import org.apache.sling.testing.clients.util.ServerErrorRetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormBasedAuthInterceptor
implements HttpRequestInterceptor,
HttpRequestResponseInterceptor {
    static final Logger LOG = LoggerFactory.getLogger(FormBasedAuthInterceptor.class);
    private final String loginPath = "j_security_check";
    private final String loginTokenName;

    public FormBasedAuthInterceptor(String loginTokenName) {
        this.loginTokenName = loginTokenName;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        URI uri = URI.create(request.getRequestLine().getUri());
        if (uri.getPath().endsWith("j_security_check")) {
            LOG.trace("Request ends with {} so I'm not intercepting the request", (Object)"j_security_check");
            return;
        }
        Cookie loginCookie = this.getLoginCookie(context, this.loginTokenName);
        if (loginCookie != null) {
            LOG.trace("Request has cookie {} so I'm not intercepting the request", (Object)loginCookie.getName());
            return;
        }
        this.doLogin(request, context);
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response.getStatusLine().getStatusCode() != 401) {
            return;
        }
        if (URI.create(HttpClientContext.adapt((HttpContext)context).getRequest().getRequestLine().getUri()).getPath().endsWith("j_security_check")) {
            LOG.trace("Request ends with {} so I'm not intercepting the request", (Object)"j_security_check");
            return;
        }
        Cookie loginCookie = this.getLoginCookie(context, this.loginTokenName);
        if (loginCookie == null) {
            return;
        }
        LOG.info("Response code was 401 even though {} is set. Removing the cookie.", (Object)loginCookie.getName());
        BasicClientCookie expiredLoginTokenCookie = new BasicClientCookie(loginCookie.getName(), "expired");
        expiredLoginTokenCookie.setExpiryDate(new Date(1L));
        expiredLoginTokenCookie.setDomain(loginCookie.getDomain());
        expiredLoginTokenCookie.setPath(loginCookie.getPath());
        HttpClientContext.adapt((HttpContext)context).getCookieStore().addCookie((Cookie)expiredLoginTokenCookie);
    }

    private Cookie getLoginCookie(HttpContext context, String loginTokenName) {
        for (Cookie cookie : HttpClientContext.adapt((HttpContext)context).getCookieStore().getCookies()) {
            if (!cookie.getName().equalsIgnoreCase(loginTokenName) || cookie.getValue().isEmpty()) continue;
            return cookie;
        }
        return null;
    }

    private void doLogin(HttpRequest request, HttpContext context) throws IOException {
        block22: {
            HttpHost host = HttpClientContext.adapt((HttpContext)context).getTargetHost();
            CredentialsProvider credsProvider = HttpClientContext.adapt((HttpContext)context).getCredentialsProvider();
            AuthScope scope = new AuthScope(host.getHostName(), host.getPort());
            String username = credsProvider.getCredentials(scope).getUserPrincipal().getName();
            String password = credsProvider.getCredentials(scope).getPassword();
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("j_username", username));
            parameters.add(new BasicNameValuePair("j_password", password));
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(parameters, "utf-8");
            URI loginURI = URI.create(request.getRequestLine().getUri()).resolve("j_security_check");
            HttpPost loginPost = new HttpPost(loginURI);
            loginPost.setEntity((HttpEntity)httpEntity);
            try (CloseableHttpClient client = HttpClientBuilder.create().setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new ServerErrorRetryStrategy()).disableRedirectHandling().build();
                 CloseableHttpResponse response = client.execute(host, (HttpRequest)loginPost, context);){
                StatusLine sl = response.getStatusLine();
                if (sl.getStatusCode() >= 400) {
                    LOG.error("Got error login response code {} from '{}'", (Object)sl.getStatusCode(), (Object)loginURI.toString());
                    LOG.error("Dumping headers: ");
                    for (Header header : response.getAllHeaders()) {
                        LOG.error("\t '{}' = '{}'", (Object)header.getName(), (Object)header.getValue());
                    }
                    try (InputStream inputStream = response.getEntity().getContent();){
                        String responseText = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        LOG.error("Error response body was : '{}'", (Object)responseText);
                        break block22;
                    }
                }
                if (this.getLoginCookie(context, this.loginTokenName) == null) {
                    LOG.error("Login response {} from '{}' did not include cookie '{}'.", new Object[]{sl.getStatusCode(), loginURI.toString(), this.loginTokenName});
                } else {
                    LOG.debug("Login response {} from '{}'", (Object)sl.getStatusCode(), (Object)loginURI.toString());
                }
            }
        }
    }
}

