/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder.extensions;

import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sling.sitemap.builder.extensions.AlternateLanguageExtension;
import org.apache.sling.sitemap.spi.builder.AbstractExtension;
import org.apache.sling.sitemap.spi.builder.SitemapExtensionProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(property={"extension.interface=org.apache.sling.sitemap.builder.extensions.AlternateLanguageExtension", "extension.prefix=xhtml", "extension.namespace=http://www.w3.org/1999/xhtml", "extension.localName=link", "extension.emptyTag=true"})
public class AlternateLanguageExtensionProvider
implements SitemapExtensionProvider {
    @Override
    @NotNull
    public AbstractExtension newInstance() {
        return new ExtensionImpl();
    }

    public static class ExtensionImpl
    extends AbstractExtension
    implements AlternateLanguageExtension {
        private String hreflang;
        private String href;

        private static <T> T required(T object, String message) throws XMLStreamException {
            if (object == null) {
                throw new XMLStreamException(message);
            }
            return object;
        }

        @Override
        @NotNull
        public AlternateLanguageExtension setLocale(@NotNull Locale locale) {
            this.hreflang = locale.toLanguageTag();
            return this;
        }

        @Override
        @NotNull
        public AlternateLanguageExtension setDefaultLocale() {
            this.hreflang = "x-default";
            return this;
        }

        @Override
        @NotNull
        public AlternateLanguageExtension setHref(@NotNull String location) {
            this.href = location;
            return this;
        }

        @Override
        public void writeTo(@NotNull XMLStreamWriter writer) throws XMLStreamException {
            writer.writeAttribute("rel", "alternate");
            writer.writeAttribute("hreflang", ExtensionImpl.required(this.hreflang, "hreflang is missing"));
            writer.writeAttribute("href", ExtensionImpl.required(this.href, "href is missing"));
        }
    }
}

