/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.apache.sling.scripting.spi.bundle.TypeProvider;
import org.apache.sling.servlets.resolver.internal.bundle.RequestWrapper;
import org.jetbrains.annotations.NotNull;

public class BundledScriptServlet
extends GenericServlet {
    private static final long serialVersionUID = 6320375093932073555L;
    private final BundledRenderUnit executable;
    private final String servletInfo;
    private final Set<ResourceType> types;

    public BundledScriptServlet(@NotNull Set<TypeProvider> wiredTypeProviders, @NotNull BundledRenderUnit executable) {
        this.executable = executable;
        this.servletInfo = "Script " + executable.getPath();
        this.types = wiredTypeProviders.stream().map(typeProvider -> typeProvider.getBundledRenderUnitCapability().getResourceTypes()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String getServletInfo() {
        return this.servletInfo;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (req instanceof SlingHttpServletRequest && res instanceof SlingHttpServletResponse) {
            String contentType;
            SlingHttpServletRequest request = (SlingHttpServletRequest)req;
            SlingHttpServletResponse response = (SlingHttpServletResponse)res;
            if (request.getAttribute("javax.servlet.include.servlet_path") == null && (contentType = request.getResponseContentType()) != null) {
                response.setContentType(contentType);
                if (contentType.startsWith("text/")) {
                    response.setCharacterEncoding("UTF-8");
                }
            }
            RequestWrapper requestWrapper = new RequestWrapper(request, this.types);
            try {
                this.executable.eval((HttpServletRequest)requestWrapper, (HttpServletResponse)response);
            }
            catch (Exception se) {
                Throwable cause = se.getCause() == null ? se : se.getCause();
                throw cause instanceof ServletException ? (ServletException)cause : new ServletException(String.format("Failed executing script %s: %s", this.executable.getPath(), se.getMessage()), cause);
            }
        } else {
            throw new ServletException("Not a Sling HTTP request/response");
        }
    }

    @NotNull
    public BundledRenderUnit getBundledRenderUnit() {
        return this.executable;
    }

    public InputStream getInputStream() {
        return this.executable.getInputStream();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.executable.getPath() + ")";
    }
}

