/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.operations.AbstractPostOperation;

abstract class AbstractCopyMoveOperation
extends AbstractPostOperation {
    AbstractCopyMoveOperation() {
    }

    @Override
    protected final void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws PersistenceException {
        Resource destResource;
        Object dstParent;
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        Resource resource = request.getResource();
        String source = resource.getPath();
        Object dest = request.getParameter(":dest");
        if (dest == null || ((String)dest).length() == 0) {
            throw new IllegalArgumentException("Unable to process " + this.getOperationName() + ". Missing destination");
        }
        boolean trailingSlash = ((String)dest).endsWith("/");
        if (!((String)dest).startsWith("/")) {
            dest = ResourceUtil.getParent((String)source) + "/" + (String)dest;
        }
        dest = ResourceUtil.normalize((String)dest);
        Object object = dstParent = trailingSlash ? dest : ResourceUtil.getParent((String)dest);
        if (!trailingSlash && request.getResourceResolver().getResource((String)dest) != null) {
            String replaceString = request.getParameter(":replace");
            boolean isReplace = "true".equalsIgnoreCase(replaceString);
            if (!isReplace) {
                response.setStatus(412, "Cannot " + this.getOperationName() + " " + resource + " to " + (String)dest + ": destination exists");
                return;
            }
            this.jcrSupport.checkoutIfNecessary(request.getResourceResolver().getResource((String)dstParent), changes, versioningConfiguration);
        } else {
            if (!((String)dstParent).equals("")) {
                Resource parentResource = request.getResourceResolver().getResource((String)dstParent);
                if (parentResource != null) {
                    this.jcrSupport.checkoutIfNecessary(parentResource, changes, versioningConfiguration);
                } else {
                    response.setStatus(412, "Cannot " + this.getOperationName() + " " + resource + " to " + (String)dest + ": parent of destination does not exist");
                    return;
                }
            }
            response.setCreateRequest(true);
        }
        Iterator<Resource> resources = this.getApplyToResources(request);
        if (resources == null) {
            String dstName = trailingSlash ? null : ResourceUtil.getName((String)dest);
            destResource = this.execute(changes, resource, (String)dstParent, dstName, versioningConfiguration);
        } else {
            if (!trailingSlash) {
                throw new IllegalArgumentException("Applying " + this.getOperationName() + " to multiple resources requires a trailing slash on the destination");
            }
            response.setCreateRequest(false);
            while (resources.hasNext()) {
                Resource applyTo = resources.next();
                this.execute(changes, applyTo, (String)dstParent, null, versioningConfiguration);
            }
            destResource = request.getResourceResolver().getResource((String)dest);
        }
        if (destResource == null) {
            response.setStatus(404, "Missing source " + resource + " for " + this.getOperationName());
            return;
        }
        this.orderResource(request, destResource, changes);
    }

    protected abstract String getOperationName();

    protected abstract Resource execute(List<Modification> var1, Resource var2, String var3, String var4, VersioningConfiguration var5) throws PersistenceException;
}

