/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.get.impl.helpers.Renderer;
import org.owasp.encoder.Encode;

public class HtmlRenderer
implements Renderer {
    public static final HtmlRenderer INSTANCE = new HtmlRenderer();

    @Override
    public void render(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws IOException {
        Resource r = req.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)r)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();
        boolean isIncluded = req.getAttribute("org.apache.sling.api.include.servlet") != null;
        Map map = (Map)r.adaptTo(Map.class);
        if (map != null) {
            this.printProlog(pw, isIncluded);
            this.printResourceInfo(pw, r);
            this.render(pw, r, map);
            this.printEpilog(pw, isIncluded);
        } else if (r.adaptTo(String.class) != null) {
            this.printProlog(pw, isIncluded);
            this.printResourceInfo(pw, r);
            this.render(pw, r, (String)r.adaptTo(String.class));
            this.printEpilog(pw, isIncluded);
        } else if (r.adaptTo(String[].class) != null) {
            this.printProlog(pw, isIncluded);
            this.printResourceInfo(pw, r);
            this.render(pw, r, (String[])r.adaptTo(String[].class));
            this.printEpilog(pw, isIncluded);
        } else if (!isIncluded) {
            resp.setStatus(204);
        }
    }

    private void printProlog(PrintWriter pw, boolean isIncluded) {
        if (!isIncluded) {
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"");
            pw.println("    \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
            pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
            pw.println("<head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" /></head>");
            pw.println("<body>");
        }
    }

    private void printEpilog(PrintWriter pw, boolean isIncluded) {
        if (!isIncluded) {
            pw.println("</body></html>");
        }
    }

    private void printResourceInfo(PrintWriter pw, Resource r) {
        pw.print("<h1>Resource dumped by ");
        pw.print(Encode.forHtmlContent((String)this.getClass().getSimpleName()));
        pw.println("</h1>");
        pw.print("<p>Resource path: <b>");
        pw.print(Encode.forHtmlContent((String)r.getPath()));
        pw.println("</b></p>");
        pw.print("<p>Resource metadata: <b>");
        pw.print(Encode.forHtmlContent((String)String.valueOf(r.getResourceMetadata())));
        pw.println("</b></p>");
        pw.print("<p>Resource type: <b>");
        pw.print(Encode.forHtmlContent((String)r.getResourceType()));
        pw.println("</b></p>");
        String resourceSuperType = r.getResourceResolver().getParentResourceType(r);
        if (resourceSuperType == null) {
            resourceSuperType = "-";
        }
        pw.print("<p>Resource super type: <b>");
        pw.print(Encode.forHtmlContent((String)resourceSuperType));
        pw.println("</b></p>");
    }

    private void render(PrintWriter pw, Resource r, Map<?, ?> map) {
        pw.println("<h2>Resource properties</h2>");
        pw.println("<p>");
        for (Map.Entry<?, ?> p : map.entrySet()) {
            this.printPropertyValue(pw, p.getKey().toString(), p.getValue());
            pw.println();
        }
        pw.println("</p>");
    }

    private void render(PrintWriter pw, Resource r, String value) {
        this.printPropertyValue(pw, "Resource Value", value);
    }

    private void render(PrintWriter pw, Resource r, String[] values) {
        for (String value : values) {
            this.printPropertyValue(pw, "Resource Value", value);
        }
    }

    private void printPropertyValue(PrintWriter pw, String name, Object value) {
        pw.print(Encode.forHtmlContent((String)name));
        pw.print(": <b>");
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            pw.print('[');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(Encode.forHtmlContent((String)values[i].toString()));
            }
            pw.print(']');
        } else {
            pw.print(Encode.forHtmlContent((String)value.toString()));
        }
        pw.print("</b><br />");
    }
}

