/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.servlets.get.impl;

import static org.junit.Assert.assertEquals;

import org.apache.sling.commons.testing.sling.MockResource;
import org.apache.sling.commons.testing.sling.MockResourceResolver;
import org.apache.sling.commons.testing.sling.MockSlingHttpServletRequest;
import org.apache.sling.commons.testing.sling.MockSlingHttpServletResponse;
import org.apache.sling.servlets.get.impl.helpers.JsonRenderer;

public class JsonRendererServletTest {

    private static MockResourceResolver resolver;

    @org.junit.BeforeClass
    public static void setup() {
        resolver = new MockResourceResolver();
        resolver.addResource(new MockResource(resolver, "/content/page", "page"));
        resolver.addResource(new MockResource(resolver, "/content/page/one", "one"));
        resolver.addResource(new MockResource(resolver, "/content/page/two", "two"));

        resolver.addResource(new MockResource(resolver, "/etc", "etc"));
        resolver.addResource(new MockResource(resolver, "/etc/tags", "tags"));
        for (int i = 0; i < 1085; i++) {
            resolver.addResource(new MockResource(resolver, "/etc/tags/" + i, "" + i));
        }
    }

    @org.junit.AfterClass
    public static void teardown() {
    }

    @org.junit.Test
    public void test() throws Throwable {
        String response = getJSON("/content/page", "0");
        assertEquals("{\"resourceType\":\"page\"}", response);

        response = getJSON("/content/page", "1");
        assertEquals(
                "{\"resourceType\":\"page\",\"one\":{\"resourceType\":\"one\"},\"two\":{\"resourceType\":\"two\"}}",
                response);

        response = getJSON("/content/page", "infinity");
        assertEquals(
                "{\"resourceType\":\"page\",\"one\":{\"resourceType\":\"one\"},\"two\":{\"resourceType\":\"two\"}}",
                response);

        response = getJSON("/content/page/one", "infinity");
        assertEquals("{\"resourceType\":\"one\"}", response);

        response = getJSON("/etc", "infinity");
        assertEquals("[\"/etc.1.json\",\"/etc.0.json\"]", response);

        response = getJSON("/etc/tags", "1");
        assertEquals(
                "{\"resourceType\":\"tags\",\"0\":{\"resourceType\":\"0\"},\"1\":{\"resourceType\":\"1\"},\"2\":{\"resourceType\":\"2\"},\"3\":{\"resourceType\":\"3\"},\"4\":{\"resourceType\":\"4\"},\"5\":{\"resourceType\":\"5\"},\"6\":{\"resourceType\":\"6\"},\"7\":{\"resourceType\":\"7\"},\"8\":{\"resourceType\":\"8\"},\"9\":{\"resourceType\":\"9\"},\"10\":{\"resourceType\":\"10\"},\"11\":{\"resourceType\":\"11\"},\"12\":{\"resourceType\":\"12\"},\"13\":{\"resourceType\":\"13\"},\"14\":{\"resourceType\":\"14\"},\"15\":{\"resourceType\":\"15\"},\"16\":{\"resourceType\":\"16\"},\"17\":{\"resourceType\":\"17\"},\"18\":{\"resourceType\":\"18\"},\"19\":{\"resourceType\":\"19\"},\"20\":{\"resourceType\":\"20\"},\"21\":{\"resourceType\":\"21\"},\"22\":{\"resourceType\":\"22\"},\"23\":{\"resourceType\":\"23\"},\"24\":{\"resourceType\":\"24\"},\"25\":{\"resourceType\":\"25\"},\"26\":{\"resourceType\":\"26\"},\"27\":{\"resourceType\":\"27\"},\"28\":{\"resourceType\":\"28\"},\"29\":{\"resourceType\":\"29\"},\"30\":{\"resourceType\":\"30\"},\"31\":{\"resourceType\":\"31\"},\"32\":{\"resourceType\":\"32\"},\"33\":{\"resourceType\":\"33\"},\"34\":{\"resourceType\":\"34\"},\"35\":{\"resourceType\":\"35\"},\"36\":{\"resourceType\":\"36\"},\"37\":{\"resourceType\":\"37\"},\"38\":{\"resourceType\":\"38\"},\"39\":{\"resourceType\":\"39\"},\"40\":{\"resourceType\":\"40\"},\"41\":{\"resourceType\":\"41\"},\"42\":{\"resourceType\":\"42\"},\"43\":{\"resourceType\":\"43\"},\"44\":{\"resourceType\":\"44\"},\"45\":{\"resourceType\":\"45\"},\"46\":{\"resourceType\":\"46\"},\"47\":{\"resourceType\":\"47\"},\"48\":{\"resourceType\":\"48\"},\"49\":{\"resourceType\":\"49\"},\"50\":{\"resourceType\":\"50\"},\"51\":{\"resourceType\":\"51\"},\"52\":{\"resourceType\":\"52\"},\"53\":{\"resourceType\":\"53\"},\"54\":{\"resourceType\":\"54\"},\"55\":{\"resourceType\":\"55\"},\"56\":{\"resourceType\":\"56\"},\"57\":{\"resourceType\":\"57\"},\"58\":{\"resourceType\":\"58\"},\"59\":{\"resourceType\":\"59\"},\"60\":{\"resourceType\":\"60\"},\"61\":{\"resourceType\":\"61\"},\"62\":{\"resourceType\":\"62\"},\"63\":{\"resourceType\":\"63\"},\"64\":{\"resourceType\":\"64\"},\"65\":{\"resourceType\":\"65\"},\"66\":{\"resourceType\":\"66\"},\"67\":{\"resourceType\":\"67\"},\"68\":{\"resourceType\":\"68\"},\"69\":{\"resourceType\":\"69\"},\"70\":{\"resourceType\":\"70\"},\"71\":{\"resourceType\":\"71\"},\"72\":{\"resourceType\":\"72\"},\"73\":{\"resourceType\":\"73\"},\"74\":{\"resourceType\":\"74\"},\"75\":{\"resourceType\":\"75\"},\"76\":{\"resourceType\":\"76\"},\"77\":{\"resourceType\":\"77\"},\"78\":{\"resourceType\":\"78\"},\"79\":{\"resourceType\":\"79\"},\"80\":{\"resourceType\":\"80\"},\"81\":{\"resourceType\":\"81\"},\"82\":{\"resourceType\":\"82\"},\"83\":{\"resourceType\":\"83\"},\"84\":{\"resourceType\":\"84\"},\"85\":{\"resourceType\":\"85\"},\"86\":{\"resourceType\":\"86\"},\"87\":{\"resourceType\":\"87\"},\"88\":{\"resourceType\":\"88\"},\"89\":{\"resourceType\":\"89\"},\"90\":{\"resourceType\":\"90\"},\"91\":{\"resourceType\":\"91\"},\"92\":{\"resourceType\":\"92\"},\"93\":{\"resourceType\":\"93\"},\"94\":{\"resourceType\":\"94\"},\"95\":{\"resourceType\":\"95\"},\"96\":{\"resourceType\":\"96\"},\"97\":{\"resourceType\":\"97\"},\"98\":{\"resourceType\":\"98\"},\"99\":{\"resourceType\":\"99\"},\"100\":{\"resourceType\":\"100\"},\"101\":{\"resourceType\":\"101\"},\"102\":{\"resourceType\":\"102\"},\"103\":{\"resourceType\":\"103\"},\"104\":{\"resourceType\":\"104\"},\"105\":{\"resourceType\":\"105\"},\"106\":{\"resourceType\":\"106\"},\"107\":{\"resourceType\":\"107\"},\"108\":{\"resourceType\":\"108\"},\"109\":{\"resourceType\":\"109\"},\"110\":{\"resourceType\":\"110\"},\"111\":{\"resourceType\":\"111\"},\"112\":{\"resourceType\":\"112\"},\"113\":{\"resourceType\":\"113\"},\"114\":{\"resourceType\":\"114\"},\"115\":{\"resourceType\":\"115\"},\"116\":{\"resourceType\":\"116\"},\"117\":{\"resourceType\":\"117\"},\"118\":{\"resourceType\":\"118\"},\"119\":{\"resourceType\":\"119\"},\"120\":{\"resourceType\":\"120\"},\"121\":{\"resourceType\":\"121\"},\"122\":{\"resourceType\":\"122\"},\"123\":{\"resourceType\":\"123\"},\"124\":{\"resourceType\":\"124\"},\"125\":{\"resourceType\":\"125\"},\"126\":{\"resourceType\":\"126\"},\"127\":{\"resourceType\":\"127\"},\"128\":{\"resourceType\":\"128\"},\"129\":{\"resourceType\":\"129\"},\"130\":{\"resourceType\":\"130\"},\"131\":{\"resourceType\":\"131\"},\"132\":{\"resourceType\":\"132\"},\"133\":{\"resourceType\":\"133\"},\"134\":{\"resourceType\":\"134\"},\"135\":{\"resourceType\":\"135\"},\"136\":{\"resourceType\":\"136\"},\"137\":{\"resourceType\":\"137\"},\"138\":{\"resourceType\":\"138\"},\"139\":{\"resourceType\":\"139\"},\"140\":{\"resourceType\":\"140\"},\"141\":{\"resourceType\":\"141\"},\"142\":{\"resourceType\":\"142\"},\"143\":{\"resourceType\":\"143\"},\"144\":{\"resourceType\":\"144\"},\"145\":{\"resourceType\":\"145\"},\"146\":{\"resourceType\":\"146\"},\"147\":{\"resourceType\":\"147\"},\"148\":{\"resourceType\":\"148\"},\"149\":{\"resourceType\":\"149\"},\"150\":{\"resourceType\":\"150\"},\"151\":{\"resourceType\":\"151\"},\"152\":{\"resourceType\":\"152\"},\"153\":{\"resourceType\":\"153\"},\"154\":{\"resourceType\":\"154\"},\"155\":{\"resourceType\":\"155\"},\"156\":{\"resourceType\":\"156\"},\"157\":{\"resourceType\":\"157\"},\"158\":{\"resourceType\":\"158\"},\"159\":{\"resourceType\":\"159\"},\"160\":{\"resourceType\":\"160\"},\"161\":{\"resourceType\":\"161\"},\"162\":{\"resourceType\":\"162\"},\"163\":{\"resourceType\":\"163\"},\"164\":{\"resourceType\":\"164\"},\"165\":{\"resourceType\":\"165\"},\"166\":{\"resourceType\":\"166\"},\"167\":{\"resourceType\":\"167\"},\"168\":{\"resourceType\":\"168\"},\"169\":{\"resourceType\":\"169\"},\"170\":{\"resourceType\":\"170\"},\"171\":{\"resourceType\":\"171\"},\"172\":{\"resourceType\":\"172\"},\"173\":{\"resourceType\":\"173\"},\"174\":{\"resourceType\":\"174\"},\"175\":{\"resourceType\":\"175\"},\"176\":{\"resourceType\":\"176\"},\"177\":{\"resourceType\":\"177\"},\"178\":{\"resourceType\":\"178\"},\"179\":{\"resourceType\":\"179\"},\"180\":{\"resourceType\":\"180\"},\"181\":{\"resourceType\":\"181\"},\"182\":{\"resourceType\":\"182\"},\"183\":{\"resourceType\":\"183\"},\"184\":{\"resourceType\":\"184\"},\"185\":{\"resourceType\":\"185\"},\"186\":{\"resourceType\":\"186\"},\"187\":{\"resourceType\":\"187\"},\"188\":{\"resourceType\":\"188\"},\"189\":{\"resourceType\":\"189\"},\"190\":{\"resourceType\":\"190\"},\"191\":{\"resourceType\":\"191\"},\"192\":{\"resourceType\":\"192\"},\"193\":{\"resourceType\":\"193\"},\"194\":{\"resourceType\":\"194\"},\"195\":{\"resourceType\":\"195\"},\"196\":{\"resourceType\":\"196\"},\"197\":{\"resourceType\":\"197\"},\"198\":{\"resourceType\":\"198\"},\"199\":{\"resourceType\":\"199\"},\"200\":{\"resourceType\":\"200\"},\"201\":{\"resourceType\":\"201\"},\"202\":{\"resourceType\":\"202\"},\"203\":{\"resourceType\":\"203\"},\"204\":{\"resourceType\":\"204\"},\"205\":{\"resourceType\":\"205\"},\"206\":{\"resourceType\":\"206\"},\"207\":{\"resourceType\":\"207\"},\"208\":{\"resourceType\":\"208\"},\"209\":{\"resourceType\":\"209\"},\"210\":{\"resourceType\":\"210\"},\"211\":{\"resourceType\":\"211\"},\"212\":{\"resourceType\":\"212\"},\"213\":{\"resourceType\":\"213\"},\"214\":{\"resourceType\":\"214\"},\"215\":{\"resourceType\":\"215\"},\"216\":{\"resourceType\":\"216\"},\"217\":{\"resourceType\":\"217\"},\"218\":{\"resourceType\":\"218\"},\"219\":{\"resourceType\":\"219\"},\"220\":{\"resourceType\":\"220\"},\"221\":{\"resourceType\":\"221\"},\"222\":{\"resourceType\":\"222\"},\"223\":{\"resourceType\":\"223\"},\"224\":{\"resourceType\":\"224\"},\"225\":{\"resourceType\":\"225\"},\"226\":{\"resourceType\":\"226\"},\"227\":{\"resourceType\":\"227\"},\"228\":{\"resourceType\":\"228\"},\"229\":{\"resourceType\":\"229\"},\"230\":{\"resourceType\":\"230\"},\"231\":{\"resourceType\":\"231\"},\"232\":{\"resourceType\":\"232\"},\"233\":{\"resourceType\":\"233\"},\"234\":{\"resourceType\":\"234\"},\"235\":{\"resourceType\":\"235\"},\"236\":{\"resourceType\":\"236\"},\"237\":{\"resourceType\":\"237\"},\"238\":{\"resourceType\":\"238\"},\"239\":{\"resourceType\":\"239\"},\"240\":{\"resourceType\":\"240\"},\"241\":{\"resourceType\":\"241\"},\"242\":{\"resourceType\":\"242\"},\"243\":{\"resourceType\":\"243\"},\"244\":{\"resourceType\":\"244\"},\"245\":{\"resourceType\":\"245\"},\"246\":{\"resourceType\":\"246\"},\"247\":{\"resourceType\":\"247\"},\"248\":{\"resourceType\":\"248\"},\"249\":{\"resourceType\":\"249\"},\"250\":{\"resourceType\":\"250\"},\"251\":{\"resourceType\":\"251\"},\"252\":{\"resourceType\":\"252\"},\"253\":{\"resourceType\":\"253\"},\"254\":{\"resourceType\":\"254\"},\"255\":{\"resourceType\":\"255\"},\"256\":{\"resourceType\":\"256\"},\"257\":{\"resourceType\":\"257\"},\"258\":{\"resourceType\":\"258\"},\"259\":{\"resourceType\":\"259\"},\"260\":{\"resourceType\":\"260\"},\"261\":{\"resourceType\":\"261\"},\"262\":{\"resourceType\":\"262\"},\"263\":{\"resourceType\":\"263\"},\"264\":{\"resourceType\":\"264\"},\"265\":{\"resourceType\":\"265\"},\"266\":{\"resourceType\":\"266\"},\"267\":{\"resourceType\":\"267\"},\"268\":{\"resourceType\":\"268\"},\"269\":{\"resourceType\":\"269\"},\"270\":{\"resourceType\":\"270\"},\"271\":{\"resourceType\":\"271\"},\"272\":{\"resourceType\":\"272\"},\"273\":{\"resourceType\":\"273\"},\"274\":{\"resourceType\":\"274\"},\"275\":{\"resourceType\":\"275\"},\"276\":{\"resourceType\":\"276\"},\"277\":{\"resourceType\":\"277\"},\"278\":{\"resourceType\":\"278\"},\"279\":{\"resourceType\":\"279\"},\"280\":{\"resourceType\":\"280\"},\"281\":{\"resourceType\":\"281\"},\"282\":{\"resourceType\":\"282\"},\"283\":{\"resourceType\":\"283\"},\"284\":{\"resourceType\":\"284\"},\"285\":{\"resourceType\":\"285\"},\"286\":{\"resourceType\":\"286\"},\"287\":{\"resourceType\":\"287\"},\"288\":{\"resourceType\":\"288\"},\"289\":{\"resourceType\":\"289\"},\"290\":{\"resourceType\":\"290\"},\"291\":{\"resourceType\":\"291\"},\"292\":{\"resourceType\":\"292\"},\"293\":{\"resourceType\":\"293\"},\"294\":{\"resourceType\":\"294\"},\"295\":{\"resourceType\":\"295\"},\"296\":{\"resourceType\":\"296\"},\"297\":{\"resourceType\":\"297\"},\"298\":{\"resourceType\":\"298\"},\"299\":{\"resourceType\":\"299\"},\"300\":{\"resourceType\":\"300\"},\"301\":{\"resourceType\":\"301\"},\"302\":{\"resourceType\":\"302\"},\"303\":{\"resourceType\":\"303\"},\"304\":{\"resourceType\":\"304\"},\"305\":{\"resourceType\":\"305\"},\"306\":{\"resourceType\":\"306\"},\"307\":{\"resourceType\":\"307\"},\"308\":{\"resourceType\":\"308\"},\"309\":{\"resourceType\":\"309\"},\"310\":{\"resourceType\":\"310\"},\"311\":{\"resourceType\":\"311\"},\"312\":{\"resourceType\":\"312\"},\"313\":{\"resourceType\":\"313\"},\"314\":{\"resourceType\":\"314\"},\"315\":{\"resourceType\":\"315\"},\"316\":{\"resourceType\":\"316\"},\"317\":{\"resourceType\":\"317\"},\"318\":{\"resourceType\":\"318\"},\"319\":{\"resourceType\":\"319\"},\"320\":{\"resourceType\":\"320\"},\"321\":{\"resourceType\":\"321\"},\"322\":{\"resourceType\":\"322\"},\"323\":{\"resourceType\":\"323\"},\"324\":{\"resourceType\":\"324\"},\"325\":{\"resourceType\":\"325\"},\"326\":{\"resourceType\":\"326\"},\"327\":{\"resourceType\":\"327\"},\"328\":{\"resourceType\":\"328\"},\"329\":{\"resourceType\":\"329\"},\"330\":{\"resourceType\":\"330\"},\"331\":{\"resourceType\":\"331\"},\"332\":{\"resourceType\":\"332\"},\"333\":{\"resourceType\":\"333\"},\"334\":{\"resourceType\":\"334\"},\"335\":{\"resourceType\":\"335\"},\"336\":{\"resourceType\":\"336\"},\"337\":{\"resourceType\":\"337\"},\"338\":{\"resourceType\":\"338\"},\"339\":{\"resourceType\":\"339\"},\"340\":{\"resourceType\":\"340\"},\"341\":{\"resourceType\":\"341\"},\"342\":{\"resourceType\":\"342\"},\"343\":{\"resourceType\":\"343\"},\"344\":{\"resourceType\":\"344\"},\"345\":{\"resourceType\":\"345\"},\"346\":{\"resourceType\":\"346\"},\"347\":{\"resourceType\":\"347\"},\"348\":{\"resourceType\":\"348\"},\"349\":{\"resourceType\":\"349\"},\"350\":{\"resourceType\":\"350\"},\"351\":{\"resourceType\":\"351\"},\"352\":{\"resourceType\":\"352\"},\"353\":{\"resourceType\":\"353\"},\"354\":{\"resourceType\":\"354\"},\"355\":{\"resourceType\":\"355\"},\"356\":{\"resourceType\":\"356\"},\"357\":{\"resourceType\":\"357\"},\"358\":{\"resourceType\":\"358\"},\"359\":{\"resourceType\":\"359\"},\"360\":{\"resourceType\":\"360\"},\"361\":{\"resourceType\":\"361\"},\"362\":{\"resourceType\":\"362\"},\"363\":{\"resourceType\":\"363\"},\"364\":{\"resourceType\":\"364\"},\"365\":{\"resourceType\":\"365\"},\"366\":{\"resourceType\":\"366\"},\"367\":{\"resourceType\":\"367\"},\"368\":{\"resourceType\":\"368\"},\"369\":{\"resourceType\":\"369\"},\"370\":{\"resourceType\":\"370\"},\"371\":{\"resourceType\":\"371\"},\"372\":{\"resourceType\":\"372\"},\"373\":{\"resourceType\":\"373\"},\"374\":{\"resourceType\":\"374\"},\"375\":{\"resourceType\":\"375\"},\"376\":{\"resourceType\":\"376\"},\"377\":{\"resourceType\":\"377\"},\"378\":{\"resourceType\":\"378\"},\"379\":{\"resourceType\":\"379\"},\"380\":{\"resourceType\":\"380\"},\"381\":{\"resourceType\":\"381\"},\"382\":{\"resourceType\":\"382\"},\"383\":{\"resourceType\":\"383\"},\"384\":{\"resourceType\":\"384\"},\"385\":{\"resourceType\":\"385\"},\"386\":{\"resourceType\":\"386\"},\"387\":{\"resourceType\":\"387\"},\"388\":{\"resourceType\":\"388\"},\"389\":{\"resourceType\":\"389\"},\"390\":{\"resourceType\":\"390\"},\"391\":{\"resourceType\":\"391\"},\"392\":{\"resourceType\":\"392\"},\"393\":{\"resourceType\":\"393\"},\"394\":{\"resourceType\":\"394\"},\"395\":{\"resourceType\":\"395\"},\"396\":{\"resourceType\":\"396\"},\"397\":{\"resourceType\":\"397\"},\"398\":{\"resourceType\":\"398\"},\"399\":{\"resourceType\":\"399\"},\"400\":{\"resourceType\":\"400\"},\"401\":{\"resourceType\":\"401\"},\"402\":{\"resourceType\":\"402\"},\"403\":{\"resourceType\":\"403\"},\"404\":{\"resourceType\":\"404\"},\"405\":{\"resourceType\":\"405\"},\"406\":{\"resourceType\":\"406\"},\"407\":{\"resourceType\":\"407\"},\"408\":{\"resourceType\":\"408\"},\"409\":{\"resourceType\":\"409\"},\"410\":{\"resourceType\":\"410\"},\"411\":{\"resourceType\":\"411\"},\"412\":{\"resourceType\":\"412\"},\"413\":{\"resourceType\":\"413\"},\"414\":{\"resourceType\":\"414\"},\"415\":{\"resourceType\":\"415\"},\"416\":{\"resourceType\":\"416\"},\"417\":{\"resourceType\":\"417\"},\"418\":{\"resourceType\":\"418\"},\"419\":{\"resourceType\":\"419\"},\"420\":{\"resourceType\":\"420\"},\"421\":{\"resourceType\":\"421\"},\"422\":{\"resourceType\":\"422\"},\"423\":{\"resourceType\":\"423\"},\"424\":{\"resourceType\":\"424\"},\"425\":{\"resourceType\":\"425\"},\"426\":{\"resourceType\":\"426\"},\"427\":{\"resourceType\":\"427\"},\"428\":{\"resourceType\":\"428\"},\"429\":{\"resourceType\":\"429\"},\"430\":{\"resourceType\":\"430\"},\"431\":{\"resourceType\":\"431\"},\"432\":{\"resourceType\":\"432\"},\"433\":{\"resourceType\":\"433\"},\"434\":{\"resourceType\":\"434\"},\"435\":{\"resourceType\":\"435\"},\"436\":{\"resourceType\":\"436\"},\"437\":{\"resourceType\":\"437\"},\"438\":{\"resourceType\":\"438\"},\"439\":{\"resourceType\":\"439\"},\"440\":{\"resourceType\":\"440\"},\"441\":{\"resourceType\":\"441\"},\"442\":{\"resourceType\":\"442\"},\"443\":{\"resourceType\":\"443\"},\"444\":{\"resourceType\":\"444\"},\"445\":{\"resourceType\":\"445\"},\"446\":{\"resourceType\":\"446\"},\"447\":{\"resourceType\":\"447\"},\"448\":{\"resourceType\":\"448\"},\"449\":{\"resourceType\":\"449\"},\"450\":{\"resourceType\":\"450\"},\"451\":{\"resourceType\":\"451\"},\"452\":{\"resourceType\":\"452\"},\"453\":{\"resourceType\":\"453\"},\"454\":{\"resourceType\":\"454\"},\"455\":{\"resourceType\":\"455\"},\"456\":{\"resourceType\":\"456\"},\"457\":{\"resourceType\":\"457\"},\"458\":{\"resourceType\":\"458\"},\"459\":{\"resourceType\":\"459\"},\"460\":{\"resourceType\":\"460\"},\"461\":{\"resourceType\":\"461\"},\"462\":{\"resourceType\":\"462\"},\"463\":{\"resourceType\":\"463\"},\"464\":{\"resourceType\":\"464\"},\"465\":{\"resourceType\":\"465\"},\"466\":{\"resourceType\":\"466\"},\"467\":{\"resourceType\":\"467\"},\"468\":{\"resourceType\":\"468\"},\"469\":{\"resourceType\":\"469\"},\"470\":{\"resourceType\":\"470\"},\"471\":{\"resourceType\":\"471\"},\"472\":{\"resourceType\":\"472\"},\"473\":{\"resourceType\":\"473\"},\"474\":{\"resourceType\":\"474\"},\"475\":{\"resourceType\":\"475\"},\"476\":{\"resourceType\":\"476\"},\"477\":{\"resourceType\":\"477\"},\"478\":{\"resourceType\":\"478\"},\"479\":{\"resourceType\":\"479\"},\"480\":{\"resourceType\":\"480\"},\"481\":{\"resourceType\":\"481\"},\"482\":{\"resourceType\":\"482\"},\"483\":{\"resourceType\":\"483\"},\"484\":{\"resourceType\":\"484\"},\"485\":{\"resourceType\":\"485\"},\"486\":{\"resourceType\":\"486\"},\"487\":{\"resourceType\":\"487\"},\"488\":{\"resourceType\":\"488\"},\"489\":{\"resourceType\":\"489\"},\"490\":{\"resourceType\":\"490\"},\"491\":{\"resourceType\":\"491\"},\"492\":{\"resourceType\":\"492\"},\"493\":{\"resourceType\":\"493\"},\"494\":{\"resourceType\":\"494\"},\"495\":{\"resourceType\":\"495\"},\"496\":{\"resourceType\":\"496\"},\"497\":{\"resourceType\":\"497\"},\"498\":{\"resourceType\":\"498\"},\"499\":{\"resourceType\":\"499\"},\"500\":{\"resourceType\":\"500\"},\"501\":{\"resourceType\":\"501\"},\"502\":{\"resourceType\":\"502\"},\"503\":{\"resourceType\":\"503\"},\"504\":{\"resourceType\":\"504\"},\"505\":{\"resourceType\":\"505\"},\"506\":{\"resourceType\":\"506\"},\"507\":{\"resourceType\":\"507\"},\"508\":{\"resourceType\":\"508\"},\"509\":{\"resourceType\":\"509\"},\"510\":{\"resourceType\":\"510\"},\"511\":{\"resourceType\":\"511\"},\"512\":{\"resourceType\":\"512\"},\"513\":{\"resourceType\":\"513\"},\"514\":{\"resourceType\":\"514\"},\"515\":{\"resourceType\":\"515\"},\"516\":{\"resourceType\":\"516\"},\"517\":{\"resourceType\":\"517\"},\"518\":{\"resourceType\":\"518\"},\"519\":{\"resourceType\":\"519\"},\"520\":{\"resourceType\":\"520\"},\"521\":{\"resourceType\":\"521\"},\"522\":{\"resourceType\":\"522\"},\"523\":{\"resourceType\":\"523\"},\"524\":{\"resourceType\":\"524\"},\"525\":{\"resourceType\":\"525\"},\"526\":{\"resourceType\":\"526\"},\"527\":{\"resourceType\":\"527\"},\"528\":{\"resourceType\":\"528\"},\"529\":{\"resourceType\":\"529\"},\"530\":{\"resourceType\":\"530\"},\"531\":{\"resourceType\":\"531\"},\"532\":{\"resourceType\":\"532\"},\"533\":{\"resourceType\":\"533\"},\"534\":{\"resourceType\":\"534\"},\"535\":{\"resourceType\":\"535\"},\"536\":{\"resourceType\":\"536\"},\"537\":{\"resourceType\":\"537\"},\"538\":{\"resourceType\":\"538\"},\"539\":{\"resourceType\":\"539\"},\"540\":{\"resourceType\":\"540\"},\"541\":{\"resourceType\":\"541\"},\"542\":{\"resourceType\":\"542\"},\"543\":{\"resourceType\":\"543\"},\"544\":{\"resourceType\":\"544\"},\"545\":{\"resourceType\":\"545\"},\"546\":{\"resourceType\":\"546\"},\"547\":{\"resourceType\":\"547\"},\"548\":{\"resourceType\":\"548\"},\"549\":{\"resourceType\":\"549\"},\"550\":{\"resourceType\":\"550\"},\"551\":{\"resourceType\":\"551\"},\"552\":{\"resourceType\":\"552\"},\"553\":{\"resourceType\":\"553\"},\"554\":{\"resourceType\":\"554\"},\"555\":{\"resourceType\":\"555\"},\"556\":{\"resourceType\":\"556\"},\"557\":{\"resourceType\":\"557\"},\"558\":{\"resourceType\":\"558\"},\"559\":{\"resourceType\":\"559\"},\"560\":{\"resourceType\":\"560\"},\"561\":{\"resourceType\":\"561\"},\"562\":{\"resourceType\":\"562\"},\"563\":{\"resourceType\":\"563\"},\"564\":{\"resourceType\":\"564\"},\"565\":{\"resourceType\":\"565\"},\"566\":{\"resourceType\":\"566\"},\"567\":{\"resourceType\":\"567\"},\"568\":{\"resourceType\":\"568\"},\"569\":{\"resourceType\":\"569\"},\"570\":{\"resourceType\":\"570\"},\"571\":{\"resourceType\":\"571\"},\"572\":{\"resourceType\":\"572\"},\"573\":{\"resourceType\":\"573\"},\"574\":{\"resourceType\":\"574\"},\"575\":{\"resourceType\":\"575\"},\"576\":{\"resourceType\":\"576\"},\"577\":{\"resourceType\":\"577\"},\"578\":{\"resourceType\":\"578\"},\"579\":{\"resourceType\":\"579\"},\"580\":{\"resourceType\":\"580\"},\"581\":{\"resourceType\":\"581\"},\"582\":{\"resourceType\":\"582\"},\"583\":{\"resourceType\":\"583\"},\"584\":{\"resourceType\":\"584\"},\"585\":{\"resourceType\":\"585\"},\"586\":{\"resourceType\":\"586\"},\"587\":{\"resourceType\":\"587\"},\"588\":{\"resourceType\":\"588\"},\"589\":{\"resourceType\":\"589\"},\"590\":{\"resourceType\":\"590\"},\"591\":{\"resourceType\":\"591\"},\"592\":{\"resourceType\":\"592\"},\"593\":{\"resourceType\":\"593\"},\"594\":{\"resourceType\":\"594\"},\"595\":{\"resourceType\":\"595\"},\"596\":{\"resourceType\":\"596\"},\"597\":{\"resourceType\":\"597\"},\"598\":{\"resourceType\":\"598\"},\"599\":{\"resourceType\":\"599\"},\"600\":{\"resourceType\":\"600\"},\"601\":{\"resourceType\":\"601\"},\"602\":{\"resourceType\":\"602\"},\"603\":{\"resourceType\":\"603\"},\"604\":{\"resourceType\":\"604\"},\"605\":{\"resourceType\":\"605\"},\"606\":{\"resourceType\":\"606\"},\"607\":{\"resourceType\":\"607\"},\"608\":{\"resourceType\":\"608\"},\"609\":{\"resourceType\":\"609\"},\"610\":{\"resourceType\":\"610\"},\"611\":{\"resourceType\":\"611\"},\"612\":{\"resourceType\":\"612\"},\"613\":{\"resourceType\":\"613\"},\"614\":{\"resourceType\":\"614\"},\"615\":{\"resourceType\":\"615\"},\"616\":{\"resourceType\":\"616\"},\"617\":{\"resourceType\":\"617\"},\"618\":{\"resourceType\":\"618\"},\"619\":{\"resourceType\":\"619\"},\"620\":{\"resourceType\":\"620\"},\"621\":{\"resourceType\":\"621\"},\"622\":{\"resourceType\":\"622\"},\"623\":{\"resourceType\":\"623\"},\"624\":{\"resourceType\":\"624\"},\"625\":{\"resourceType\":\"625\"},\"626\":{\"resourceType\":\"626\"},\"627\":{\"resourceType\":\"627\"},\"628\":{\"resourceType\":\"628\"},\"629\":{\"resourceType\":\"629\"},\"630\":{\"resourceType\":\"630\"},\"631\":{\"resourceType\":\"631\"},\"632\":{\"resourceType\":\"632\"},\"633\":{\"resourceType\":\"633\"},\"634\":{\"resourceType\":\"634\"},\"635\":{\"resourceType\":\"635\"},\"636\":{\"resourceType\":\"636\"},\"637\":{\"resourceType\":\"637\"},\"638\":{\"resourceType\":\"638\"},\"639\":{\"resourceType\":\"639\"},\"640\":{\"resourceType\":\"640\"},\"641\":{\"resourceType\":\"641\"},\"642\":{\"resourceType\":\"642\"},\"643\":{\"resourceType\":\"643\"},\"644\":{\"resourceType\":\"644\"},\"645\":{\"resourceType\":\"645\"},\"646\":{\"resourceType\":\"646\"},\"647\":{\"resourceType\":\"647\"},\"648\":{\"resourceType\":\"648\"},\"649\":{\"resourceType\":\"649\"},\"650\":{\"resourceType\":\"650\"},\"651\":{\"resourceType\":\"651\"},\"652\":{\"resourceType\":\"652\"},\"653\":{\"resourceType\":\"653\"},\"654\":{\"resourceType\":\"654\"},\"655\":{\"resourceType\":\"655\"},\"656\":{\"resourceType\":\"656\"},\"657\":{\"resourceType\":\"657\"},\"658\":{\"resourceType\":\"658\"},\"659\":{\"resourceType\":\"659\"},\"660\":{\"resourceType\":\"660\"},\"661\":{\"resourceType\":\"661\"},\"662\":{\"resourceType\":\"662\"},\"663\":{\"resourceType\":\"663\"},\"664\":{\"resourceType\":\"664\"},\"665\":{\"resourceType\":\"665\"},\"666\":{\"resourceType\":\"666\"},\"667\":{\"resourceType\":\"667\"},\"668\":{\"resourceType\":\"668\"},\"669\":{\"resourceType\":\"669\"},\"670\":{\"resourceType\":\"670\"},\"671\":{\"resourceType\":\"671\"},\"672\":{\"resourceType\":\"672\"},\"673\":{\"resourceType\":\"673\"},\"674\":{\"resourceType\":\"674\"},\"675\":{\"resourceType\":\"675\"},\"676\":{\"resourceType\":\"676\"},\"677\":{\"resourceType\":\"677\"},\"678\":{\"resourceType\":\"678\"},\"679\":{\"resourceType\":\"679\"},\"680\":{\"resourceType\":\"680\"},\"681\":{\"resourceType\":\"681\"},\"682\":{\"resourceType\":\"682\"},\"683\":{\"resourceType\":\"683\"},\"684\":{\"resourceType\":\"684\"},\"685\":{\"resourceType\":\"685\"},\"686\":{\"resourceType\":\"686\"},\"687\":{\"resourceType\":\"687\"},\"688\":{\"resourceType\":\"688\"},\"689\":{\"resourceType\":\"689\"},\"690\":{\"resourceType\":\"690\"},\"691\":{\"resourceType\":\"691\"},\"692\":{\"resourceType\":\"692\"},\"693\":{\"resourceType\":\"693\"},\"694\":{\"resourceType\":\"694\"},\"695\":{\"resourceType\":\"695\"},\"696\":{\"resourceType\":\"696\"},\"697\":{\"resourceType\":\"697\"},\"698\":{\"resourceType\":\"698\"},\"699\":{\"resourceType\":\"699\"},\"700\":{\"resourceType\":\"700\"},\"701\":{\"resourceType\":\"701\"},\"702\":{\"resourceType\":\"702\"},\"703\":{\"resourceType\":\"703\"},\"704\":{\"resourceType\":\"704\"},\"705\":{\"resourceType\":\"705\"},\"706\":{\"resourceType\":\"706\"},\"707\":{\"resourceType\":\"707\"},\"708\":{\"resourceType\":\"708\"},\"709\":{\"resourceType\":\"709\"},\"710\":{\"resourceType\":\"710\"},\"711\":{\"resourceType\":\"711\"},\"712\":{\"resourceType\":\"712\"},\"713\":{\"resourceType\":\"713\"},\"714\":{\"resourceType\":\"714\"},\"715\":{\"resourceType\":\"715\"},\"716\":{\"resourceType\":\"716\"},\"717\":{\"resourceType\":\"717\"},\"718\":{\"resourceType\":\"718\"},\"719\":{\"resourceType\":\"719\"},\"720\":{\"resourceType\":\"720\"},\"721\":{\"resourceType\":\"721\"},\"722\":{\"resourceType\":\"722\"},\"723\":{\"resourceType\":\"723\"},\"724\":{\"resourceType\":\"724\"},\"725\":{\"resourceType\":\"725\"},\"726\":{\"resourceType\":\"726\"},\"727\":{\"resourceType\":\"727\"},\"728\":{\"resourceType\":\"728\"},\"729\":{\"resourceType\":\"729\"},\"730\":{\"resourceType\":\"730\"},\"731\":{\"resourceType\":\"731\"},\"732\":{\"resourceType\":\"732\"},\"733\":{\"resourceType\":\"733\"},\"734\":{\"resourceType\":\"734\"},\"735\":{\"resourceType\":\"735\"},\"736\":{\"resourceType\":\"736\"},\"737\":{\"resourceType\":\"737\"},\"738\":{\"resourceType\":\"738\"},\"739\":{\"resourceType\":\"739\"},\"740\":{\"resourceType\":\"740\"},\"741\":{\"resourceType\":\"741\"},\"742\":{\"resourceType\":\"742\"},\"743\":{\"resourceType\":\"743\"},\"744\":{\"resourceType\":\"744\"},\"745\":{\"resourceType\":\"745\"},\"746\":{\"resourceType\":\"746\"},\"747\":{\"resourceType\":\"747\"},\"748\":{\"resourceType\":\"748\"},\"749\":{\"resourceType\":\"749\"},\"750\":{\"resourceType\":\"750\"},\"751\":{\"resourceType\":\"751\"},\"752\":{\"resourceType\":\"752\"},\"753\":{\"resourceType\":\"753\"},\"754\":{\"resourceType\":\"754\"},\"755\":{\"resourceType\":\"755\"},\"756\":{\"resourceType\":\"756\"},\"757\":{\"resourceType\":\"757\"},\"758\":{\"resourceType\":\"758\"},\"759\":{\"resourceType\":\"759\"},\"760\":{\"resourceType\":\"760\"},\"761\":{\"resourceType\":\"761\"},\"762\":{\"resourceType\":\"762\"},\"763\":{\"resourceType\":\"763\"},\"764\":{\"resourceType\":\"764\"},\"765\":{\"resourceType\":\"765\"},\"766\":{\"resourceType\":\"766\"},\"767\":{\"resourceType\":\"767\"},\"768\":{\"resourceType\":\"768\"},\"769\":{\"resourceType\":\"769\"},\"770\":{\"resourceType\":\"770\"},\"771\":{\"resourceType\":\"771\"},\"772\":{\"resourceType\":\"772\"},\"773\":{\"resourceType\":\"773\"},\"774\":{\"resourceType\":\"774\"},\"775\":{\"resourceType\":\"775\"},\"776\":{\"resourceType\":\"776\"},\"777\":{\"resourceType\":\"777\"},\"778\":{\"resourceType\":\"778\"},\"779\":{\"resourceType\":\"779\"},\"780\":{\"resourceType\":\"780\"},\"781\":{\"resourceType\":\"781\"},\"782\":{\"resourceType\":\"782\"},\"783\":{\"resourceType\":\"783\"},\"784\":{\"resourceType\":\"784\"},\"785\":{\"resourceType\":\"785\"},\"786\":{\"resourceType\":\"786\"},\"787\":{\"resourceType\":\"787\"},\"788\":{\"resourceType\":\"788\"},\"789\":{\"resourceType\":\"789\"},\"790\":{\"resourceType\":\"790\"},\"791\":{\"resourceType\":\"791\"},\"792\":{\"resourceType\":\"792\"},\"793\":{\"resourceType\":\"793\"},\"794\":{\"resourceType\":\"794\"},\"795\":{\"resourceType\":\"795\"},\"796\":{\"resourceType\":\"796\"},\"797\":{\"resourceType\":\"797\"},\"798\":{\"resourceType\":\"798\"},\"799\":{\"resourceType\":\"799\"},\"800\":{\"resourceType\":\"800\"},\"801\":{\"resourceType\":\"801\"},\"802\":{\"resourceType\":\"802\"},\"803\":{\"resourceType\":\"803\"},\"804\":{\"resourceType\":\"804\"},\"805\":{\"resourceType\":\"805\"},\"806\":{\"resourceType\":\"806\"},\"807\":{\"resourceType\":\"807\"},\"808\":{\"resourceType\":\"808\"},\"809\":{\"resourceType\":\"809\"},\"810\":{\"resourceType\":\"810\"},\"811\":{\"resourceType\":\"811\"},\"812\":{\"resourceType\":\"812\"},\"813\":{\"resourceType\":\"813\"},\"814\":{\"resourceType\":\"814\"},\"815\":{\"resourceType\":\"815\"},\"816\":{\"resourceType\":\"816\"},\"817\":{\"resourceType\":\"817\"},\"818\":{\"resourceType\":\"818\"},\"819\":{\"resourceType\":\"819\"},\"820\":{\"resourceType\":\"820\"},\"821\":{\"resourceType\":\"821\"},\"822\":{\"resourceType\":\"822\"},\"823\":{\"resourceType\":\"823\"},\"824\":{\"resourceType\":\"824\"},\"825\":{\"resourceType\":\"825\"},\"826\":{\"resourceType\":\"826\"},\"827\":{\"resourceType\":\"827\"},\"828\":{\"resourceType\":\"828\"},\"829\":{\"resourceType\":\"829\"},\"830\":{\"resourceType\":\"830\"},\"831\":{\"resourceType\":\"831\"},\"832\":{\"resourceType\":\"832\"},\"833\":{\"resourceType\":\"833\"},\"834\":{\"resourceType\":\"834\"},\"835\":{\"resourceType\":\"835\"},\"836\":{\"resourceType\":\"836\"},\"837\":{\"resourceType\":\"837\"},\"838\":{\"resourceType\":\"838\"},\"839\":{\"resourceType\":\"839\"},\"840\":{\"resourceType\":\"840\"},\"841\":{\"resourceType\":\"841\"},\"842\":{\"resourceType\":\"842\"},\"843\":{\"resourceType\":\"843\"},\"844\":{\"resourceType\":\"844\"},\"845\":{\"resourceType\":\"845\"},\"846\":{\"resourceType\":\"846\"},\"847\":{\"resourceType\":\"847\"},\"848\":{\"resourceType\":\"848\"},\"849\":{\"resourceType\":\"849\"},\"850\":{\"resourceType\":\"850\"},\"851\":{\"resourceType\":\"851\"},\"852\":{\"resourceType\":\"852\"},\"853\":{\"resourceType\":\"853\"},\"854\":{\"resourceType\":\"854\"},\"855\":{\"resourceType\":\"855\"},\"856\":{\"resourceType\":\"856\"},\"857\":{\"resourceType\":\"857\"},\"858\":{\"resourceType\":\"858\"},\"859\":{\"resourceType\":\"859\"},\"860\":{\"resourceType\":\"860\"},\"861\":{\"resourceType\":\"861\"},\"862\":{\"resourceType\":\"862\"},\"863\":{\"resourceType\":\"863\"},\"864\":{\"resourceType\":\"864\"},\"865\":{\"resourceType\":\"865\"},\"866\":{\"resourceType\":\"866\"},\"867\":{\"resourceType\":\"867\"},\"868\":{\"resourceType\":\"868\"},\"869\":{\"resourceType\":\"869\"},\"870\":{\"resourceType\":\"870\"},\"871\":{\"resourceType\":\"871\"},\"872\":{\"resourceType\":\"872\"},\"873\":{\"resourceType\":\"873\"},\"874\":{\"resourceType\":\"874\"},\"875\":{\"resourceType\":\"875\"},\"876\":{\"resourceType\":\"876\"},\"877\":{\"resourceType\":\"877\"},\"878\":{\"resourceType\":\"878\"},\"879\":{\"resourceType\":\"879\"},\"880\":{\"resourceType\":\"880\"},\"881\":{\"resourceType\":\"881\"},\"882\":{\"resourceType\":\"882\"},\"883\":{\"resourceType\":\"883\"},\"884\":{\"resourceType\":\"884\"},\"885\":{\"resourceType\":\"885\"},\"886\":{\"resourceType\":\"886\"},\"887\":{\"resourceType\":\"887\"},\"888\":{\"resourceType\":\"888\"},\"889\":{\"resourceType\":\"889\"},\"890\":{\"resourceType\":\"890\"},\"891\":{\"resourceType\":\"891\"},\"892\":{\"resourceType\":\"892\"},\"893\":{\"resourceType\":\"893\"},\"894\":{\"resourceType\":\"894\"},\"895\":{\"resourceType\":\"895\"},\"896\":{\"resourceType\":\"896\"},\"897\":{\"resourceType\":\"897\"},\"898\":{\"resourceType\":\"898\"},\"899\":{\"resourceType\":\"899\"},\"900\":{\"resourceType\":\"900\"},\"901\":{\"resourceType\":\"901\"},\"902\":{\"resourceType\":\"902\"},\"903\":{\"resourceType\":\"903\"},\"904\":{\"resourceType\":\"904\"},\"905\":{\"resourceType\":\"905\"},\"906\":{\"resourceType\":\"906\"},\"907\":{\"resourceType\":\"907\"},\"908\":{\"resourceType\":\"908\"},\"909\":{\"resourceType\":\"909\"},\"910\":{\"resourceType\":\"910\"},\"911\":{\"resourceType\":\"911\"},\"912\":{\"resourceType\":\"912\"},\"913\":{\"resourceType\":\"913\"},\"914\":{\"resourceType\":\"914\"},\"915\":{\"resourceType\":\"915\"},\"916\":{\"resourceType\":\"916\"},\"917\":{\"resourceType\":\"917\"},\"918\":{\"resourceType\":\"918\"},\"919\":{\"resourceType\":\"919\"},\"920\":{\"resourceType\":\"920\"},\"921\":{\"resourceType\":\"921\"},\"922\":{\"resourceType\":\"922\"},\"923\":{\"resourceType\":\"923\"},\"924\":{\"resourceType\":\"924\"},\"925\":{\"resourceType\":\"925\"},\"926\":{\"resourceType\":\"926\"},\"927\":{\"resourceType\":\"927\"},\"928\":{\"resourceType\":\"928\"},\"929\":{\"resourceType\":\"929\"},\"930\":{\"resourceType\":\"930\"},\"931\":{\"resourceType\":\"931\"},\"932\":{\"resourceType\":\"932\"},\"933\":{\"resourceType\":\"933\"},\"934\":{\"resourceType\":\"934\"},\"935\":{\"resourceType\":\"935\"},\"936\":{\"resourceType\":\"936\"},\"937\":{\"resourceType\":\"937\"},\"938\":{\"resourceType\":\"938\"},\"939\":{\"resourceType\":\"939\"},\"940\":{\"resourceType\":\"940\"},\"941\":{\"resourceType\":\"941\"},\"942\":{\"resourceType\":\"942\"},\"943\":{\"resourceType\":\"943\"},\"944\":{\"resourceType\":\"944\"},\"945\":{\"resourceType\":\"945\"},\"946\":{\"resourceType\":\"946\"},\"947\":{\"resourceType\":\"947\"},\"948\":{\"resourceType\":\"948\"},\"949\":{\"resourceType\":\"949\"},\"950\":{\"resourceType\":\"950\"},\"951\":{\"resourceType\":\"951\"},\"952\":{\"resourceType\":\"952\"},\"953\":{\"resourceType\":\"953\"},\"954\":{\"resourceType\":\"954\"},\"955\":{\"resourceType\":\"955\"},\"956\":{\"resourceType\":\"956\"},\"957\":{\"resourceType\":\"957\"},\"958\":{\"resourceType\":\"958\"},\"959\":{\"resourceType\":\"959\"},\"960\":{\"resourceType\":\"960\"},\"961\":{\"resourceType\":\"961\"},\"962\":{\"resourceType\":\"962\"},\"963\":{\"resourceType\":\"963\"},\"964\":{\"resourceType\":\"964\"},\"965\":{\"resourceType\":\"965\"},\"966\":{\"resourceType\":\"966\"},\"967\":{\"resourceType\":\"967\"},\"968\":{\"resourceType\":\"968\"},\"969\":{\"resourceType\":\"969\"},\"970\":{\"resourceType\":\"970\"},\"971\":{\"resourceType\":\"971\"},\"972\":{\"resourceType\":\"972\"},\"973\":{\"resourceType\":\"973\"},\"974\":{\"resourceType\":\"974\"},\"975\":{\"resourceType\":\"975\"},\"976\":{\"resourceType\":\"976\"},\"977\":{\"resourceType\":\"977\"},\"978\":{\"resourceType\":\"978\"},\"979\":{\"resourceType\":\"979\"},\"980\":{\"resourceType\":\"980\"},\"981\":{\"resourceType\":\"981\"},\"982\":{\"resourceType\":\"982\"},\"983\":{\"resourceType\":\"983\"},\"984\":{\"resourceType\":\"984\"},\"985\":{\"resourceType\":\"985\"},\"986\":{\"resourceType\":\"986\"},\"987\":{\"resourceType\":\"987\"},\"988\":{\"resourceType\":\"988\"},\"989\":{\"resourceType\":\"989\"},\"990\":{\"resourceType\":\"990\"},\"991\":{\"resourceType\":\"991\"},\"992\":{\"resourceType\":\"992\"},\"993\":{\"resourceType\":\"993\"},\"994\":{\"resourceType\":\"994\"},\"995\":{\"resourceType\":\"995\"},\"996\":{\"resourceType\":\"996\"},\"997\":{\"resourceType\":\"997\"},\"998\":{\"resourceType\":\"998\"},\"999\":{\"resourceType\":\"999\"},\"1000\":{\"resourceType\":\"1000\"},\"1001\":{\"resourceType\":\"1001\"},\"1002\":{\"resourceType\":\"1002\"},\"1003\":{\"resourceType\":\"1003\"},\"1004\":{\"resourceType\":\"1004\"},\"1005\":{\"resourceType\":\"1005\"},\"1006\":{\"resourceType\":\"1006\"},\"1007\":{\"resourceType\":\"1007\"},\"1008\":{\"resourceType\":\"1008\"},\"1009\":{\"resourceType\":\"1009\"},\"1010\":{\"resourceType\":\"1010\"},\"1011\":{\"resourceType\":\"1011\"},\"1012\":{\"resourceType\":\"1012\"},\"1013\":{\"resourceType\":\"1013\"},\"1014\":{\"resourceType\":\"1014\"},\"1015\":{\"resourceType\":\"1015\"},\"1016\":{\"resourceType\":\"1016\"},\"1017\":{\"resourceType\":\"1017\"},\"1018\":{\"resourceType\":\"1018\"},\"1019\":{\"resourceType\":\"1019\"},\"1020\":{\"resourceType\":\"1020\"},\"1021\":{\"resourceType\":\"1021\"},\"1022\":{\"resourceType\":\"1022\"},\"1023\":{\"resourceType\":\"1023\"},\"1024\":{\"resourceType\":\"1024\"},\"1025\":{\"resourceType\":\"1025\"},\"1026\":{\"resourceType\":\"1026\"},\"1027\":{\"resourceType\":\"1027\"},\"1028\":{\"resourceType\":\"1028\"},\"1029\":{\"resourceType\":\"1029\"},\"1030\":{\"resourceType\":\"1030\"},\"1031\":{\"resourceType\":\"1031\"},\"1032\":{\"resourceType\":\"1032\"},\"1033\":{\"resourceType\":\"1033\"},\"1034\":{\"resourceType\":\"1034\"},\"1035\":{\"resourceType\":\"1035\"},\"1036\":{\"resourceType\":\"1036\"},\"1037\":{\"resourceType\":\"1037\"},\"1038\":{\"resourceType\":\"1038\"},\"1039\":{\"resourceType\":\"1039\"},\"1040\":{\"resourceType\":\"1040\"},\"1041\":{\"resourceType\":\"1041\"},\"1042\":{\"resourceType\":\"1042\"},\"1043\":{\"resourceType\":\"1043\"},\"1044\":{\"resourceType\":\"1044\"},\"1045\":{\"resourceType\":\"1045\"},\"1046\":{\"resourceType\":\"1046\"},\"1047\":{\"resourceType\":\"1047\"},\"1048\":{\"resourceType\":\"1048\"},\"1049\":{\"resourceType\":\"1049\"},\"1050\":{\"resourceType\":\"1050\"},\"1051\":{\"resourceType\":\"1051\"},\"1052\":{\"resourceType\":\"1052\"},\"1053\":{\"resourceType\":\"1053\"},\"1054\":{\"resourceType\":\"1054\"},\"1055\":{\"resourceType\":\"1055\"},\"1056\":{\"resourceType\":\"1056\"},\"1057\":{\"resourceType\":\"1057\"},\"1058\":{\"resourceType\":\"1058\"},\"1059\":{\"resourceType\":\"1059\"},\"1060\":{\"resourceType\":\"1060\"},\"1061\":{\"resourceType\":\"1061\"},\"1062\":{\"resourceType\":\"1062\"},\"1063\":{\"resourceType\":\"1063\"},\"1064\":{\"resourceType\":\"1064\"},\"1065\":{\"resourceType\":\"1065\"},\"1066\":{\"resourceType\":\"1066\"},\"1067\":{\"resourceType\":\"1067\"},\"1068\":{\"resourceType\":\"1068\"},\"1069\":{\"resourceType\":\"1069\"},\"1070\":{\"resourceType\":\"1070\"},\"1071\":{\"resourceType\":\"1071\"},\"1072\":{\"resourceType\":\"1072\"},\"1073\":{\"resourceType\":\"1073\"},\"1074\":{\"resourceType\":\"1074\"},\"1075\":{\"resourceType\":\"1075\"},\"1076\":{\"resourceType\":\"1076\"},\"1077\":{\"resourceType\":\"1077\"},\"1078\":{\"resourceType\":\"1078\"},\"1079\":{\"resourceType\":\"1079\"},\"1080\":{\"resourceType\":\"1080\"},\"1081\":{\"resourceType\":\"1081\"},\"1082\":{\"resourceType\":\"1082\"},\"1083\":{\"resourceType\":\"1083\"},\"1084\":{\"resourceType\":\"1084\"}}",
                response);
    }

    private String getJSON(String path, String depth) throws Throwable {
        MockSlingHttpServletRequest request = new MockSlingHttpServletRequest(path, depth, ".json", null, null);
        request.setMethod("GET");
        request.setResourceResolver(resolver);
        request.setResource(resolver.getResource(path));

        MockSlingHttpServletResponse response = new MockSlingHttpServletResponse();
        JsonRenderer renderer = new JsonRenderer(1000, true);
        renderer.render(request, response);
        return response.getOutput().toString();
    }
}
