/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.engine.extension.PrintWriterResponseWrapper;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=includeResource"})
public class ResourceRuntimeExtension
implements RuntimeExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRuntimeExtension.class);
    private static final String OPTION_RESOURCE_TYPE = "resourceType";
    private static final String OPTION_PATH = "path";
    private static final String OPTION_PREPEND_PATH = "prependPath";
    private static final String OPTION_APPEND_PATH = "appendPath";
    private static final String OPTION_SELECTORS = "selectors";
    private static final String OPTION_REMOVE_SELECTORS = "removeSelectors";
    private static final String OPTION_ADD_SELECTORS = "addSelectors";
    private static final String OPTION_REQUEST_ATTRIBUTES = "requestAttributes";

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("includeResource", arguments, 2);
        return this.provideResource(renderContext, arguments[0], (Map)arguments[1]);
    }

    private String provideResource(RenderContext renderContext, Object pathObj, Map<String, Object> options) {
        HashMap<String, Object> opts = new HashMap<String, Object>(options);
        Bindings bindings = renderContext.getBindings();
        SlingHttpServletRequest request = BindingsUtils.getRequest(bindings);
        Map<String, Object> originalAttributes = ExtensionUtils.setRequestAttributes(request, (Map)options.remove(OPTION_REQUEST_ATTRIBUTES));
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (pathObj instanceof Resource) {
            Resource includedResource = (Resource)pathObj;
            RequestDispatcherOptions requestDispatcherOptions = this.handleDispatcherOptions(request, new LinkedHashSet<String>(), opts, runtimeObjectModel);
            this.includeResource(request, bindings, printWriter, includedResource, requestDispatcherOptions);
        } else {
            String includePath = runtimeObjectModel.toString(pathObj);
            if ((includePath = this.buildPath(includePath, options, request.getResource())) != null) {
                Resource includedResource = request.getResourceResolver().getResource(includePath);
                if (includedResource != null) {
                    RequestDispatcherOptions requestDispatcherOptions = this.handleDispatcherOptions(request, new LinkedHashSet<String>(), opts, runtimeObjectModel);
                    this.includeResource(request, bindings, printWriter, includedResource, requestDispatcherOptions);
                } else {
                    PathInfo pathInfo = new PathInfo(includePath);
                    RequestDispatcherOptions requestDispatcherOptions = this.handleDispatcherOptions(request, pathInfo.selectors, opts, runtimeObjectModel);
                    this.includeResource(request, bindings, printWriter, pathInfo.path, requestDispatcherOptions);
                }
            } else {
                RequestDispatcherOptions requestDispatcherOptions = this.handleDispatcherOptions(request, new LinkedHashSet<String>(), opts, runtimeObjectModel);
                this.includeResource(request, bindings, printWriter, request.getResource(), requestDispatcherOptions);
            }
        }
        ExtensionUtils.setRequestAttributes(request, originalAttributes);
        return writer.toString();
    }

    private RequestDispatcherOptions handleDispatcherOptions(SlingHttpServletRequest request, Set<String> selectors, Map<String, Object> options, RuntimeObjectModel runtimeObjectModel) {
        String resourceType;
        Object selectorsObject;
        RequestDispatcherOptions requestDispatcherOptions = new RequestDispatcherOptions();
        if (selectors.isEmpty()) {
            selectors.addAll(Arrays.asList(request.getRequestPathInfo().getSelectors()));
        }
        requestDispatcherOptions.setAddSelectors(this.getSelectorString(selectors));
        requestDispatcherOptions.setReplaceSelectors("");
        if (options.containsKey(OPTION_SELECTORS)) {
            selectorsObject = this.getAndRemoveOption(options, OPTION_SELECTORS);
            selectors.clear();
            this.addSelectors(selectors, selectorsObject, runtimeObjectModel);
            requestDispatcherOptions.setAddSelectors(this.getSelectorString(selectors));
            requestDispatcherOptions.setReplaceSelectors("");
        }
        if (options.containsKey(OPTION_ADD_SELECTORS)) {
            selectorsObject = this.getAndRemoveOption(options, OPTION_ADD_SELECTORS);
            this.addSelectors(selectors, selectorsObject, runtimeObjectModel);
            requestDispatcherOptions.setAddSelectors(this.getSelectorString(selectors));
            requestDispatcherOptions.setReplaceSelectors("");
        }
        if (options.containsKey(OPTION_REMOVE_SELECTORS)) {
            Object selectorString;
            selectorsObject = this.getAndRemoveOption(options, OPTION_REMOVE_SELECTORS);
            if (selectorsObject instanceof String) {
                String[] parts;
                selectorString = (Object[])selectorsObject;
                for (String s : parts = selectorString.split("\\.")) {
                    selectors.remove(s);
                }
            } else if (selectorsObject instanceof Object[]) {
                selectorString = (Object[])selectorsObject;
                int n = ((Object[])selectorString).length;
                for (int i = 0; i < n; ++i) {
                    Object s = selectorString[i];
                    String selector = runtimeObjectModel.toString(s);
                    if (!StringUtils.isNotEmpty((CharSequence)selector)) continue;
                    selectors.remove(selector);
                }
            } else if (selectorsObject == null) {
                selectors.clear();
            }
            if (StringUtils.isEmpty((CharSequence)(selectorString = this.getSelectorString(selectors)))) {
                requestDispatcherOptions.setReplaceSelectors("");
            } else {
                requestDispatcherOptions.setAddSelectors(this.getSelectorString(selectors));
                requestDispatcherOptions.setReplaceSelectors("");
            }
        }
        if (options.containsKey(OPTION_RESOURCE_TYPE) && StringUtils.isNotEmpty((CharSequence)(resourceType = runtimeObjectModel.toString(this.getAndRemoveOption(options, OPTION_RESOURCE_TYPE))))) {
            requestDispatcherOptions.setForceResourceType(resourceType);
        }
        return requestDispatcherOptions;
    }

    private void addSelectors(Set<String> selectors, Object selectorsObject, RuntimeObjectModel runtimeObjectModel) {
        if (selectorsObject instanceof String) {
            String selectorString = (String)selectorsObject;
            String[] parts = selectorString.split("\\.");
            selectors.addAll(Arrays.asList(parts));
        } else if (selectorsObject instanceof Object[]) {
            for (Object s : (Object[])selectorsObject) {
                String selector = runtimeObjectModel.toString(s);
                if (!StringUtils.isNotEmpty((CharSequence)selector)) continue;
                selectors.add(selector);
            }
        }
    }

    private String buildPath(String path, Map<String, Object> options, Resource currentResource) {
        String finalPath;
        String prependPath = this.getOption(OPTION_PREPEND_PATH, options, "");
        if (prependPath == null) {
            prependPath = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)prependPath)) {
            if (!prependPath.startsWith("/")) {
                prependPath = "/" + prependPath;
            }
            if (!prependPath.endsWith("/")) {
                prependPath = prependPath + "/";
            }
        }
        path = this.getOption(OPTION_PATH, options, StringUtils.isNotEmpty((CharSequence)path) ? path : "");
        String appendPath = this.getOption(OPTION_APPEND_PATH, options, "");
        if (appendPath == null) {
            appendPath = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)appendPath) && !appendPath.startsWith("/")) {
            appendPath = "/" + appendPath;
        }
        if (!(finalPath = prependPath + path + appendPath).startsWith("/")) {
            finalPath = currentResource.getPath() + "/" + finalPath;
        }
        return ResourceUtil.normalize((String)finalPath);
    }

    private String getOption(String option, Map<String, Object> options, String defaultValue) {
        if (options.containsKey(option)) {
            return (String)options.get(option);
        }
        return defaultValue;
    }

    private Object getAndRemoveOption(Map<String, Object> options, String property) {
        return options.remove(property);
    }

    private String getSelectorString(Set<String> selectors) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : selectors) {
            sb.append(s);
            if (i >= selectors.size() - 1) continue;
            sb.append(".");
            ++i;
        }
        String selectorString = sb.toString();
        return StringUtils.isNotEmpty((CharSequence)selectorString) ? selectorString : null;
    }

    private void includeResource(SlingHttpServletRequest request, Bindings bindings, PrintWriter out, String path, RequestDispatcherOptions requestDispatcherOptions) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new SightlyException("Resource path cannot be empty");
        }
        Resource includeRes = request.getResourceResolver().resolve(path);
        if (ResourceUtil.isNonExistingResource((Resource)includeRes)) {
            String resourceType = request.getResource().getResourceType();
            if (requestDispatcherOptions.containsKey((Object)"forceResourceType")) {
                resourceType = requestDispatcherOptions.getForceResourceType();
            }
            includeRes = new SyntheticResource(request.getResourceResolver(), path, resourceType);
        }
        this.includeResource(request, bindings, out, includeRes, requestDispatcherOptions);
    }

    private void includeResource(SlingHttpServletRequest request, Bindings bindings, PrintWriter out, Resource includeRes, RequestDispatcherOptions requestDispatcherOptions) {
        if (includeRes == null) {
            throw new SightlyException("Resource cannot be null");
        }
        if (request.getResource().getPath().equals(includeRes.getPath())) {
            String requestSelectorString = request.getRequestPathInfo().getSelectorString();
            String requestDispatcherAddSelectors = requestDispatcherOptions.getAddSelectors();
            if ((requestSelectorString == null ? requestDispatcherAddSelectors == null : requestSelectorString.equals(requestDispatcherAddSelectors)) && "".equals(requestDispatcherOptions.getReplaceSelectors()) && (requestDispatcherOptions.getForceResourceType() == null || requestDispatcherOptions.getForceResourceType().equals(request.getResource().getResourceType()))) {
                LOGGER.warn("Will not include resource {} since this will lead to a {} exception.", (Object)includeRes.getPath(), (Object)"org.apache.sling.api.request.RecursionTooDeepException");
                return;
            }
        }
        PrintWriterResponseWrapper customResponse = new PrintWriterResponseWrapper(out, BindingsUtils.getResponse(bindings));
        RequestDispatcher dispatcher = request.getRequestDispatcher(includeRes, requestDispatcherOptions);
        try {
            if (dispatcher == null) {
                throw new SightlyException("Failed to include resource " + includeRes.getPath());
            }
            dispatcher.include((ServletRequest)request, (ServletResponse)customResponse);
        }
        catch (Exception e) {
            throw new SightlyException("Failed to include resource " + includeRes.getPath(), (Throwable)e);
        }
    }

    private class PathInfo {
        private String path;
        private Set<String> selectors;

        PathInfo(String path) {
            this.selectors = this.getSelectorsFromPath(path);
            if (this.selectors.isEmpty()) {
                this.path = path;
            } else {
                String selectorString = ResourceRuntimeExtension.this.getSelectorString(this.selectors);
                this.path = path.replace("." + selectorString, "");
            }
        }

        private Set<String> getSelectorsFromPath(String path) {
            LinkedHashSet<String> selectors = new LinkedHashSet<String>();
            if (path != null) {
                int lastDotPos;
                int dotPos;
                String processingPath = path;
                int lastSlashPos = path.lastIndexOf(47);
                if (lastSlashPos > -1) {
                    processingPath = path.substring(lastSlashPos + 1, path.length());
                }
                if ((dotPos = processingPath.indexOf(46)) > -1 && (lastDotPos = processingPath.lastIndexOf(46)) > dotPos) {
                    String selectorString = processingPath.substring(dotPos + 1, lastDotPos);
                    String[] selectorParts = selectorString.split("\\.");
                    selectors.addAll(Arrays.asList(selectorParts));
                }
            }
            return selectors;
        }
    }
}

