/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=format"})
public class FormatFilterExtension
implements RuntimeExtension {
    protected static final String FORMAT_OPTION = "format";
    protected static final String TYPE_OPTION = "type";
    protected static final String LOCALE_OPTION = "locale";
    protected static final String TIMEZONE_OPTION = "timezone";
    protected static final String DATE_FORMAT_TYPE = "date";
    protected static final String NUMBER_FORMAT_TYPE = "number";
    protected static final String STRING_FORMAT_TYPE = "string";
    private static final Logger LOG = LoggerFactory.getLogger(FormatFilterExtension.class);
    private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("\\{\\d+}");

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount(FORMAT_OPTION, arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String source = runtimeObjectModel.toString(arguments[0]);
        Map options = (Map)arguments[1];
        String formattingType = runtimeObjectModel.toString(options.get(TYPE_OPTION));
        Object formatObject = options.get(FORMAT_OPTION);
        boolean hasPlaceHolders = PLACEHOLDER_REGEX.matcher(source).find();
        if (STRING_FORMAT_TYPE.equals(formattingType)) {
            return this.getFormattedString(runtimeObjectModel, source, formatObject);
        }
        if (DATE_FORMAT_TYPE.equals(formattingType) || !hasPlaceHolders && runtimeObjectModel.isDate(formatObject)) {
            return this.getDateFormattedString(runtimeObjectModel, source, options, formatObject);
        }
        if (NUMBER_FORMAT_TYPE.equals(formattingType) || !hasPlaceHolders && runtimeObjectModel.isNumber(formatObject)) {
            return this.getNumberFormattedString(runtimeObjectModel, source, options, formatObject);
        }
        if (hasPlaceHolders) {
            return this.getFormattedString(runtimeObjectModel, source, formatObject);
        }
        try {
            DateTimeFormatter.ofPattern(source);
            return this.getDateFormattedString(runtimeObjectModel, source, options, formatObject);
        }
        catch (IllegalArgumentException ex) {
            LOG.trace("Not a datetime format: {}", (Object)source, (Object)ex);
            try {
                new DecimalFormat(source);
                return this.getNumberFormattedString(runtimeObjectModel, source, options, formatObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.getFormattedString(runtimeObjectModel, source, formatObject);
            }
        }
    }

    private Object getFormattedString(RuntimeObjectModel runtimeObjectModel, String source, Object formatObject) {
        Object[] params = this.decodeParams(runtimeObjectModel, formatObject);
        return this.formatString(runtimeObjectModel, source, params);
    }

    private String getNumberFormattedString(RuntimeObjectModel runtimeObjectModel, String source, Map<String, Object> options, Object formatObject) {
        Locale locale = this.getLocale(runtimeObjectModel, options);
        return this.formatNumber(source, runtimeObjectModel.toNumber(formatObject), locale);
    }

    private String getDateFormattedString(RuntimeObjectModel runtimeObjectModel, String source, Map<String, Object> options, Object formatObject) {
        Locale locale = this.getLocale(runtimeObjectModel, options);
        TimeZone timezone = this.getTimezone(runtimeObjectModel, options);
        return this.formatDate(source, runtimeObjectModel.toDate(formatObject), locale, timezone);
    }

    private Locale getLocale(RuntimeObjectModel runtimeObjectModel, Map<String, Object> options) {
        String localeOption = null;
        if (options.containsKey(LOCALE_OPTION)) {
            localeOption = runtimeObjectModel.toString(options.get(LOCALE_OPTION));
        }
        if (StringUtils.isNotBlank(localeOption)) {
            return LocaleUtils.toLocale(localeOption);
        }
        return null;
    }

    private TimeZone getTimezone(RuntimeObjectModel runtimeObjectModel, Map<String, Object> options) {
        if (options.containsKey(TIMEZONE_OPTION)) {
            return TimeZone.getTimeZone(runtimeObjectModel.toString(options.get(TIMEZONE_OPTION)));
        }
        Object formatObject = options.get(FORMAT_OPTION);
        if (formatObject instanceof Calendar) {
            return ((Calendar)formatObject).getTimeZone();
        }
        return TimeZone.getDefault();
    }

    private Object[] decodeParams(RuntimeObjectModel runtimeObjectModel, Object paramObj) {
        if (paramObj == null) {
            return null;
        }
        if (runtimeObjectModel.isCollection(paramObj)) {
            return runtimeObjectModel.toCollection(paramObj).toArray();
        }
        return new Object[]{paramObj};
    }

    private String formatString(RuntimeObjectModel runtimeObjectModel, String source, Object[] params) {
        if (params == null) {
            return null;
        }
        Matcher matcher = PLACEHOLDER_REGEX.matcher(source);
        StringBuilder builder = new StringBuilder();
        int lastPos = 0;
        boolean matched = true;
        while (matched) {
            matched = matcher.find();
            if (!matched) continue;
            String group = matcher.group();
            int paramIndex = Integer.parseInt(group.substring(1, group.length() - 1));
            String replacement = this.toString(runtimeObjectModel, params, paramIndex);
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            builder.append(source, lastPos, matchStart).append(replacement);
            lastPos = matchEnd;
        }
        builder.append(source, lastPos, source.length());
        return builder.toString();
    }

    private String toString(RuntimeObjectModel runtimeObjectModel, Object[] params, int index) {
        if (index >= 0 && index < params.length) {
            return runtimeObjectModel.toString(params[index]);
        }
        return "";
    }

    private FormatStyle getPredefinedFormattingStyleFromValue(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "default": 
            case "medium": {
                return FormatStyle.MEDIUM;
            }
            case "short": {
                return FormatStyle.SHORT;
            }
            case "long": {
                return FormatStyle.LONG;
            }
            case "full": {
                return FormatStyle.FULL;
            }
        }
        return null;
    }

    private String formatDate(String format, Date date, Locale locale, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        try {
            DateTimeFormatter formatter;
            FormatStyle formattingStyle = this.getPredefinedFormattingStyleFromValue(format);
            if (formattingStyle != null) {
                formatter = DateTimeFormatter.ofLocalizedDate(formattingStyle);
                if (locale != null) {
                    formatter = formatter.withLocale(locale);
                }
            } else {
                format = format.replaceAll("([{}#])", "'$1'");
                format = format.replaceAll("([GMLQqEec])\\1{4}", "$1$1$1$1");
                formatter = locale != null ? DateTimeFormatter.ofPattern(format, locale) : DateTimeFormatter.ofPattern(format);
            }
            return formatter.format((TemporalAccessor)((Object)(timezone != null ? date.toInstant().atZone(timezone.toZoneId()) : date.toInstant())));
        }
        catch (Exception e) {
            String error = String.format("Error during formatting of date %s with format %s, locale %s and timezone %s", date, format, locale, timezone);
            throw new SightlyException(error, (Throwable)e);
        }
    }

    private String formatNumber(String format, Number number, Locale locale) {
        if (number == null) {
            return null;
        }
        try {
            DecimalFormat formatter = locale != null ? new DecimalFormat(format, new DecimalFormatSymbols(locale)) : new DecimalFormat(format);
            return formatter.format(number);
        }
        catch (Exception e) {
            String error = String.format("Error during formatting of number %s with format %s and locale %s", number, format, locale);
            throw new SightlyException(error, (Throwable)e);
        }
    }
}

