/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.core.impl.DefaultSlingScript;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class}, property={"service.vendor=The Apache Software Foundation", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.selectors=SLING_availablebindings", "sling.servlet.methods=GET", "sling.servlet.extensions=json"})
public class SlingBindingsVariablesListJsonServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -6744726829737263875L;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private WebConsoleSecurityProvider webconsoleSecurity;
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private BindingsValuesProvidersByContext bindingsValuesProviderTracker;
    private BundleContext bundleContext;
    private static final String PARAMETER_EXTENSION = "extension";

    @Activate
    protected void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        boolean allowed = true;
        if (this.webconsoleSecurity == null) {
            this.log("Access forbidden as the WebConsoleSecurity reference is not set");
            allowed = false;
        } else if (!(this.webconsoleSecurity instanceof WebConsoleSecurityProvider2)) {
            this.log("Access forbidden as the WebConsoleSecurity reference does not implement WebConsoleSecurityProvider2");
            allowed = false;
        } else if (!((WebConsoleSecurityProvider2)this.webconsoleSecurity).authenticate((HttpServletRequest)request, (HttpServletResponse)response)) {
            this.log("Access forbidden as the WebConsoleSecurity component returned false");
            allowed = false;
        }
        if (!allowed) {
            if (!response.isCommitted()) {
                response.sendError(403);
            }
            return;
        }
        response.setContentType("application/json");
        JSONWriter jsonWriter = new JSONWriter(response.getWriter());
        jsonWriter.array();
        String requestedExtension = request.getParameter(PARAMETER_EXTENSION);
        if (requestedExtension != null && !requestedExtension.isEmpty()) {
            ScriptEngine selectedScriptEngine = this.scriptEngineManager.getEngineByExtension(requestedExtension);
            if (selectedScriptEngine == null) {
                throw new IllegalArgumentException("Invalid extension requested: " + requestedExtension);
            }
            this.writeBindingsToJsonWriter(jsonWriter, selectedScriptEngine.getFactory(), request, response);
        } else {
            for (ScriptEngineFactory engineFactory : this.scriptEngineManager.getEngineFactories()) {
                this.writeBindingsToJsonWriter(jsonWriter, engineFactory, request, response);
            }
        }
        jsonWriter.endArray();
    }

    private void writeBindingsToJsonWriter(JSONWriter jsonWriter, ScriptEngineFactory engineFactory, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        jsonWriter.object();
        jsonWriter.key("engine");
        jsonWriter.value(engineFactory.getEngineName());
        jsonWriter.key("extensions");
        jsonWriter.value(engineFactory.getExtensions());
        Bindings bindings = this.getBindingsByEngine(engineFactory, request, response);
        jsonWriter.key("bindings");
        jsonWriter.array();
        for (Map.Entry entry : bindings.entrySet()) {
            jsonWriter.object();
            jsonWriter.key("name");
            jsonWriter.value(entry.getKey());
            jsonWriter.key("class");
            jsonWriter.value(entry.getValue() == null ? "&lt;NO VALUE&gt;" : entry.getValue().getClass().getName());
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private Bindings getBindingsByEngine(ScriptEngineFactory scriptEngineFactory, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String context = "request";
        Collection bindingsValuesProviders = this.bindingsValuesProviderTracker.getBindingsValuesProviders(scriptEngineFactory, context);
        NonExistingResource invalidScriptResource = new NonExistingResource(request.getResourceResolver(), "some/invalid/scriptpath");
        DefaultSlingScript defaultSlingScript = new DefaultSlingScript(this.bundleContext, (Resource)invalidScriptResource, scriptEngineFactory.getScriptEngine(), bindingsValuesProviders, null, null);
        SlingBindings initalBindings = new SlingBindings();
        initalBindings.setRequest(request);
        initalBindings.setResponse(response);
        Bindings bindings = defaultSlingScript.verifySlingBindings(initalBindings);
        bindings.put("org.apache.sling.api.scripting.ScriptResourceResolver", (Object)request.getResourceResolver());
        return bindings;
    }
}

