/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.commons.compiler.source.JavaEscapeHelper;
import org.apache.sling.scripting.core.impl.ServiceCache;
import org.apache.sling.scripting.core.impl.bundled.PrecompiledScript;
import org.apache.sling.scripting.core.impl.bundled.Script;
import org.apache.sling.scripting.core.impl.bundled.ScriptContextProvider;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnitCapability;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnitFinder;
import org.apache.sling.scripting.spi.bundle.TypeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class BundleRenderUnitFinderImpl
implements BundledRenderUnitFinder,
BundleListener {
    @Reference
    ScriptContextProvider scriptContextProvider;
    private static final String NS_JAVAX_SCRIPT_CAPABILITY = "javax.script";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private final ConcurrentHashMap<BundleContext, ServiceCache> perContextServiceCache = new ConcurrentHashMap();

    @Nullable
    public BundledRenderUnit findUnit(@NotNull BundleContext context, @NotNull Set<TypeProvider> providers, @NotNull Set<TypeProvider> allProviders) {
        for (TypeProvider provider : providers) {
            BundledRenderUnitCapability capability = provider.getBundledRenderUnitCapability();
            for (String match : this.buildScriptMatches(capability.getResourceTypes(), capability.getSelectors().toArray(new String[0]), capability.getMethod(), capability.getExtension())) {
                BundledRenderUnit executable;
                String scriptExtension = capability.getScriptExtension();
                String scriptEngineName = capability.getScriptEngineName();
                if (!StringUtils.isNotEmpty((CharSequence)scriptExtension) || !StringUtils.isNotEmpty((CharSequence)scriptEngineName) || (executable = this.getExecutable(context, provider.getBundle(), match, scriptEngineName, scriptExtension, allProviders)) == null) continue;
                return executable;
            }
        }
        return null;
    }

    @Nullable
    public BundledRenderUnit findUnit(@NotNull BundleContext context, @NotNull TypeProvider provider, @NotNull Set<TypeProvider> providers) {
        BundledRenderUnitCapability capability = provider.getBundledRenderUnitCapability();
        String path = capability.getPath();
        String scriptEngineName = capability.getScriptEngineName();
        String scriptExtension = capability.getScriptExtension();
        if (StringUtils.isNotEmpty((CharSequence)path) && StringUtils.isNotEmpty((CharSequence)scriptEngineName) && StringUtils.isNotEmpty((CharSequence)scriptExtension)) {
            return this.findUnit(context, provider.getBundle(), path, scriptEngineName, scriptExtension, providers);
        }
        return null;
    }

    @Nullable
    private BundledRenderUnit getExecutable(@NotNull BundleContext context, @NotNull Bundle bundle, @NotNull String match, @NotNull String scriptEngineName, @NotNull String scriptExtension, @NotNull Set<TypeProvider> providers) {
        String path = match + DOT + scriptExtension;
        return this.findUnit(context, bundle, path, scriptEngineName, scriptExtension, providers);
    }

    @Nullable
    private BundledRenderUnit findUnit(@NotNull BundleContext context, @NotNull Bundle bundle, @NotNull String path, String scriptEngineName, @NotNull String scriptExtension, @NotNull Set<TypeProvider> providers) {
        String className = JavaEscapeHelper.makeJavaPackage((String)path);
        ServiceCache serviceCache = this.perContextServiceCache.computeIfAbsent(context, ServiceCache::new);
        try {
            Class clazz = bundle.loadClass(className);
            return new PrecompiledScript(providers, context, bundle, path, clazz, scriptEngineName, scriptExtension, this.scriptContextProvider, serviceCache);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ignored) {
            URL bundledScriptURL = bundle.getEntry(NS_JAVAX_SCRIPT_CAPABILITY + (path.startsWith(SLASH) ? "" : SLASH) + path);
            if (bundledScriptURL != null) {
                return new Script(providers, context, bundle, path, bundledScriptURL, scriptEngineName, scriptExtension, this.scriptContextProvider, serviceCache);
            }
            return null;
        }
    }

    @NotNull
    private List<String> buildScriptMatches(@NotNull Set<ResourceType> resourceTypes, @NotNull String[] selectors, @Nullable String method, @Nullable String extension) {
        ArrayList<String> matches = new ArrayList<String>();
        for (ResourceType resourceType : resourceTypes) {
            if (selectors.length > 0) {
                for (int i = selectors.length - 1; i >= 0; --i) {
                    String base = resourceType.getType() + (resourceType.getVersion() != null ? SLASH + resourceType.getVersion() + SLASH : SLASH) + String.join((CharSequence)SLASH, Arrays.copyOf(selectors, i + 1));
                    if (StringUtils.isNotEmpty((CharSequence)extension)) {
                        if (StringUtils.isNotEmpty((CharSequence)method)) {
                            matches.add(base + DOT + extension + DOT + method);
                        }
                        matches.add(base + DOT + extension);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)method)) {
                        matches.add(base + DOT + method);
                        matches.add(base + SLASH + method);
                    }
                    matches.add(base);
                }
            }
            String base = resourceType.getType() + (resourceType.getVersion() != null ? SLASH + resourceType.getVersion() : "");
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                if (StringUtils.isNotEmpty((CharSequence)method)) {
                    matches.add(base + SLASH + resourceType.getResourceLabel() + DOT + extension + DOT + method);
                }
                matches.add(base + SLASH + resourceType.getResourceLabel() + DOT + extension);
            }
            if (StringUtils.isNotEmpty((CharSequence)method)) {
                matches.add(base + SLASH + method);
                matches.add(base + SLASH + resourceType.getResourceLabel() + DOT + method);
            }
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                matches.add(base + SLASH + extension);
            }
            matches.add(base + SLASH + resourceType.getResourceLabel());
        }
        return Collections.unmodifiableList(matches);
    }

    @Activate
    private void activate(BundleContext bundleContext) {
        bundleContext.addBundleListener((BundleListener)this);
    }

    @Deactivate
    private void deactivate(BundleContext bundleContext) {
        bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            Iterator iterator = ((ConcurrentHashMap.KeySetView)this.perContextServiceCache.keySet()).iterator();
            while (iterator.hasNext()) {
                try {
                    ((BundleContext)iterator.next()).getBundle();
                }
                catch (IllegalStateException e) {
                    iterator.remove();
                }
            }
        }
    }
}

