/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.core.impl.ScriptingResourceResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptingResourceResolverProvider.class, ServletRequestListener.class}, property={"service.description=Apache Sling Scripting Resource Resolver Provider", "service.vendor=The Apache Software Foundation", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=*)", "osgi.http.whiteboard.listener=true"})
@Designate(ocd=Configuration.class)
public class ScriptingResourceResolverProviderImpl
implements ScriptingResourceResolverProvider,
ServletRequestListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingResourceResolverProviderImpl.class);
    private final ThreadLocal<ScriptingResourceResolver> perThreadResourceResolver = new ThreadLocal();
    private boolean logStackTraceOnResolverClose;
    @Reference
    private ResourceResolverFactory rrf;

    public ResourceResolver getRequestScopedResourceResolver() {
        ScriptingResourceResolver threadResolver = this.perThreadResourceResolver.get();
        if (threadResolver == null) {
            try {
                ResourceResolver delegate = this.rrf.getServiceResourceResolver(null);
                threadResolver = new ScriptingResourceResolver(this.logStackTraceOnResolverClose, delegate);
                this.perThreadResourceResolver.set(threadResolver);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Set per thread resource resolver for thread {}.", (Object)Thread.currentThread().getId());
                }
            }
            catch (LoginException e) {
                throw new IllegalStateException("Cannot create per thread resource resolver.", e);
            }
        }
        return threadResolver;
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ScriptingResourceResolver scriptingResourceResolver = this.perThreadResourceResolver.get();
        if (scriptingResourceResolver != null) {
            scriptingResourceResolver._close();
            this.perThreadResourceResolver.remove();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Removed per thread resource resolver for thread {}.", (Object)Thread.currentThread().getId());
            }
        }
    }

    @Activate
    protected void activate(Configuration configuration) {
        this.logStackTraceOnResolverClose = configuration.log_stacktrace_onclose();
    }

    @ObjectClassDefinition(name="Apache Sling Scripting Resource Resolver Provider Configuration", description="The Apache Sling Scripting Resource Resolver Provider can be used by scripting bundles to obtain resource resolvers for solving scripting dependencies.")
    static @interface Configuration {
        @AttributeDefinition(name="Log the stack trace call for ResourceResolver#close", description="If enabled, all calls to ResourceResolver#close for the request-scoped resource resolvers will be logged with the full stack trace. Don't enable this setting on production systems.")
        public boolean log_stacktrace_onclose() default false;
    }
}

