/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.scripting.core.impl.bundled.ExecutableUnit;
import org.apache.sling.scripting.core.impl.bundled.ScriptContextProvider;
import org.apache.sling.scripting.spi.bundle.TypeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBundledRenderUnit
implements ExecutableUnit {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractBundledRenderUnit.class.getName());
    private final Set<TypeProvider> providers;
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private final String path;
    private final String scriptEngineName;
    private final String scriptExtension;
    private final ScriptContextProvider scriptContextProvider;
    private List<ServiceReference<?>> references;
    private Map<String, Object> services;

    AbstractBundledRenderUnit(@NotNull Set<TypeProvider> providers, @NotNull BundleContext context, @NotNull Bundle bundle, @NotNull String path, @NotNull String scriptEngineName, @NotNull String scriptExtension, @NotNull ScriptContextProvider scriptContextProvider) {
        this.providers = providers;
        this.bundle = bundle;
        this.path = path;
        this.scriptEngineName = scriptEngineName;
        this.scriptExtension = scriptExtension;
        this.scriptContextProvider = scriptContextProvider;
        this.bundleContext = context;
    }

    @NotNull
    public Bundle getBundle() {
        return this.bundle;
    }

    @NotNull
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @NotNull
    public Set<TypeProvider> getTypeProviders() {
        return this.providers;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    @Override
    @NotNull
    public String getScriptExtension() {
        return this.scriptExtension;
    }

    @Nullable
    public <T> T getService(@NotNull String className) {
        ServiceReference ref;
        Object result;
        LOG.debug("Attempting to load class {} as an OSGi service.", (Object)className);
        Object object = result = this.services == null ? null : this.services.get(className);
        if (result == null && (ref = this.bundleContext.getServiceReference(className)) != null && (result = this.bundleContext.getService(ref)) != null) {
            if (this.services == null) {
                this.services = new HashMap<String, Object>();
            }
            if (this.references == null) {
                this.references = new ArrayList();
            }
            this.references.add(ref);
            this.services.put(className, result);
            return (T)result;
        }
        return null;
    }

    @Nullable
    public <T> T[] getServices(@NotNull String className, @Nullable String filter) {
        Object[] result = null;
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(className, filter);
            if (refs != null) {
                List<ServiceReference> localReferences = Arrays.asList(refs);
                Collections.sort(localReferences);
                Collections.reverse(localReferences);
                ArrayList<Object> objects = new ArrayList<Object>();
                for (ServiceReference reference : localReferences) {
                    Object service = this.bundleContext.getService(reference);
                    if (service == null) continue;
                    if (this.references == null) {
                        this.references = new ArrayList();
                    }
                    this.references.add(reference);
                    objects.add(service);
                }
                if (!objects.isEmpty()) {
                    Object[] srv = (Object[])Array.newInstance(this.bundle.loadClass(className), objects.size());
                    result = objects.toArray(srv);
                }
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Unable to retrieve the services of type %s.", className), (Throwable)e);
        }
        return result;
    }

    @Override
    public void releaseDependencies() {
        if (this.references != null) {
            for (ServiceReference<?> reference : this.references) {
                this.bundleContext.ungetService(reference);
            }
            this.references.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) throws ScriptException {
        try {
            ScriptContextProvider.ExecutableContext executableContext = this.scriptContextProvider.prepareScriptContext((SlingHttpServletRequest)request, (SlingHttpServletResponse)response, this);
            try {
                executableContext.eval();
            }
            finally {
                executableContext.clean();
            }
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
    }
}

