/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceCache
implements ServiceListener {
    private final BundleContext bundleContext;
    private static final Reference NULL_REFERENCE = new Reference();
    private final ConcurrentHashMap<String, Reference> cache = new ConcurrentHashMap();
    protected final List<ServiceReference> references = new ArrayList<ServiceReference>();

    public ServiceCache(BundleContext ctx) {
        this.bundleContext = ctx;
        this.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void dispose() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        for (Reference ref : this.cache.values()) {
            if (ref == NULL_REFERENCE) continue;
            this.bundleContext.ungetService(ref.reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ServiceType> ServiceType getService(Class<ServiceType> type) {
        String key = type.getName();
        Reference reference = this.cache.get(key);
        if (reference == null) {
            ServiceReference ref = this.bundleContext.getServiceReference(key);
            if (ref != null) {
                Object service = this.bundleContext.getService(ref);
                if (service != null) {
                    reference = new Reference();
                    reference.service = service;
                    reference.reference = ref;
                } else {
                    ref = null;
                }
            }
            if (reference == null) {
                reference = NULL_REFERENCE;
            }
            ServiceCache serviceCache = this;
            synchronized (serviceCache) {
                Reference existing = this.cache.get(key);
                if (existing == null) {
                    this.cache.put(key, reference);
                    ref = null;
                } else {
                    reference = existing;
                }
            }
            if (ref != null) {
                this.bundleContext.ungetService(ref);
            }
        }
        return (ServiceType)reference.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        String[] objectClasses = (String[])event.getServiceReference().getProperty("objectClass");
        if (objectClasses != null) {
            for (String key : objectClasses) {
                Reference ref = null;
                ServiceCache serviceCache = this;
                synchronized (serviceCache) {
                    ref = this.cache.remove(key);
                }
                if (ref == null || ref == NULL_REFERENCE) continue;
                this.bundleContext.ungetService(ref.reference);
            }
        }
    }

    protected static final class Reference {
        public ServiceReference reference;
        public Object service;

        protected Reference() {
        }
    }
}

