/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.impl.ScriptCacheImplConfiguration;
import org.apache.sling.scripting.core.impl.helper.CachingMap;
import org.apache.sling.scripting.core.impl.jsr223.SlingScriptEngineManager;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptCache.class, EventHandler.class}, property={"service.vendor=The Apache Software Foundation", "event.topics=org/apache/sling/scripting/core/impl/jsr223/SlingScriptEngineManager/*"})
@Designate(ocd=ScriptCacheImplConfiguration.class)
public class ScriptCacheImpl
implements ScriptCache,
ResourceChangeListener,
ExternalResourceChangeListener,
EventHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(ScriptCacheImpl.class);
    public static final int DEFAULT_CACHE_SIZE = 65536;
    private BundleContext bundleContext;
    private Map<String, SoftReference<CachedScript>> internalMap;
    private ServiceRegistration<ResourceChangeListener> resourceChangeListener;
    private Set<String> extensions = new HashSet<String>();
    private String[] additionalExtensions = new String[0];
    private String[] searchPaths = new String[0];
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private ThreadPoolManager threadPoolManager;
    @Reference
    private SlingScriptEngineManager slingScriptEngineManager;
    private ThreadPool threadPool;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private volatile boolean active = false;
    @Reference
    private ServiceUserMapped serviceUserMapped;

    public ScriptCacheImpl() {
        this.internalMap = new CachingMap<CachedScript>(65536);
    }

    public CachedScript getScript(String scriptPath) {
        this.readLock.lock();
        SoftReference<CachedScript> reference = null;
        try {
            reference = this.internalMap.get(scriptPath);
        }
        finally {
            this.readLock.unlock();
        }
        return reference != null ? reference.get() : null;
    }

    public void putScript(CachedScript script) {
        this.writeLock.lock();
        try {
            SoftReference<CachedScript> reference = new SoftReference<CachedScript>(script);
            this.internalMap.put(script.getScriptPath(), reference);
            this.LOGGER.debug("Added script {} to script cache.", (Object)script.getScriptPath());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.internalMap.clear();
            this.LOGGER.debug("Cleared script cache.");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeScript(String scriptPath) {
        this.writeLock.lock();
        try {
            boolean result;
            SoftReference<CachedScript> reference = this.internalMap.remove(scriptPath);
            boolean bl = result = reference != null;
            if (result) {
                this.LOGGER.debug("Removed script {} from script cache.", (Object)scriptPath);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void onChange(@NotNull List<ResourceChange> list) {
        for (final ResourceChange change : list) {
            Runnable eventTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String path = change.getPath();
                    ScriptCacheImpl.this.writeLock.lock();
                    try {
                        boolean removed = ScriptCacheImpl.this.internalMap.remove(path) != null;
                        ScriptCacheImpl.this.LOGGER.debug("Detected script change for {} - removed entry from the cache.", (Object)path);
                        if (!removed && change.getType() == ResourceChange.ChangeType.REMOVED) {
                            String prefix = path + "/";
                            HashSet<String> removal = new HashSet<String>();
                            for (Map.Entry entry : ScriptCacheImpl.this.internalMap.entrySet()) {
                                if (!((String)entry.getKey()).startsWith(prefix)) continue;
                                removal.add((String)entry.getKey());
                            }
                            for (String key : removal) {
                                ScriptCacheImpl.this.internalMap.remove(key);
                                ScriptCacheImpl.this.LOGGER.debug("Detected removal for {} - removed entry {} from the cache.", (Object)path, (Object)key);
                            }
                        }
                    }
                    finally {
                        ScriptCacheImpl.this.writeLock.unlock();
                    }
                }
            };
            this.threadPool.execute(eventTask);
        }
    }

    protected Set<String> getCachedScripts() {
        this.readLock.lock();
        try {
            Set<String> set = this.internalMap.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Activate
    protected void activate(ScriptCacheImplConfiguration configuration, BundleContext bundleCtx) {
        this.threadPool = this.threadPoolManager.get("Script Cache Thread Pool");
        this.bundleContext = bundleCtx;
        this.additionalExtensions = configuration.org_apache_sling_scripting_cache_additional__extensions();
        int newMaxCacheSize = configuration.org_apache_sling_scripting_cache_size();
        if (newMaxCacheSize != 65536) {
            CachingMap<CachedScript> newMap = new CachingMap<CachedScript>(newMaxCacheSize);
            newMap.putAll(this.internalMap);
            this.internalMap = newMap;
        }
        this.active = true;
        this.configureCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureCache() {
        this.writeLock.lock();
        try {
            if (this.active) {
                if (this.resourceChangeListener != null) {
                    this.resourceChangeListener.unregister();
                    this.resourceChangeListener = null;
                }
                this.internalMap.clear();
                if (this.additionalExtensions != null) {
                    this.extensions.addAll(Arrays.asList(this.additionalExtensions));
                }
                if (!this.extensions.isEmpty()) {
                    HashSet<String> globPatterns = new HashSet<String>(this.extensions.size());
                    for (String extension : this.extensions) {
                        globPatterns.add("glob:**/*." + extension);
                    }
                    Hashtable<String, String[]> resourceChangeListenerProperties = new Hashtable<String, String[]>();
                    ((Dictionary)resourceChangeListenerProperties).put("resource.paths", globPatterns.toArray(new String[globPatterns.size()]));
                    ((Dictionary)resourceChangeListenerProperties).put("resource.change.types", new String[]{ResourceChange.ChangeType.CHANGED.name(), ResourceChange.ChangeType.REMOVED.name()});
                    this.resourceChangeListener = this.bundleContext.registerService(ResourceChangeListener.class, (Object)this, resourceChangeListenerProperties);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Deactivate
    protected void deactivate() {
        this.writeLock.lock();
        try {
            this.internalMap.clear();
            if (this.resourceChangeListener != null) {
                this.resourceChangeListener.unregister();
                this.resourceChangeListener = null;
            }
            if (this.threadPool != null) {
                this.threadPoolManager.release(this.threadPool);
                this.threadPool = null;
            }
            this.active = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void handleEvent(Event event) {
        this.clear();
        this.extensions.clear();
        for (ScriptEngineFactory factory : this.slingScriptEngineManager.getEngineFactories()) {
            ScriptEngine scriptEngine = factory.getScriptEngine();
            if (!(scriptEngine instanceof Compilable)) continue;
            this.extensions.addAll(factory.getExtensions());
        }
        this.configureCache();
    }
}

