/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.script.Bindings;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ContextBvpCollector {
    private static final List<String> ANY_ENGINE = Arrays.asList("*", "ANY");
    private final BundleContext bundleContext;
    private final Map<ServiceReference, BindingsValuesProvider> genericBindingsValuesProviders;
    private final Map<String, Map<ServiceReference, BindingsValuesProvider>> langBindingsValuesProviders;

    ContextBvpCollector(BundleContext bc) {
        this.bundleContext = bc;
        this.genericBindingsValuesProviders = new ConcurrentSkipListMap<ServiceReference, BindingsValuesProvider>();
        this.langBindingsValuesProviders = new ConcurrentHashMap<String, Map<ServiceReference, BindingsValuesProvider>>();
    }

    public Object addingService(ServiceReference ref) {
        String[] engineNames = PropertiesUtil.toStringArray(ref.getProperty("javax.script.name"), new String[0]);
        Object service = this.bundleContext.getService(ref);
        if (service != null) {
            if (service instanceof Map) {
                service = new MapWrappingBindingsValuesProvider((Map)service);
            }
            if (engineNames.length == 0) {
                this.genericBindingsValuesProviders.put(ref, (BindingsValuesProvider)service);
            } else if (engineNames.length == 1 && ANY_ENGINE.contains(engineNames[0].toUpperCase())) {
                this.genericBindingsValuesProviders.put(ref, (BindingsValuesProvider)service);
            } else {
                for (String engineName : engineNames) {
                    Map<ServiceReference, BindingsValuesProvider> langProviders = this.langBindingsValuesProviders.get(engineName);
                    if (langProviders == null) {
                        langProviders = new ConcurrentSkipListMap<ServiceReference, BindingsValuesProvider>();
                        this.langBindingsValuesProviders.put(engineName, langProviders);
                    }
                    langProviders.put(ref, (BindingsValuesProvider)service);
                }
            }
        }
        return service;
    }

    public void modifiedService(ServiceReference ref) {
        this.removedService(ref);
        this.addingService(ref);
    }

    public void removedService(ServiceReference ref) {
        if (this.genericBindingsValuesProviders.remove(ref) == null) {
            for (Map<ServiceReference, BindingsValuesProvider> coll : this.langBindingsValuesProviders.values()) {
                coll.remove(ref);
            }
        }
    }

    Map<ServiceReference, BindingsValuesProvider> getGenericBindingsValuesProviders() {
        return this.genericBindingsValuesProviders;
    }

    Map<String, Map<ServiceReference, BindingsValuesProvider>> getLangBindingsValuesProviders() {
        return this.langBindingsValuesProviders;
    }

    private class MapWrappingBindingsValuesProvider
    implements BindingsValuesProvider {
        private Map<String, Object> map;

        MapWrappingBindingsValuesProvider(Map<String, Object> map) {
            this.map = map;
        }

        public void addBindings(Bindings bindings) {
            for (String key : this.map.keySet()) {
                bindings.put(key, this.map.get(key));
            }
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

