/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.core.impl.DefaultSlingScript;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.vendor=The Apache Software Foundation", "felix.webconsole.label=scriptingvariables", "felix.webconsole.title=Scripting Variables", "felix.webconsole.category=Sling"}, service={Servlet.class})
public class ScriptingVariablesConsolePlugin
extends AbstractWebConsolePlugin {
    protected static final String LABEL = "scriptingvariables";
    protected static final String TITLE = "Scripting Variables";
    protected static final String FORWARD_PATH = "/scriptingvariables/show";
    private static final String PARAMETER_EXTENSION = "extension";
    private static final String PARAMETER_PATH = "path";
    protected static final String REQUEST_ATTR = ScriptingVariablesConsolePlugin.class.getName() + ".auth";
    private static final long serialVersionUID = 261709110347150295L;
    private static final String JS_RES_PATH = "scriptingvariables/ui/scriptingvariables.js";
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private BindingsValuesProvidersByContext bindingsValuesProviderTracker;
    private BundleContext bundleContext;

    @Activate
    protected void init(BundleContext context) {
        this.bundleContext = context;
    }

    public URL getResource(String path) {
        if (path.endsWith(JS_RES_PATH)) {
            return ((Object)((Object)this)).getClass().getResource("/scriptingvariables/ui/scriptingvariables.js");
        }
        return null;
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (FORWARD_PATH.equals(path)) {
            ResourceResolver resolver = (ResourceResolver)request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
            if (resolver == null) {
                this.log("Access forbidden as the request was not authenticated through the web console");
                if (!response.isCommitted()) {
                    response.sendError(403);
                }
                return;
            }
            String resourcePath = request.getParameter(PARAMETER_PATH);
            String extension = request.getParameter(PARAMETER_EXTENSION);
            Resource resource = resolver.resolve(resourcePath);
            SlingHttpServletRequest slingRequest = Builders.newRequestBuilder((Resource)resource).useServletContextFrom(request).useAttributesFrom(request).build();
            this.showBindings(slingRequest, response, extension);
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.append("<script type='text/javascript' src='").append(JS_RES_PATH).append("'></script>");
        pw.append("<div id='content'>");
        pw.append("<table class='content'  cellpadding='0' cellspacing='0' width='100%'>");
        pw.append("<tr><th colspan='3' class='content container'>Sling Scripting Variables</th></tr>");
        pw.append("<tr class='content'><td class='content' colspan='3'>Provide a resource path url and script engine (via extension) and then click on 'Retrieve Variables' to expose all script bindings variables for context 'request' which are available for that resource and script engine.</td></tr>");
        pw.append("<tr class='content'>");
        pw.append("<td class='content'>Resource Url (without selectors and extension)</td> ");
        pw.append("<td class='content' colspan='2'><input type ='text' name='form.path' placeholder='path' required='required' value='/' ");
        pw.append("class='input ui-state-default ui-corner-all inputText' size='50' pattern='^/{1}.*'></td></tr>");
        pw.append("<tr class='content'>");
        pw.append("<td class='content'>Script Engine</td> ");
        pw.append("<td class='content' colspan='2'><select name='form.extension'>");
        for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
            for (String extension : factory.getExtensions()) {
                pw.append("<option value='" + extension + "'>" + extension + " (" + factory.getEngineName() + ")</option>");
            }
        }
        pw.append("<option value=''>all (unfiltered)</option>");
        pw.append("</select> ");
        pw.append("<button type='button' id='submitButton'> Retrieve Variables </button></td></tr></table>");
        pw.append("<div id='response'></div>");
    }

    protected void showBindings(SlingHttpServletRequest request, HttpServletResponse response, String requestedExtension) throws ServletException, IOException {
        response.setContentType("application/json");
        JSONWriter jsonWriter = new JSONWriter(response.getWriter());
        jsonWriter.array();
        if (requestedExtension != null && !requestedExtension.isEmpty()) {
            ScriptEngine selectedScriptEngine = this.scriptEngineManager.getEngineByExtension(requestedExtension);
            if (selectedScriptEngine == null) {
                throw new IllegalArgumentException("Invalid extension requested: " + requestedExtension);
            }
            this.writeBindingsToJsonWriter(jsonWriter, selectedScriptEngine.getFactory(), request);
        } else {
            for (ScriptEngineFactory engineFactory : this.scriptEngineManager.getEngineFactories()) {
                this.writeBindingsToJsonWriter(jsonWriter, engineFactory, request);
            }
        }
        jsonWriter.endArray();
    }

    private void writeBindingsToJsonWriter(JSONWriter jsonWriter, ScriptEngineFactory engineFactory, SlingHttpServletRequest request) throws IOException {
        jsonWriter.object();
        jsonWriter.key("engine");
        jsonWriter.value(engineFactory.getEngineName());
        jsonWriter.key("extensions");
        jsonWriter.value(engineFactory.getExtensions());
        Bindings bindings = this.getBindingsByEngine(engineFactory, request);
        jsonWriter.key("bindings");
        jsonWriter.array();
        for (Map.Entry entry : bindings.entrySet()) {
            jsonWriter.object();
            jsonWriter.key("name");
            jsonWriter.value(entry.getKey());
            jsonWriter.key("class");
            jsonWriter.value(entry.getValue() == null ? "&lt;NO VALUE&gt;" : entry.getValue().getClass().getName());
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private Bindings getBindingsByEngine(ScriptEngineFactory scriptEngineFactory, SlingHttpServletRequest request) throws IOException {
        String context = "request";
        Collection bindingsValuesProviders = this.bindingsValuesProviderTracker.getBindingsValuesProviders(scriptEngineFactory, context);
        NonExistingResource invalidScriptResource = new NonExistingResource(request.getResourceResolver(), "some/invalid/scriptpath");
        DefaultSlingScript defaultSlingScript = new DefaultSlingScript(this.bundleContext, (Resource)invalidScriptResource, scriptEngineFactory.getScriptEngine(), bindingsValuesProviders, null, null);
        SlingBindings initalBindings = new SlingBindings();
        initalBindings.setRequest(request);
        initalBindings.setResponse((SlingHttpServletResponse)Builders.newResponseBuilder().build());
        Bindings bindings = defaultSlingScript.verifySlingBindings(initalBindings);
        bindings.put("org.apache.sling.api.scripting.ScriptResourceResolver", (Object)request.getResourceResolver());
        return bindings;
    }
}

