/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingScriptEnginePicker.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling Scripting SlingScriptEnginePicker"})
public class SlingScriptEnginePicker {
    private static String SLING_SCRIPTING = "sling:scripting";
    private final Logger logger = LoggerFactory.getLogger(SlingScriptEnginePicker.class);

    @Nullable
    ScriptEngine pickScriptEngine(@NotNull List<ScriptEngine> scriptEngines, @NotNull Resource resource, @NotNull String extension) {
        String scriptingMapping = this.findScriptingMapping(resource, extension);
        this.logger.debug("scripting mapping: {}", (Object)scriptingMapping);
        if (scriptingMapping == null || scriptingMapping.isEmpty()) {
            return scriptEngines.size() > 0 ? scriptEngines.get(0) : null;
        }
        Conditions conditions = this.parseScriptingMapping(scriptingMapping);
        this.logger.debug("scripting conditions: {}", (Object)conditions);
        for (ScriptEngine scriptEngine : scriptEngines) {
            ScriptEngineFactory scriptEngineFactory = scriptEngine.getFactory();
            if (!conditions.matches(scriptEngineFactory.getLanguageName())) continue;
            this.logger.debug("script engine {} found for conditions {}", (Object)scriptEngineFactory.getEngineName(), (Object)conditions);
            return scriptEngine;
        }
        return null;
    }

    private String findScriptingMapping(@NotNull Resource resource, @NotNull String extension) {
        String[] mappings = (String[])resource.getValueMap().get(SLING_SCRIPTING, String[].class);
        if (mappings != null) {
            String start = String.format("%s=", extension);
            for (String mapping : mappings) {
                if (!mapping.startsWith(start)) continue;
                return mapping.substring(start.length());
            }
            return resource.getParent() != null ? this.findScriptingMapping(resource.getParent(), extension) : null;
        }
        if (resource.getParent() != null) {
            return this.findScriptingMapping(resource.getParent(), extension);
        }
        return null;
    }

    private Conditions parseScriptingMapping(@NotNull String scriptingMapping) {
        String[] values = scriptingMapping.split(":");
        String languageName = values[0];
        String languageVersion = values.length > 1 ? values[1] : null;
        return new Conditions(languageName, languageVersion);
    }

    private class Conditions {
        final String languageName;
        final String languageVersion;

        Conditions(@Nullable String languageName, String languageVersion) {
            this.languageName = languageName;
            this.languageVersion = languageVersion;
        }

        boolean matches(String languageName) {
            return this.languageName.equalsIgnoreCase(languageName);
        }

        public String toString() {
            return String.format("%s, %s", this.languageName, this.languageVersion);
        }
    }
}

