/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.util.Arrays;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.TransformerFactory;
import org.apache.sling.rewriter.impl.FactoryCache;
import org.apache.sling.rewriter.impl.HashingServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransformerFactoryServiceTracker
extends HashingServiceTrackerCustomizer<TransformerFactory> {
    private final Logger LOGGER = LoggerFactory.getLogger(TransformerFactoryServiceTracker.class);
    public static final FactoryCache.TransformerFactoryEntry[] EMPTY_ENTRY_ARRAY = new FactoryCache.TransformerFactoryEntry[0];
    public static final FactoryCache.TransformerFactoryEntry[][] EMPTY_DOUBLE_ENTRY_ARRAY = new FactoryCache.TransformerFactoryEntry[][]{EMPTY_ENTRY_ARRAY, EMPTY_ENTRY_ARRAY};
    public static final TransformerFactory[] EMPTY_FACTORY_ARRAY = new TransformerFactory[0];
    public static final TransformerFactory[][] EMPTY_DOUBLE_FACTORY_ARRAY = new TransformerFactory[][]{EMPTY_FACTORY_ARRAY, EMPTY_FACTORY_ARRAY};
    private FactoryCache.TransformerFactoryEntry[][] cached = EMPTY_DOUBLE_ENTRY_ARRAY;
    private volatile int currentTrackingCount = super.getTrackingCount();

    private String getMode(ServiceReference<TransformerFactory> ref) {
        String mode = (String)ref.getProperty("pipeline.mode");
        return mode;
    }

    private boolean isGlobal(ServiceReference<TransformerFactory> ref) {
        return "global".equalsIgnoreCase(this.getMode(ref));
    }

    public TransformerFactoryServiceTracker(BundleContext bc, String serviceClassName) {
        super(bc, serviceClassName);
    }

    @Override
    public TransformerFactory addingService(ServiceReference<TransformerFactory> reference) {
        boolean isGlobal = this.isGlobal(reference);
        this.LOGGER.debug("Adding service {}, isGlobal={}", reference.getClass(), (Object)isGlobal);
        TransformerFactory obj = super.addingService(reference);
        if (isGlobal && this.getType(reference) == null) {
            obj = (TransformerFactory)this.context.getService(reference);
        }
        return obj;
    }

    @Override
    public void removedService(ServiceReference<TransformerFactory> reference, TransformerFactory service) {
        boolean isGlobal = this.isGlobal(reference);
        this.LOGGER.debug("Removing service {}, isGlobal={}", reference.getClass(), (Object)isGlobal);
        super.removedService(reference, service);
        if (isGlobal && this.getType(reference) == null) {
            this.context.ungetService(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryCache.TransformerFactoryEntry[][] getGlobalTransformerFactoryEntries() {
        if (this.currentTrackingCount != this.getTrackingCount()) {
            TransformerFactoryServiceTracker transformerFactoryServiceTracker = this;
            synchronized (transformerFactoryServiceTracker) {
                if (this.currentTrackingCount != this.getTrackingCount()) {
                    Object[] refs = this.getServiceReferences();
                    this.LOGGER.debug("Found {} service references", (Object)refs.length);
                    if (refs == null || refs.length == 0) {
                        this.cached = EMPTY_DOUBLE_ENTRY_ARRAY;
                    } else {
                        Arrays.sort(refs);
                        int preCount = 0;
                        int postCount = 0;
                        for (Object ref : refs) {
                            int ranking;
                            if (!this.isGlobal((ServiceReference<TransformerFactory>)ref)) continue;
                            Object r = ref.getProperty("service.ranking");
                            int n = ranking = r instanceof Integer ? (Integer)r : 0;
                            if (ranking < 0) {
                                ++preCount;
                                continue;
                            }
                            ++postCount;
                        }
                        FactoryCache.TransformerFactoryEntry[][] globalFactories = new FactoryCache.TransformerFactoryEntry[][]{preCount == 0 ? EMPTY_ENTRY_ARRAY : new FactoryCache.TransformerFactoryEntry[preCount], postCount == 0 ? EMPTY_ENTRY_ARRAY : new FactoryCache.TransformerFactoryEntry[postCount]};
                        int index = 0;
                        for (Object ref : refs) {
                            if (!this.isGlobal((ServiceReference<TransformerFactory>)ref)) continue;
                            if (index < preCount) {
                                this.LOGGER.debug("Initializing pre global TransformerFactory for service ref: {}", ref.getClass());
                                globalFactories[0][index] = new FactoryCache.TransformerFactoryEntry((TransformerFactory)this.getService((ServiceReference)ref), (ServiceReference<TransformerFactory>)ref);
                            } else {
                                this.LOGGER.debug("Initializing post global TransformerFactory for service ref: {}", ref.getClass());
                                globalFactories[1][index - preCount] = new FactoryCache.TransformerFactoryEntry((TransformerFactory)this.getService((ServiceReference)ref), (ServiceReference<TransformerFactory>)ref);
                            }
                            ++index;
                        }
                        if (globalFactories[0].length > 1) {
                            Arrays.sort(globalFactories[0]);
                        }
                        if (globalFactories[1].length > 1) {
                            Arrays.sort(globalFactories[1]);
                        }
                        this.cached = globalFactories;
                    }
                    this.currentTrackingCount = this.getTrackingCount();
                }
            }
        }
        return this.cached;
    }

    public TransformerFactory[][] getGlobalTransformerFactories(ProcessingContext context) {
        FactoryCache.TransformerFactoryEntry[][] globalFactoryEntries = this.getGlobalTransformerFactoryEntries();
        if (globalFactoryEntries == EMPTY_DOUBLE_ENTRY_ARRAY) {
            this.LOGGER.debug("No TransformerFactory found");
            return EMPTY_DOUBLE_FACTORY_ARRAY;
        }
        TransformerFactory[][] factories = new TransformerFactory[2][];
        for (int i = 0; i < 2; ++i) {
            if (globalFactoryEntries[i] == EMPTY_ENTRY_ARRAY) {
                this.LOGGER.debug("No {} TransformerFactory found for context {}", (Object)(i == 0 ? "pre" : "post"), (Object)context);
                factories[i] = EMPTY_FACTORY_ARRAY;
                continue;
            }
            factories[i] = new TransformerFactory[globalFactoryEntries[i].length];
            for (int m = 0; m < globalFactoryEntries[i].length; ++m) {
                FactoryCache.TransformerFactoryEntry entry = globalFactoryEntries[i][m];
                if (!entry.match(context)) continue;
                factories[i][m] = entry.factory;
            }
            this.LOGGER.debug("Found {} Transformer factories {} for context {}", new Object[]{i == 0 ? "pre" : "post", factories[i], context});
        }
        return factories;
    }
}

