/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;

public class ProcessingComponentConfigurationImpl
implements ProcessingComponentConfiguration {
    public static final ValueMap EMPTY_CONFIG = new ValueMapDecorator(new HashMap());
    public static final ProcessingComponentConfiguration EMPTY = new ProcessingComponentConfigurationImpl("<empty>", null);
    private final String type;
    private final ValueMap configuration;
    private final String descText;

    public ProcessingComponentConfigurationImpl(String type, ValueMap config) {
        this.type = type;
        this.configuration = config == null ? EMPTY_CONFIG : config;
        StringBuilder sb = new StringBuilder();
        sb.append("Config(type=");
        sb.append(this.type);
        sb.append(", config=");
        if (config == null) {
            sb.append("{}");
        } else {
            sb.append(config);
        }
        sb.append(")");
        this.descText = sb.toString();
    }

    @Override
    public ValueMap getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.descText;
    }

    void printConfiguration(PrintWriter pw) {
        pw.print(this.type);
        if (this.configuration == EMPTY_CONFIG) {
            pw.println();
        } else {
            pw.print(" : ");
            HashMap map = new HashMap(this.configuration);
            map.remove("jcr:primaryType");
            pw.println(map);
        }
    }
}

