/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.resourceresolver.impl.ResourceResolverMetrics;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.MapEntryIterator;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.mapping.PagedQueryIterator;
import org.apache.sling.resourceresolver.impl.mapping.QueryBuildHelper;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.apache.sling.resourceresolver.impl.mapping.VanityPathHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntries
implements MapEntriesHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_PREFIX = "jcr:content/";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    public static final int DEFAULT_DEFAULT_VANITY_PATH_REDIRECT_STATUS = 302;
    private static final String JCR_SYSTEM_PATH = "/jcr:system";
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(MapEntries.class);
    private volatile MapConfigurationProvider factory;
    private volatile ResourceResolver resolver;
    private volatile EventAdmin eventAdmin;
    private Optional<ResourceResolverMetrics> metrics;
    private volatile ServiceRegistration<ResourceChangeListener> registration;
    private final Map<String, List<MapEntry>> resolveMapsMap;
    private List<Map.Entry<String, ResourceChange.ChangeType>> resourceChangeQueue;
    private Collection<MapEntry> mapMaps;
    private Map<String, Map<String, Collection<String>>> aliasMapsMap;
    private final AtomicLong aliasResourcesOnStartup;
    private final AtomicLong detectedConflictingAliases;
    private final AtomicLong detectedInvalidAliases;
    private static final int MAX_REPORT_DEFUNCT_ALIASES = 50;
    private final ReentrantLock initializing = new ReentrantLock();
    private final StringInterpolationProvider stringInterpolationProvider;
    private final boolean useOptimizeAliasResolution;
    final VanityPathHandler vph;
    private final AtomicLong lastTimeLogged = new AtomicLong(-1L);
    private final long LOGGING_ERROR_PERIOD = 300000L;

    public MapEntries(MapConfigurationProvider factory, BundleContext bundleContext, EventAdmin eventAdmin, StringInterpolationProvider stringInterpolationProvider, Optional<ResourceResolverMetrics> metrics) throws LoginException, IOException {
        this.resolver = factory.getServiceResourceResolver(factory.getServiceUserAuthenticationInfo("mapping"));
        this.factory = factory;
        this.eventAdmin = eventAdmin;
        this.resolveMapsMap = new ConcurrentHashMap(Map.of(GLOBAL_LIST_KEY, List.of()));
        this.mapMaps = Collections.emptyList();
        this.aliasMapsMap = new ConcurrentHashMap<String, Map<String, Collection<String>>>();
        this.stringInterpolationProvider = stringInterpolationProvider;
        this.aliasResourcesOnStartup = new AtomicLong(0L);
        this.detectedConflictingAliases = new AtomicLong(0L);
        this.detectedInvalidAliases = new AtomicLong(0L);
        this.useOptimizeAliasResolution = this.initializeAliases();
        this.registration = this.registerResourceChangeListener(bundleContext);
        this.vph = new VanityPathHandler(this.factory, this.resolveMapsMap, this.initializing, this::drainQueue);
        this.vph.initializeVanityPaths();
        this.metrics = metrics;
        if (metrics.isPresent()) {
            this.metrics.get().setNumberOfDetectedConflictingAliasesSupplier(this.detectedConflictingAliases::get);
            this.metrics.get().setNumberOfDetectedInvalidAliasesSupplier(this.detectedInvalidAliases::get);
            this.metrics.get().setNumberOfResourcesWithAliasedChildrenSupplier(() -> this.aliasMapsMap.size());
            this.metrics.get().setNumberOfResourcesWithAliasesOnStartupSupplier(this.aliasResourcesOnStartup::get);
            this.metrics.get().setNumberOfResourcesWithVanityPathsOnStartupSupplier(this.vph.vanityResourcesOnStartup::get);
            this.metrics.get().setNumberOfVanityPathBloomFalsePositivesSupplier(this.vph.vanityPathBloomFalsePositives::get);
            this.metrics.get().setNumberOfVanityPathBloomNegativesSupplier(this.vph.vanityPathBloomNegatives::get);
            this.metrics.get().setNumberOfVanityPathLookupsSupplier(this.vph.vanityPathLookups::get);
            this.metrics.get().setNumberOfVanityPathsSupplier(this.vph.vanityCounter::get);
        }
    }

    private ServiceRegistration<ResourceChangeListener> registerResourceChangeListener(BundleContext bundleContext) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] paths = new String[this.factory.getObservationPaths().length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.factory.getObservationPaths()[i].getPath();
        }
        ((Dictionary)props).put("resource.paths", paths);
        ((Dictionary)props).put("service.description", "Apache Sling Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.log.info("Registering for {}", (Object)Arrays.toString(this.factory.getObservationPaths()));
        this.resourceChangeQueue = Collections.synchronizedList(new LinkedList());
        return bundleContext.registerService(ResourceChangeListener.class, (Object)this, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addResource(String path, AtomicBoolean resolverRefreshed) {
        this.initializing.lock();
        try {
            Resource resource;
            this.refreshResolverIfNecessary(resolverRefreshed);
            Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(path) : null;
            if (resource != null) {
                boolean changed = this.vph.doAddVanity(resource);
                if (this.useOptimizeAliasResolution && resource.getValueMap().containsKey((Object)"sling:alias")) {
                    changed |= this.doAddAlias(resource);
                }
                boolean bl = changed;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateResource(String path, AtomicBoolean resolverRefreshed) {
        boolean isValidVanityPath = this.vph.isValidVanityPath(path);
        if (this.useOptimizeAliasResolution || isValidVanityPath) {
            this.initializing.lock();
            try {
                Resource resource;
                this.refreshResolverIfNecessary(resolverRefreshed);
                Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(path) : null;
                if (resource != null) {
                    boolean changed = false;
                    if (isValidVanityPath) {
                        changed |= this.vph.doRemoveVanity(path);
                        Resource contentRsrc = null;
                        if (!resource.getName().equals(JCR_CONTENT)) {
                            contentRsrc = resource.getChild(JCR_CONTENT);
                        }
                        changed |= this.vph.doAddVanity(contentRsrc != null ? contentRsrc : resource);
                    }
                    if (this.useOptimizeAliasResolution) {
                        changed |= this.doUpdateAlias(resource);
                    }
                    boolean bl = changed;
                    return bl;
                }
            }
            finally {
                this.initializing.unlock();
            }
        }
        return false;
    }

    private boolean removeResource(String path, AtomicBoolean resolverRefreshed) {
        boolean changed = false;
        String actualContentPath = this.getActualContentPath(path);
        String actualContentPathPrefix = actualContentPath + "/";
        for (String target : this.vph.getVanityPathMappings().keySet()) {
            if (!target.startsWith(actualContentPathPrefix) && !target.equals(actualContentPath)) continue;
            changed |= this.vph.removeVanityPath(target);
        }
        if (this.useOptimizeAliasResolution) {
            String pathPrefix = path + "/";
            for (String contentPath : this.aliasMapsMap.keySet()) {
                if (!path.startsWith(contentPath + "/") && !path.equals(contentPath) && !contentPath.startsWith(pathPrefix)) continue;
                changed |= this.removeAlias(contentPath, path, resolverRefreshed);
            }
        }
        return changed;
    }

    private void doUpdateConfiguration() {
        ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
        TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
        this.loadResolverMap(this.resolver, globalResolveMap, newMapMaps);
        this.loadConfiguration(this.factory, globalResolveMap);
        this.loadMapConfiguration(this.factory, newMapMaps);
        Collections.sort(globalResolveMap);
        this.resolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
        this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
    }

    public void dispose() {
        boolean initLocked;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing intialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdmin = null;
    }

    @Override
    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return Collections.unmodifiableList(entries);
    }

    @Override
    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap.get(GLOBAL_LIST_KEY), this.vph::getCurrentMapEntryForVanityPath, this.factory.hasVanityPathPrecedence());
    }

    @Override
    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    @Override
    public boolean isOptimizeAliasResolutionEnabled() {
        return this.useOptimizeAliasResolution;
    }

    private void refreshResolverIfNecessary(AtomicBoolean resolverRefreshed) {
        if (resolverRefreshed.compareAndSet(false, true)) {
            this.resolver.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean handleConfigurationUpdate(String path, AtomicBoolean hasReloadedConfig, AtomicBoolean resolverRefreshed, boolean isDelete) {
        if (this.factory.isMapConfiguration(path) || isDelete && this.factory.getMapRoot().startsWith(path + "/")) {
            if (hasReloadedConfig.compareAndSet(false, true)) {
                this.initializing.lock();
                try {
                    if (this.resolver != null) {
                        this.refreshResolverIfNecessary(resolverRefreshed);
                        this.doUpdateConfiguration();
                    }
                }
                finally {
                    this.initializing.unlock();
                }
                return true;
            }
            return null;
        }
        return false;
    }

    public void onChange(List<ResourceChange> changes) {
        boolean inStartup = !this.vph.isReady();
        AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
        boolean sendEvent = false;
        AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
        for (ResourceChange rc : changes) {
            ResourceChange.ChangeType type = rc.getType();
            String path = rc.getPath();
            this.log.debug("onChange, type={}, path={}", (Object)rc.getType(), (Object)path);
            if (path.startsWith(JCR_SYSTEM_PREFIX)) continue;
            if (inStartup) {
                if (type != ResourceChange.ChangeType.REMOVED && type != ResourceChange.ChangeType.ADDED && type != ResourceChange.ChangeType.CHANGED) continue;
                AbstractMap.SimpleEntry<String, ResourceChange.ChangeType> entry = new AbstractMap.SimpleEntry<String, ResourceChange.ChangeType>(path, type);
                this.log.trace("enqueue: {}", entry);
                this.resourceChangeQueue.add(entry);
                continue;
            }
            boolean changed = this.handleResourceChange(type, path, resolverRefreshed, hasReloadedConfig);
            if (!changed) continue;
            sendEvent = true;
        }
        if (sendEvent) {
            this.sendChangeEvent();
        }
    }

    private boolean handleResourceChange(ResourceChange.ChangeType type, String path, AtomicBoolean resolverRefreshed, AtomicBoolean hasReloadedConfig) {
        Boolean result;
        boolean changed = false;
        if (type == ResourceChange.ChangeType.REMOVED) {
            Boolean result2 = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, true);
            if (result2 != null) {
                changed = result2.booleanValue() ? true : (changed |= this.removeResource(path, resolverRefreshed));
            }
        } else if (type == ResourceChange.ChangeType.ADDED) {
            Boolean result3 = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, false);
            if (result3 != null) {
                changed = result3.booleanValue() ? true : (changed |= this.addResource(path, resolverRefreshed));
            }
        } else if (type == ResourceChange.ChangeType.CHANGED && (result = this.handleConfigurationUpdate(path, hasReloadedConfig, resolverRefreshed, false)) != null) {
            changed = result.booleanValue() ? true : (changed |= this.updateResource(path, resolverRefreshed));
        }
        return changed;
    }

    private String getActualContentPath(String path) {
        String checkPath = path.endsWith(JCR_CONTENT_SUFFIX) ? ResourceUtil.getParent((String)path) : path;
        return checkPath;
    }

    private void sendChangeEvent() {
        EventAdmin local = this.eventAdmin;
        if (local != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            local.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.factory.getMapRoot());
        if (res != null) {
            this.gather(resolver, entries, mapEntries, res, "");
        }
    }

    private void gather(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get(PROP_REG_EXP, String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = child.getName().concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name = this.stringInterpolationProvider.substitute(name))).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, entries, mapEntries, child, childParent);
            }
            MapEntry childResolveEntry = null;
            try {
                childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash);
            }
            catch (IllegalArgumentException iae) {
                this.log.debug("ignored entry due exception ", (Throwable)iae);
            }
            if (childResolveEntry != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private void loadConfiguration(MapConfigurationProvider factory, List<MapEntry> entries) {
        Mapping[] mappings;
        Map<String, String> virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry<String, String> virtualEntry : virtuals.entrySet()) {
                String string;
                String extPath = virtualEntry.getKey();
                if (extPath.equals(string = virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = string;
                MapEntry mapEntry = this.getMapEntry(url, -1, redirect);
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = this.getMapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, ((List)entry.getValue()).toArray(new String[0]));
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
    }

    private void loadMapConfiguration(MapConfigurationProvider factory, Map<String, MapEntry> entries) {
        Map<String, String> virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry<String, String> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = virtualEntry.getKey();
                if (extPath.equals(intPath = virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = this.getMapEntry(path, status, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = this.getMapEntry(entry.getPattern(), entry.getStatus(), newRedir);
        }
        if (entry != null) {
            entries.put(path, entry);
        }
    }

    private MapEntry getMapEntry(String url, int status, String ... redirect) {
        return this.getMapEntry(url, status, 0L, redirect);
    }

    private MapEntry getMapEntry(String url, int status, long order, String ... redirect) {
        try {
            return new MapEntry(url, status, false, order, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry for {} due to exception", (Object)url, (Object)iae);
            return null;
        }
    }

    private void drainQueue() {
        AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
        boolean sendEvent = false;
        AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
        while (!this.resourceChangeQueue.isEmpty()) {
            Map.Entry<String, ResourceChange.ChangeType> entry = this.resourceChangeQueue.remove(0);
            ResourceChange.ChangeType type = entry.getValue();
            String path = entry.getKey();
            this.log.trace("drain type={}, path={}", (Object)type, (Object)path);
            boolean changed = this.handleResourceChange(type, path, resolverRefreshed, hasReloadedConfig);
            if (!changed) continue;
            sendEvent = true;
        }
        if (sendEvent) {
            this.sendChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initializeAliases() {
        this.initializing.lock();
        try {
            if (this.resolver == null || this.factory == null) {
                boolean bl = false;
                return bl;
            }
            ArrayList<String> conflictingAliases = new ArrayList<String>();
            ArrayList<String> invalidAliases = new ArrayList<String>();
            boolean isOptimizeAliasResolutionEnabled = this.factory.isOptimizeAliasResolutionEnabled();
            if (isOptimizeAliasResolutionEnabled) {
                try {
                    Map<String, Map<String, Collection<String>>> loadedMap = this.loadAliases(this.resolver, conflictingAliases, invalidAliases);
                    this.aliasMapsMap = loadedMap;
                    if (conflictingAliases.size() >= 50) {
                        this.log.warn("There are {} conflicting aliases; excerpt: {}", (Object)conflictingAliases.size(), conflictingAliases);
                    } else if (!conflictingAliases.isEmpty()) {
                        this.log.warn("There are {} conflicting aliases: {}", (Object)conflictingAliases.size(), conflictingAliases);
                    }
                    if (invalidAliases.size() >= 50) {
                        this.log.warn("There are {} invalid aliases; excerpt: {}", (Object)invalidAliases.size(), invalidAliases);
                    } else if (!invalidAliases.isEmpty()) {
                        this.log.warn("There are {} invalid aliases: {}", (Object)invalidAliases.size(), invalidAliases);
                    }
                }
                catch (Exception e) {
                    this.logDisableAliasOptimization(e);
                    isOptimizeAliasResolutionEnabled = false;
                }
            }
            this.doUpdateConfiguration();
            this.sendChangeEvent();
            boolean bl = isOptimizeAliasResolutionEnabled;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    private boolean doAddAlias(Resource resource) {
        return this.loadAlias(resource, this.aliasMapsMap, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAlias(String contentPath, String path, AtomicBoolean resolverRefreshed) {
        String resourcePath;
        boolean handle = true;
        if (path != null && path.length() > contentPath.length()) {
            String subPath = path.substring(contentPath.length() + 1);
            int firstSlash = subPath.indexOf(47);
            if (firstSlash == -1) {
                if (subPath.equals(JCR_CONTENT)) {
                    handle = false;
                }
                resourcePath = path;
            } else if (subPath.lastIndexOf(47) == firstSlash) {
                if (subPath.startsWith(JCR_CONTENT_PREFIX) || !subPath.endsWith(JCR_CONTENT_SUFFIX)) {
                    handle = false;
                }
                resourcePath = ResourceUtil.getParent((String)path);
            } else {
                handle = false;
                resourcePath = null;
            }
        } else {
            resourcePath = contentPath;
        }
        if (!handle) {
            return false;
        }
        this.initializing.lock();
        try {
            Map<String, Collection<String>> aliasMapEntry = this.aliasMapsMap.get(contentPath);
            if (aliasMapEntry != null) {
                Resource containingResource;
                Object prefix;
                this.refreshResolverIfNecessary(resolverRefreshed);
                Object object = prefix = contentPath.endsWith("/") ? contentPath : contentPath + "/";
                if (aliasMapEntry.entrySet().removeIf(arg_0 -> MapEntries.lambda$removeAlias$1((String)prefix, resourcePath, arg_0)) && aliasMapEntry.isEmpty()) {
                    this.aliasMapsMap.remove(contentPath);
                }
                Resource resource = containingResource = this.resolver != null ? this.resolver.getResource(resourcePath) : null;
                if (containingResource != null) {
                    Resource child;
                    if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                        this.doAddAlias(containingResource);
                    }
                    if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                        this.doAddAlias(child);
                    }
                }
            }
            boolean bl = aliasMapEntry != null;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    private boolean doUpdateAlias(Resource resource) {
        Resource containingResource = this.getResourceToBeAliased(resource);
        if (containingResource != null) {
            Resource child;
            boolean changed;
            Map<String, Collection<String>> aliasMapEntry;
            String containingResourceName = containingResource.getName();
            String parentPath = ResourceUtil.getParent((String)containingResource.getPath());
            Map<String, Collection<String>> map = aliasMapEntry = parentPath == null ? null : this.aliasMapsMap.get(parentPath);
            if (aliasMapEntry != null) {
                aliasMapEntry.remove(containingResourceName);
                if (aliasMapEntry.isEmpty()) {
                    this.aliasMapsMap.remove(parentPath);
                }
            }
            boolean bl = changed = aliasMapEntry != null;
            if (containingResource.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(containingResource);
            }
            if ((child = containingResource.getChild(JCR_CONTENT)) != null && child.getValueMap().containsKey((Object)"sling:alias")) {
                changed |= this.doAddAlias(child);
            }
            return changed;
        }
        this.log.warn("containingResource is null for alias on {}, skipping.", (Object)resource.getPath());
        return false;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getAliasMap(String parentPath) {
        Map<String, Collection<String>> aliasMapForParent = this.aliasMapsMap.get(parentPath);
        return aliasMapForParent != null ? aliasMapForParent : Collections.emptyMap();
    }

    @Override
    public Map<String, List<String>> getVanityPathMappings() {
        return this.vph.getVanityPathMappings();
    }

    private Map<String, Map<String, Collection<String>>> loadAliases(ResourceResolver resolver, List<String> conflictingAliases, List<String> invalidAliases) {
        Iterator<Resource> it;
        ConcurrentHashMap<String, Map<String, Collection<String>>> map = new ConcurrentHashMap<String, Map<String, Collection<String>>>();
        String baseQueryString = this.generateAliasQuery();
        try {
            String queryStringWithSort = baseQueryString + " AND FIRST([sling:alias]) >= '%s' ORDER BY FIRST([sling:alias])";
            it = new PagedQueryIterator("alias", "sling:alias", resolver, queryStringWithSort, 2000);
        }
        catch (QuerySyntaxException ex) {
            this.log.debug("sort with first() not supported, falling back to base query", (Throwable)ex);
            it = this.queryUnpaged("alias", baseQueryString);
        }
        catch (UnsupportedOperationException ex) {
            this.log.debug("query failed as unsupported, retrying without paging/sorting", (Throwable)ex);
            it = this.queryUnpaged("alias", baseQueryString);
        }
        this.log.debug("alias initialization - start");
        long count = 0L;
        long processStart = System.nanoTime();
        while (it.hasNext()) {
            ++count;
            this.loadAlias(it.next(), map, conflictingAliases, invalidAliases);
        }
        long processElapsed = System.nanoTime() - processStart;
        long resourcePerSecond = count * TimeUnit.SECONDS.toNanos(1L) / (processElapsed == 0L ? 1L : processElapsed);
        String diagnostics = "";
        if (it instanceof PagedQueryIterator) {
            PagedQueryIterator pit = (PagedQueryIterator)it;
            if (!pit.getWarning().isEmpty()) {
                this.log.warn(pit.getWarning());
            }
            diagnostics = pit.getStatistics();
        }
        this.log.info("alias initialization - completed, processed {} resources with sling:alias properties in {}ms (~{} resource/s){}", new Object[]{count, TimeUnit.NANOSECONDS.toMillis(processElapsed), resourcePerSecond, diagnostics});
        this.aliasResourcesOnStartup.set(count);
        return map;
    }

    private String generateAliasQuery() {
        Set<String> allowedLocations = this.factory.getAllowedAliasLocations();
        StringBuilder baseQuery = new StringBuilder("SELECT [sling:alias] FROM [nt:base] WHERE");
        if (allowedLocations.isEmpty()) {
            baseQuery.append(" ").append(QueryBuildHelper.excludeSystemPath());
        } else {
            Iterator<String> pathIterator = allowedLocations.iterator();
            baseQuery.append(" (");
            String sep = "";
            while (pathIterator.hasNext()) {
                String prefix = pathIterator.next();
                baseQuery.append(sep).append("isdescendantnode('").append(QueryBuildHelper.escapeString(prefix)).append("')");
                sep = " OR ";
            }
            baseQuery.append(")");
        }
        baseQuery.append(" AND [sling:alias] IS NOT NULL");
        return baseQuery.toString();
    }

    private boolean loadAlias(Resource resource, Map<String, Map<String, Collection<String>>> map, List<String> conflictingAliases, List<String> invalidAliases) {
        Resource containingResource = this.getResourceToBeAliased(resource);
        if (containingResource == null) {
            this.log.warn("containingResource is null for alias on {}, skipping.", (Object)resource.getPath());
            return false;
        }
        Resource parent = containingResource.getParent();
        if (parent == null) {
            this.log.warn("{} is null for alias on {}, skipping.", (Object)(containingResource == resource ? "parent" : "grandparent"), (Object)resource.getPath());
            return false;
        }
        String[] aliasArray = (String[])resource.getValueMap().get("sling:alias", String[].class);
        if (aliasArray == null) {
            return false;
        }
        return this.loadAliasFromArray(aliasArray, map, conflictingAliases, invalidAliases, containingResource.getName(), parent.getPath());
    }

    private boolean loadAliasFromArray(String[] aliasArray, Map<String, Map<String, Collection<String>>> map, List<String> conflictingAliases, List<String> invalidAliases, String resourceName, String parentPath) {
        boolean hasAlias = false;
        this.log.debug("Found alias, total size {}", (Object)aliasArray.length);
        for (String alias : aliasArray) {
            if (MapEntries.isAliasInvalid(alias)) {
                long invalids = this.detectedInvalidAliases.incrementAndGet();
                this.log.warn("Encountered invalid alias '{}' under parent path '{}' (total so far: {}). Refusing to use it.", new Object[]{alias, parentPath, invalids});
                if (invalidAliases == null || invalids >= 50L) continue;
                invalidAliases.add(String.format("'%s'/'%s'", parentPath, alias));
                continue;
            }
            Map parentMap = map.computeIfAbsent(parentPath, key -> new ConcurrentHashMap());
            Optional<String> siblingResourceNameWithDuplicateAlias = parentMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(resourceName)).filter(entry -> ((Collection)entry.getValue()).contains(alias)).findFirst().map(Map.Entry::getKey);
            if (siblingResourceNameWithDuplicateAlias.isPresent()) {
                long conflicting = this.detectedConflictingAliases.incrementAndGet();
                this.log.warn("Encountered duplicate alias '{}' under parent path '{}'. Refusing to replace current target '{}' with '{}' (total duplicated aliases so far: {}).", new Object[]{alias, parentPath, siblingResourceNameWithDuplicateAlias.get(), resourceName, conflicting});
                if (conflictingAliases == null || conflicting >= 50L) continue;
                conflictingAliases.add(String.format("'%s': '%s'/'%s' vs '%s'/'%s'", parentPath, resourceName, alias, siblingResourceNameWithDuplicateAlias.get(), alias));
                continue;
            }
            Collection existingAliases = parentMap.computeIfAbsent(resourceName, name -> new CopyOnWriteArrayList());
            existingAliases.add(alias);
            hasAlias = true;
        }
        return hasAlias;
    }

    @Nullable
    private Resource getResourceToBeAliased(Resource resource) {
        if (JCR_CONTENT.equals(resource.getName())) {
            return resource.getParent();
        }
        return resource;
    }

    private static boolean isAliasInvalid(String alias) {
        boolean invalid;
        boolean bl = invalid = alias.equals("..") || alias.equals(".") || alias.isEmpty();
        if (!invalid) {
            for (char c : alias.toCharArray()) {
                if (c != '/' && c != '#' && c != '?') continue;
                invalid = true;
                break;
            }
        }
        return invalid;
    }

    private Iterator<Resource> queryUnpaged(String subject, String query) {
        this.log.debug("start {} query: {}", (Object)subject, (Object)query);
        long queryStart = System.nanoTime();
        Iterator it = this.resolver.findResources(query, "JCR-SQL2");
        long queryElapsed = System.nanoTime() - queryStart;
        this.log.debug("end {} query; elapsed {}ms", (Object)subject, (Object)TimeUnit.NANOSECONDS.toMillis(queryElapsed));
        return it;
    }

    @Override
    public void logDisableAliasOptimization() {
        this.logDisableAliasOptimization(null);
    }

    private void logDisableAliasOptimization(Exception e) {
        if (e != null) {
            this.log.error("Unexpected problem during initialization of optimize alias resolution. Therefore disabling optimize alias resolution. Please fix the problem.", (Throwable)e);
        } else {
            long now = System.currentTimeMillis();
            if (now - this.lastTimeLogged.getAndSet(now) > 300000L) {
                this.log.error("A problem occured during initialization of optimize alias resolution. Optimize alias resolution is disabled. Check the logs for the reported problem.", (Throwable)e);
            }
        }
    }

    private static /* synthetic */ boolean lambda$removeAlias$1(String prefix, String resourcePath, Map.Entry e) {
        return (prefix + (String)e.getKey()).startsWith(resourcePath);
    }
}

