/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.api.resource.runtime.RuntimeService;
import org.apache.sling.resourceresolver.impl.FactoryPreconditions;
import org.apache.sling.resourceresolver.impl.FactoryRegistrationHandler;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryConfig;
import org.apache.sling.resourceresolver.impl.ResourceResolverMetrics;
import org.apache.sling.resourceresolver.impl.VanityPathConfigurer;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerWhiteboard;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.resourceresolver.impl.providers.RuntimeServiceImpl;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=ResourceResolverFactoryConfig.class)
@Component(name="org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl")
public class ResourceResolverFactoryActivator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceDecoratorTracker resourceDecoratorTracker = new ResourceDecoratorTracker();
    private volatile Mapping[] mappings;
    private volatile BidiMap<String, String> virtualURLMap;
    private volatile List<String> searchPath = Collections.emptyList();
    private volatile String mapRoot;
    private volatile String mapRootPrefix;
    @Reference
    EventAdmin eventAdmin;
    @Reference
    StringInterpolationProvider stringInterpolationProvider;
    @Reference
    ServiceUserMapper serviceUserMapper;
    @Reference
    ResourceAccessSecurityTracker resourceAccessSecurityTracker;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private volatile ResourceResolverMetrics metrics;
    volatile ResourceProviderTracker resourceProviderTracker;
    volatile ResourceChangeListenerWhiteboard changeListenerWhiteboard;
    private volatile BundleContext bundleContext;
    private volatile ResourceResolverFactoryConfig config = DEFAULT_CONFIG;
    private volatile Set<String> allowedAliasLocations = Collections.emptySet();
    private volatile Path[] observationPaths;
    private final FactoryRegistrationHandler factoryRegistrationHandler = new FactoryRegistrationHandler();
    private final VanityPathConfigurer vanityPathConfigurer = new VanityPathConfigurer();
    public static ResourceResolverFactoryConfig DEFAULT_CONFIG;

    public ResourceResolverFactoryActivator() {
        this.vanityPathConfigurer.setConfiguration(DEFAULT_CONFIG, null);
    }

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.resourceDecoratorTracker;
    }

    public ResourceAccessSecurityTracker getResourceAccessSecurityTracker() {
        return this.resourceAccessSecurityTracker;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public StringInterpolationProvider getStringInterpolationProvider() {
        return this.stringInterpolationProvider;
    }

    public Optional<ResourceResolverMetrics> getResourceResolverMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    public BidiMap<String, String> getVirtualURLMap() {
        return this.virtualURLMap;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public List<String> getSearchPath() {
        return this.searchPath;
    }

    public boolean isMangleNamespacePrefixes() {
        return this.config.resource_resolver_manglenamespaces();
    }

    public String getMapRoot() {
        return this.mapRoot;
    }

    public boolean isMapConfiguration(String path) {
        return path.equals(this.getMapRoot()) || path.startsWith(this.mapRootPrefix);
    }

    public boolean isOptimizeAliasResolutionEnabled() {
        return this.config.resource_resolver_optimize_alias_resolution();
    }

    public Set<String> getAllowedAliasLocations() {
        return this.allowedAliasLocations;
    }

    public boolean isLogUnclosedResourceResolvers() {
        return this.config.resource_resolver_log_unclosed();
    }

    public boolean shouldLogResourceResolverClosing() {
        return this.config.resource_resolver_log_closing();
    }

    public Path[] getObservationPaths() {
        return this.observationPaths;
    }

    public VanityPathConfigurer getVanityPathConfigurer() {
        return this.vanityPathConfigurer;
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(BundleContext bundleContext, final ResourceResolverFactoryConfig config, VanityPathConfigurer.DeprecatedVanityConfig deprecatedVanityConfig) {
        boolean hasPreRegisteredResourceProviderTracker;
        this.vanityPathConfigurer.setConfiguration(config, deprecatedVanityConfig);
        this.bundleContext = bundleContext;
        this.config = config;
        TreeBidiMap virtuals = new TreeBidiMap();
        for (int i = 0; config.resource_resolver_virtual() != null && i < config.resource_resolver_virtual().length; ++i) {
            String[] parts = Mapping.split(config.resource_resolver_virtual()[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        for (int i = 0; config.resource_resolver_mapping() != null && i < config.resource_resolver_mapping().length; ++i) {
            maps.add(new Mapping(config.resource_resolver_mapping()[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        if (config.resource_resolver_allowDirect()) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        ArrayList<Object> searchPathList = new ArrayList<Object>();
        if (config.resource_resolver_searchpath() != null && config.resource_resolver_searchpath().length > 0) {
            for (String string : config.resource_resolver_searchpath()) {
                void var11_16;
                void var11_19;
                if (!string.startsWith("/")) {
                    String string2 = "/".concat(string);
                }
                if (!var11_19.endsWith("/")) {
                    String string3 = var11_19.concat("/");
                }
                searchPathList.add(var11_16);
            }
        }
        if (searchPathList.isEmpty()) {
            searchPathList.add("/");
        }
        this.searchPath = Collections.unmodifiableList(searchPathList);
        this.mapRoot = config.resource_resolver_map_location();
        this.mapRootPrefix = this.mapRoot + "/";
        String[] paths = config.resource_resolver_map_observation();
        this.observationPaths = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.observationPaths[i] = new Path(paths[i]);
        }
        String[] aliasLocationsPrefix = config.resource_resolver_allowed_alias_locations();
        if (aliasLocationsPrefix != null) {
            TreeSet<String> prefixSet = new TreeSet<String>();
            for (String prefix : aliasLocationsPrefix) {
                String value = prefix.trim();
                if (value.isEmpty()) continue;
                if (value.startsWith("/")) {
                    prefixSet.add(StringUtils.removeEnd((String)value, (String)"/"));
                    continue;
                }
                this.logger.warn("Path [{}] is ignored. As only absolute paths are allowed for alias optimization", (Object)value);
            }
            if (!prefixSet.isEmpty()) {
                this.allowedAliasLocations = Collections.unmodifiableSet(prefixSet);
            }
        }
        if (!config.resource_resolver_optimize_alias_resolution()) {
            this.logger.warn("The non-optimized alias resolution is used, which has been found to have problems (see SLING-12025). Please migrate to the optimized alias resolution, as the non-optimized version will be removed");
        }
        boolean bl = hasPreRegisteredResourceProviderTracker = this.resourceProviderTracker != null;
        if (!hasPreRegisteredResourceProviderTracker) {
            this.resourceProviderTracker = new ResourceProviderTracker();
            this.changeListenerWhiteboard = new ResourceChangeListenerWhiteboard();
            this.changeListenerWhiteboard.activate(this.bundleContext, this.resourceProviderTracker, this.searchPath);
        }
        Set<String> set = this.getStringSet(config.resource_resolver_required_providers());
        Set<String> requiredResourceProviderNames = this.getStringSet(config.resource_resolver_required_providernames());
        FactoryPreconditions factoryPreconditions = new FactoryPreconditions(this.resourceProviderTracker, requiredResourceProviderNames, set);
        this.factoryRegistrationHandler.configure(this, factoryPreconditions);
        if (!hasPreRegisteredResourceProviderTracker) {
            this.resourceProviderTracker.activate(this.bundleContext, this.eventAdmin, new ResourceProviderTracker.ChangeListener(){

                @Override
                public void providerAdded() {
                    ResourceResolverFactoryActivator.this.factoryRegistrationHandler.maybeRegisterFactory();
                }

                @Override
                public void providerRemoved(boolean stateful, boolean isUsed) {
                    if (isUsed && (stateful || config.resource_resolver_providerhandling_paranoid())) {
                        ResourceResolverFactoryActivator.this.factoryRegistrationHandler.unregisterFactory();
                    }
                    ResourceResolverFactoryActivator.this.factoryRegistrationHandler.maybeRegisterFactory();
                }
            });
        }
    }

    @Modified
    protected void modified(BundleContext bundleContext, ResourceResolverFactoryConfig config, VanityPathConfigurer.DeprecatedVanityConfig deprecatedVanityConfig) {
        this.deactivateInternal();
        this.activate(bundleContext, config, deprecatedVanityConfig);
    }

    @Deactivate
    protected void deactivate() {
        this.factoryRegistrationHandler.close();
        this.bundleContext = null;
        this.deactivateInternal();
    }

    private void deactivateInternal() {
        this.config = DEFAULT_CONFIG;
        this.vanityPathConfigurer.setConfiguration(DEFAULT_CONFIG, null);
        this.changeListenerWhiteboard.deactivate();
        this.changeListenerWhiteboard = null;
        this.resourceProviderTracker.deactivate();
        this.resourceProviderTracker = null;
        this.resourceDecoratorTracker.close();
    }

    public RuntimeService getRuntimeService() {
        return new RuntimeServiceImpl(this.getResourceProviderTracker());
    }

    public ServiceUserMapper getServiceUserMapper() {
        return this.serviceUserMapper;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Reference(service=ResourceDecorator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResourceDecorator(ResourceDecorator decorator, ServiceReference<ResourceDecorator> ref) {
        this.resourceDecoratorTracker.bindResourceDecorator(decorator, ref);
    }

    protected void unbindResourceDecorator(ResourceDecorator decorator) {
        this.resourceDecoratorTracker.unbindResourceDecorator(decorator);
    }

    public ResourceProviderTracker getResourceProviderTracker() {
        return this.resourceProviderTracker;
    }

    private Set<String> getStringSet(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String val : values) {
            if (val == null || val.trim().isEmpty()) continue;
            set.add(val.trim());
        }
        return set.isEmpty() ? null : set;
    }

    static {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method calledMethod, Object[] args) throws Throwable {
                if (calledMethod.getDeclaringClass().isAssignableFrom(ResourceResolverFactoryConfig.class)) {
                    return calledMethod.getDefaultValue();
                }
                if (calledMethod.getDeclaringClass() == Object.class) {
                    if (calledMethod.getName().equals("toString") && (args == null || args.length == 0)) {
                        return "Generated @" + ResourceResolverFactoryConfig.class.getName() + " instance";
                    }
                    if (calledMethod.getName().equals("hashCode") && (args == null || args.length == 0)) {
                        return this.hashCode();
                    }
                    if (calledMethod.getName().equals("equals") && args != null && args.length == 1) {
                        return Boolean.FALSE;
                    }
                }
                throw new InternalError("unexpected method dispatched: " + String.valueOf(calledMethod));
            }
        };
        DEFAULT_CONFIG = (ResourceResolverFactoryConfig)Proxy.newProxyInstance(ResourceResolverFactoryConfig.class.getClassLoader(), new Class[]{ResourceResolverFactoryConfig.class}, handler);
    }
}

