/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryPreconditions {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryPreconditions.class);
    private final ResourceProviderTracker tracker;
    private final List<RequiredProvider> requiredProviders;

    public FactoryPreconditions(ResourceProviderTracker tracker, Set<String> requiredResourceProviderNames, Set<String> requiredResourceProvidersLegacy) {
        this.tracker = tracker;
        this.requiredProviders = this.initRequiredProviders(requiredResourceProviderNames, requiredResourceProvidersLegacy);
    }

    @NotNull
    private List<RequiredProvider> initRequiredProviders(Set<String> requiredResourceProviderNames, Set<String> requiredResourceProvidersLegacy) {
        boolean hasLegacyRequiredProvider = false;
        if (requiredResourceProvidersLegacy != null) {
            hasLegacyRequiredProvider = requiredResourceProvidersLegacy.remove("org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory");
            if (!requiredResourceProvidersLegacy.isEmpty()) {
                LOG.error("ResourceResolverFactory is using deprecated required providers configuration (resource.resolver.required.providers). Please change to use the property resource.resolver.required.providernames for values: {}", requiredResourceProvidersLegacy);
            } else {
                requiredResourceProvidersLegacy = null;
            }
        }
        if (hasLegacyRequiredProvider) {
            boolean hasRequiredProvider;
            if (requiredResourceProviderNames == null) {
                requiredResourceProviderNames = new HashSet<String>();
            }
            boolean bl = hasRequiredProvider = !requiredResourceProviderNames.add("JCR");
            if (hasRequiredProvider) {
                LOG.warn("ResourceResolverFactory is using deprecated required providers configuration (resource.resolver.required.providers) with value '{}'. Please remove this configuration property. '{}' is already contained in the property resource.resolver.required.providernames.", (Object)"org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory", (Object)"JCR");
            } else {
                LOG.warn("ResourceResolverFactory is using deprecated required providers configuration (resource.resolver.required.providers) with value '{}'. Please remove this configuration property and add '{}' to the property resource.resolver.required.providernames.", (Object)"org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory", (Object)"JCR");
            }
        }
        ArrayList<RequiredProvider> rps = new ArrayList<RequiredProvider>();
        if (requiredResourceProvidersLegacy != null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            for (String value : requiredResourceProvidersLegacy) {
                RequiredProvider rp = new RequiredProvider();
                if (value.startsWith("(")) {
                    try {
                        rp.filter = FrameworkUtil.createFilter((String)value);
                    }
                    catch (InvalidSyntaxException e) {
                        logger.warn("Ignoring invalid filter syntax for required provider: " + value, (Throwable)e);
                        rp = null;
                    }
                } else {
                    rp.pid = value;
                }
                if (rp == null) continue;
                rps.add(rp);
            }
        }
        if (requiredResourceProviderNames != null) {
            for (String value : requiredResourceProviderNames) {
                RequiredProvider rp = new RequiredProvider();
                rp.name = value;
                rps.add(rp);
            }
        }
        return rps;
    }

    public boolean checkPreconditions(String unavailableName, String unavailableServicePid) {
        boolean canRegister = true;
        for (RequiredProvider rp : this.requiredProviders) {
            canRegister = false;
            for (ResourceProviderHandler h : this.tracker.getResourceProviderStorage().getAllHandlers()) {
                ResourceProviderInfo info = h.getInfo();
                if (info == null) continue;
                ServiceReference<ResourceProvider> ref = info.getServiceReference();
                Object servicePid = ref.getProperty("service.pid");
                if (unavailableServicePid != null && unavailableServicePid.equals(servicePid) || unavailableName != null && unavailableName.equals(info.getName())) continue;
                if (rp.name != null && rp.name.equals(info.getName())) {
                    canRegister = true;
                    break;
                }
                if (rp.filter != null && rp.filter.match(ref)) {
                    canRegister = true;
                    break;
                }
                if (rp.pid != null && rp.pid.equals(servicePid)) {
                    canRegister = true;
                    break;
                }
                if (rp.pid == null || !rp.pid.equals(ref.getProperty("original.service.pid"))) continue;
                canRegister = true;
                break;
            }
            if (canRegister) continue;
            break;
        }
        return canRegister;
    }

    private static final class RequiredProvider {
        public String name;
        public String pid;
        public Filter filter;

        private RequiredProvider() {
        }
    }
}

