/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.api.resource.runtime.RuntimeService;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.FactoryPreconditions;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryConfig;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.ResourceResolverMetrics;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerWhiteboard;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.resourceresolver.impl.providers.RuntimeServiceImpl;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=ResourceResolverFactoryConfig.class)
@Component(name="org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl")
public class ResourceResolverFactoryActivator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceDecoratorTracker resourceDecoratorTracker = new ResourceDecoratorTracker();
    private volatile Mapping[] mappings;
    private volatile BidiMap<String, String> virtualURLMap;
    private volatile List<String> searchPath = Collections.emptyList();
    private volatile String mapRoot;
    private volatile String mapRootPrefix;
    @Reference
    EventAdmin eventAdmin;
    @Reference
    StringInterpolationProvider stringInterpolationProvider;
    @Reference
    ServiceUserMapper serviceUserMapper;
    @Reference
    ResourceAccessSecurityTracker resourceAccessSecurityTracker;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private volatile ResourceResolverMetrics metrics;
    volatile ResourceProviderTracker resourceProviderTracker;
    volatile ResourceChangeListenerWhiteboard changeListenerWhiteboard;
    private volatile BundleContext bundleContext;
    private volatile ResourceResolverFactoryConfig config = DEFAULT_CONFIG;
    private volatile Set<String> allowedAliasLocations = Collections.emptySet();
    private volatile String[] vanityPathWhiteList;
    private volatile String[] vanityPathBlackList;
    private volatile Path[] observationPaths;
    private final FactoryPreconditions preconds = new FactoryPreconditions();
    private volatile FactoryRegistration factoryRegistration;
    public static ResourceResolverFactoryConfig DEFAULT_CONFIG;

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.resourceDecoratorTracker;
    }

    public ResourceAccessSecurityTracker getResourceAccessSecurityTracker() {
        return this.resourceAccessSecurityTracker;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public StringInterpolationProvider getStringInterpolationProvider() {
        return this.stringInterpolationProvider;
    }

    public Optional<ResourceResolverMetrics> getResourceResolverMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    public BidiMap<String, String> getVirtualURLMap() {
        return this.virtualURLMap;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public List<String> getSearchPath() {
        return this.searchPath;
    }

    public boolean isMangleNamespacePrefixes() {
        return this.config.resource_resolver_manglenamespaces();
    }

    public String getMapRoot() {
        return this.mapRoot;
    }

    public boolean isMapConfiguration(String path) {
        return path.equals(this.getMapRoot()) || path.startsWith(this.mapRootPrefix);
    }

    public int getDefaultVanityPathRedirectStatus() {
        return this.config.resource_resolver_default_vanity_redirect_status();
    }

    public boolean isVanityPathEnabled() {
        return this.config.resource_resolver_enable_vanitypath();
    }

    public boolean isVanityPathCacheInitInBackground() {
        return this.config.resource_resolver_vanitypath_cache_in_background();
    }

    public boolean isOptimizeAliasResolutionEnabled() {
        return this.config.resource_resolver_optimize_alias_resolution();
    }

    public Set<String> getAllowedAliasLocations() {
        return this.allowedAliasLocations;
    }

    public boolean isLogUnclosedResourceResolvers() {
        return this.config.resource_resolver_log_unclosed();
    }

    public String[] getVanityPathWhiteList() {
        return this.vanityPathWhiteList;
    }

    public String[] getVanityPathBlackList() {
        return this.vanityPathBlackList;
    }

    public boolean hasVanityPathPrecedence() {
        return this.config.resource_resolver_vanity_precedence();
    }

    public long getMaxCachedVanityPathEntries() {
        return this.config.resource_resolver_vanitypath_maxEntries();
    }

    public boolean isMaxCachedVanityPathEntriesStartup() {
        return this.config.resource_resolver_vanitypath_maxEntries_startup();
    }

    public int getVanityBloomFilterMaxBytes() {
        return this.config.resource_resolver_vanitypath_bloomfilter_maxBytes();
    }

    public boolean shouldLogResourceResolverClosing() {
        return this.config.resource_resolver_log_closing();
    }

    public Path[] getObservationPaths() {
        return this.observationPaths;
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(BundleContext bundleContext, final ResourceResolverFactoryConfig config) {
        void var10_29;
        this.bundleContext = bundleContext;
        this.config = config;
        TreeBidiMap virtuals = new TreeBidiMap();
        for (int i = 0; config.resource_resolver_virtual() != null && i < config.resource_resolver_virtual().length; ++i) {
            String[] parts = Mapping.split(config.resource_resolver_virtual()[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        for (int i = 0; config.resource_resolver_mapping() != null && i < config.resource_resolver_mapping().length; ++i) {
            maps.add(new Mapping(config.resource_resolver_mapping()[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        if (config.resource_resolver_allowDirect()) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        ArrayList<Object> searchPathList = new ArrayList<Object>();
        if (config.resource_resolver_searchpath() != null && config.resource_resolver_searchpath().length > 0) {
            for (String string : config.resource_resolver_searchpath()) {
                void var10_16;
                void var10_19;
                if (!string.startsWith("/")) {
                    String string2 = "/".concat(string);
                }
                if (!var10_19.endsWith("/")) {
                    String string3 = var10_19.concat("/");
                }
                searchPathList.add(var10_16);
            }
        }
        if (searchPathList.isEmpty()) {
            searchPathList.add("/");
        }
        this.searchPath = Collections.unmodifiableList(searchPathList);
        this.mapRoot = config.resource_resolver_map_location();
        this.mapRootPrefix = this.mapRoot + '/';
        String[] paths = config.resource_resolver_map_observation();
        this.observationPaths = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.observationPaths[i] = new Path(paths[i]);
        }
        String[] aliasLocationsPrefix = config.resource_resolver_allowed_alias_locations();
        if (aliasLocationsPrefix != null) {
            TreeSet<String> prefixSet = new TreeSet<String>();
            for (String prefix : aliasLocationsPrefix) {
                String value = prefix.trim();
                if (value.isEmpty()) continue;
                if (value.startsWith("/")) {
                    prefixSet.add(StringUtils.removeEnd((String)value, (String)"/"));
                    continue;
                }
                this.logger.warn("Path [{}] is ignored. As only absolute paths are allowed for alias optimization", (Object)value);
            }
            if (!prefixSet.isEmpty()) {
                this.allowedAliasLocations = Collections.unmodifiableSet(prefixSet);
            }
        }
        this.vanityPathWhiteList = null;
        String[] vanityPathPrefixes = config.resource_resolver_vanitypath_whitelist();
        if (vanityPathPrefixes != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String value : vanityPathPrefixes) {
                if (value.trim().length() <= 0) continue;
                if (value.trim().endsWith("/")) {
                    arrayList.add(value.trim());
                    continue;
                }
                arrayList.add(value.trim() + "/");
            }
            if (arrayList.size() > 0) {
                this.vanityPathWhiteList = arrayList.toArray(new String[arrayList.size()]);
            }
        }
        this.vanityPathBlackList = null;
        vanityPathPrefixes = config.resource_resolver_vanitypath_blacklist();
        if (vanityPathPrefixes != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String value : vanityPathPrefixes) {
                if (value.trim().length() <= 0) continue;
                if (value.trim().endsWith("/")) {
                    arrayList.add(value.trim());
                    continue;
                }
                arrayList.add(value.trim() + "/");
            }
            if (arrayList.size() > 0) {
                this.vanityPathBlackList = arrayList.toArray(new String[arrayList.size()]);
            }
        }
        Set<String> set = this.getStringSet(config.resource_resolver_required_providers());
        Set<String> requiredResourceProviderNames = this.getStringSet(config.resource_resolver_required_providernames());
        boolean hasLegacyRequiredProvider = false;
        if (set != null) {
            hasLegacyRequiredProvider = set.remove("org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory");
            if (!set.isEmpty()) {
                this.logger.error("ResourceResolverFactory is using deprecated required providers configuration (resource.resolver.required.providers). Please change to use the property resource.resolver.required.providernames for values: " + set);
            } else {
                Object var10_28 = null;
            }
        }
        if (hasLegacyRequiredProvider) {
            boolean hasRequiredProvider;
            if (requiredResourceProviderNames != null) {
                hasRequiredProvider = !requiredResourceProviderNames.add("JCR");
            } else {
                hasRequiredProvider = false;
                requiredResourceProviderNames = Collections.singleton("JCR");
            }
            if (hasRequiredProvider) {
                this.logger.warn("ResourceResolverFactory is using deprecated required providers configuration (resource.resolver.required.providers) with value 'org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory. Please remove this configuration property. JCR is already contained in the property resource.resolver.required.providernames.");
            } else {
                this.logger.warn("ResourceResolverFactory is using deprecated required providers configuration (resource.resolver.required.providers) with value 'org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory. Please remove this configuration property and add JCR to the property resource.resolver.required.providernames.");
            }
        }
        if (this.resourceProviderTracker == null) {
            this.resourceProviderTracker = new ResourceProviderTracker();
            this.changeListenerWhiteboard = new ResourceChangeListenerWhiteboard();
            this.preconds.activate(this.bundleContext, (Set<String>)var10_29, requiredResourceProviderNames, this.resourceProviderTracker);
            this.changeListenerWhiteboard.activate(this.bundleContext, this.resourceProviderTracker, this.searchPath);
            this.resourceProviderTracker.activate(this.bundleContext, this.eventAdmin, new ResourceProviderTracker.ChangeListener(){

                @Override
                public void providerAdded() {
                    if (ResourceResolverFactoryActivator.this.factoryRegistration == null) {
                        ResourceResolverFactoryActivator.this.checkFactoryPreconditions(null, null);
                    }
                }

                @Override
                public void providerRemoved(String name, String pid, boolean stateful, boolean isUsed) {
                    if (ResourceResolverFactoryActivator.this.factoryRegistration != null) {
                        if (isUsed && (stateful || config.resource_resolver_providerhandling_paranoid())) {
                            ResourceResolverFactoryActivator.this.unregisterFactory();
                        }
                        ResourceResolverFactoryActivator.this.checkFactoryPreconditions(name, pid);
                    }
                }
            });
        } else {
            this.preconds.activate(this.bundleContext, (Set<String>)var10_29, requiredResourceProviderNames, this.resourceProviderTracker);
            this.checkFactoryPreconditions(null, null);
        }
    }

    @Modified
    protected void modified(BundleContext bundleContext, ResourceResolverFactoryConfig config) {
        this.deactivate();
        this.activate(bundleContext, config);
    }

    @Deactivate
    protected void deactivate() {
        this.unregisterFactory();
        this.bundleContext = null;
        this.config = DEFAULT_CONFIG;
        this.changeListenerWhiteboard.deactivate();
        this.changeListenerWhiteboard = null;
        this.resourceProviderTracker.deactivate();
        this.resourceProviderTracker = null;
        this.preconds.deactivate();
        this.resourceDecoratorTracker.close();
        this.unregisterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFactory() {
        FactoryRegistration local = null;
        ResourceResolverFactoryActivator resourceResolverFactoryActivator = this;
        synchronized (resourceResolverFactoryActivator) {
            if (this.factoryRegistration != null) {
                local = this.factoryRegistration;
                this.factoryRegistration = null;
            }
        }
        this.unregisterFactory(local);
    }

    private void unregisterFactory(FactoryRegistration local) {
        if (local != null) {
            if (local.factoryRegistration != null) {
                local.factoryRegistration.unregister();
            }
            if (local.runtimeRegistration != null) {
                local.runtimeRegistration.unregister();
            }
            if (local.commonFactory != null) {
                local.commonFactory.deactivate();
            }
        }
    }

    private void registerFactory(BundleContext localContext) {
        final FactoryRegistration local = new FactoryRegistration();
        if (localContext != null) {
            Hashtable<String, String> serviceProps = new Hashtable<String, String>();
            ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)serviceProps).put("service.description", "Apache Sling Resource Resolver Factory");
            local.commonFactory = new CommonResourceResolverFactoryImpl(this);
            local.commonFactory.activate(localContext);
            local.factoryRegistration = localContext.registerService(ResourceResolverFactory.class, (ServiceFactory)new ServiceFactory<ResourceResolverFactory>(){

                public ResourceResolverFactory getService(Bundle bundle, ServiceRegistration<ResourceResolverFactory> registration) {
                    if (ResourceResolverFactoryActivator.this.bundleContext == null) {
                        return null;
                    }
                    ResourceResolverFactoryImpl r = new ResourceResolverFactoryImpl(local.commonFactory, bundle, ResourceResolverFactoryActivator.this.getServiceUserMapper());
                    return r;
                }

                public void ungetService(Bundle bundle, ServiceRegistration<ResourceResolverFactory> registration, ResourceResolverFactory service) {
                }
            }, serviceProps);
            local.runtimeRegistration = localContext.registerService(RuntimeService.class, (Object)this.getRuntimeService(), null);
            this.factoryRegistration = local;
        }
    }

    public RuntimeService getRuntimeService() {
        return new RuntimeServiceImpl(this.getResourceProviderTracker());
    }

    public ServiceUserMapper getServiceUserMapper() {
        return this.serviceUserMapper;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFactoryPreconditions(String unavailableName, String unavailableServicePid) {
        BundleContext localContext = this.getBundleContext();
        if (localContext != null) {
            boolean result = this.preconds.checkPreconditions(unavailableName, unavailableServicePid);
            if (result && this.factoryRegistration == null) {
                Bundle systemBundle = localContext.getBundle("System Bundle");
                if (systemBundle != null && systemBundle.getState() != 16) {
                    boolean create = true;
                    ResourceResolverFactoryActivator resourceResolverFactoryActivator = this;
                    synchronized (resourceResolverFactoryActivator) {
                        if (this.factoryRegistration == null) {
                            this.factoryRegistration = new FactoryRegistration();
                        } else {
                            create = false;
                        }
                    }
                    if (create) {
                        this.registerFactory(localContext);
                    }
                }
            } else if (!result && this.factoryRegistration != null) {
                this.unregisterFactory();
            }
        }
    }

    @Reference(service=ResourceDecorator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.bindResourceDecorator(decorator, props);
    }

    protected void unbindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.unbindResourceDecorator(decorator, props);
    }

    public ResourceProviderTracker getResourceProviderTracker() {
        return this.resourceProviderTracker;
    }

    private Set<String> getStringSet(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String val : values) {
            if (val == null || val.trim().isEmpty()) continue;
            set.add(val.trim());
        }
        return set.isEmpty() ? null : set;
    }

    static {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method calledMethod, Object[] args) throws Throwable {
                if (calledMethod.getDeclaringClass().isAssignableFrom(ResourceResolverFactoryConfig.class)) {
                    return calledMethod.getDefaultValue();
                }
                if (calledMethod.getDeclaringClass() == Object.class) {
                    if (calledMethod.getName().equals("toString") && (args == null || args.length == 0)) {
                        return "Generated @" + ResourceResolverFactoryConfig.class.getName() + " instance";
                    }
                    if (calledMethod.getName().equals("hashCode") && (args == null || args.length == 0)) {
                        return this.hashCode();
                    }
                    if (calledMethod.getName().equals("equals") && args != null && args.length == 1) {
                        return Boolean.FALSE;
                    }
                }
                throw new InternalError("unexpected method dispatched: " + calledMethod);
            }
        };
        DEFAULT_CONFIG = (ResourceResolverFactoryConfig)Proxy.newProxyInstance(ResourceResolverFactoryConfig.class.getClassLoader(), new Class[]{ResourceResolverFactoryConfig.class}, handler);
    }

    private static final class FactoryRegistration {
        public volatile ServiceRegistration<ResourceResolverFactory> factoryRegistration;
        public volatile ServiceRegistration<RuntimeService> runtimeRegistration;
        public volatile CommonResourceResolverFactoryImpl commonFactory;

        private FactoryRegistration() {
        }
    }
}

