/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.impl;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.apache.sling.repoinit.parser.impl.ParseException;
import org.apache.sling.repoinit.parser.impl.RepoInitParserImpl;
import org.apache.sling.repoinit.parser.impl.TokenMgrError;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.osgi.service.component.annotations.Component;

@Component(service={RepoInitParser.class}, property={"service.vendor=The Apache Software Foundation"})
public class RepoInitParserService
implements RepoInitParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Operation> parse(Reader r) throws RepoInitParsingException {
        try (AddTailingLinefeedFilterReader readerWrapper = new AddTailingLinefeedFilterReader(r);){
            List<Operation> list = new RepoInitParserImpl(readerWrapper).parse();
            return list;
        }
        catch (IOException | ParseException | TokenMgrError e) {
            throw new RepoInitParsingException(e.getMessage(), e);
        }
    }

    private static final class AddTailingLinefeedFilterReader
    extends FilterReader {
        private boolean alreadyAddedNewline;

        protected AddTailingLinefeedFilterReader(Reader in) {
            super(in);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int result = super.read(cbuf, off, len);
            if (result == -1 && !this.alreadyAddedNewline) {
                cbuf[off] = 10;
                this.alreadyAddedNewline = true;
                return 1;
            }
            return result;
        }
    }
}

