/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.selector.parser;

import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.query.selector.parser.ParserContext;

public enum State {
    START{

        @Override
        public void process(ParserContext context, char c) {
            if (c == '/') {
                context.setState(TYPE_WITH_SLASHES);
                context.append(c);
            } else if (c == '[') {
                context.setState(ATTRIBUTE_KEY);
            } else if (c == ':') {
                context.setState(MODIFIER);
            } else if (c == '>' || c == '+' || c == '~') {
                context.setHierarchyOperator(c);
            } else if (c == '#') {
                context.setType();
                context.setState(NAME);
            } else if (c != ' ') {
                context.setState(TYPE);
                context.append(c);
            }
        }
    }
    ,
    IDLE{

        @Override
        public void process(ParserContext context, char c) {
            if (c == '[') {
                context.setState(ATTRIBUTE_KEY);
            } else if (c == ':') {
                context.setState(MODIFIER);
            } else if (c == ' ') {
                context.finishSelectorSegment();
                context.setState(START);
            } else if (c == ',' || c == '\u0000') {
                context.finishSelectorSegment();
                context.finishSelector();
                context.setState(START);
            }
        }
    }
    ,
    TYPE{

        @Override
        public void process(ParserContext context, char c) {
            if (c == '/') {
                context.setState(TYPE_WITH_SLASHES);
                context.append(c);
            } else if (c == '[') {
                context.setState(ATTRIBUTE_KEY);
                context.setType();
            } else if (c == ':') {
                context.setState(TYPE_WITH_SLASHES);
                context.append(c);
            } else if (c == '#') {
                context.setType();
                context.setState(NAME);
            } else if (c == ' ') {
                context.setType();
                context.finishSelectorSegment();
                context.setState(START);
            } else if (c == ',' || c == '\u0000') {
                context.setType();
                context.finishSelectorSegment();
                context.finishSelector();
                context.setState(START);
            } else {
                context.append(c);
            }
        }
    }
    ,
    TYPE_WITH_SLASHES{

        @Override
        public void process(ParserContext context, char c) {
            if (c == '[') {
                context.setState(ATTRIBUTE_KEY);
                context.setType();
            } else if (c == ':') {
                context.setState(MODIFIER);
                context.setType();
            } else if (c == '#') {
                context.setType();
                context.setState(NAME);
            } else if (c == ' ') {
                context.setType();
                context.finishSelectorSegment();
                context.setState(START);
            } else if (c == ',' || c == '\u0000') {
                context.setType();
                context.finishSelectorSegment();
                context.finishSelector();
                context.setState(START);
            } else {
                context.append(c);
            }
        }
    }
    ,
    NAME{

        @Override
        public void process(ParserContext context, char c) {
            if (c == '[') {
                context.setName();
                context.setState(ATTRIBUTE_KEY);
            } else if (c == ':') {
                context.setName();
                context.setState(MODIFIER);
            } else if (c == ' ') {
                context.setName();
                context.finishSelectorSegment();
                context.setState(START);
            } else if (c == ',' || c == '\u0000') {
                context.setName();
                context.finishSelectorSegment();
                context.finishSelector();
                context.setState(START);
            } else if (c == '\'') {
                context.setState(ESCAPED_NAME);
            } else {
                context.append(c);
            }
        }
    }
    ,
    ESCAPED_NAME{

        @Override
        public void process(ParserContext context, char c) {
            if (c == '\'') {
                context.setName();
                context.setState(IDLE);
            } else {
                context.append(c);
            }
        }
    }
    ,
    ATTRIBUTE_KEY{

        @Override
        public void process(ParserContext context, char c) {
            if (c == ']') {
                context.setAttributeKey();
                context.addAttribute();
                context.setState(IDLE);
            } else if (ArrayUtils.contains((char[])OPERATORS, (char)c)) {
                context.setAttributeKey();
                context.setState(ATTRIBUTE_OPERATOR);
                context.append(c);
            } else {
                context.append(c);
            }
        }
    }
    ,
    ATTRIBUTE_OPERATOR{

        @Override
        public void process(ParserContext context, char c) {
            if (!ArrayUtils.contains((char[])OPERATORS, (char)c)) {
                context.setAttributeOperator();
                context.append(c);
                context.setState(ATTRIBUTE_VALUE);
            } else {
                context.append(c);
            }
        }
    }
    ,
    ATTRIBUTE_VALUE{

        @Override
        public void process(ParserContext context, char c) {
            if (c == ']') {
                context.setState(IDLE);
                context.setAttributeValue();
                context.addAttribute();
            } else {
                context.append(c);
            }
        }
    }
    ,
    MODIFIER{

        @Override
        public void process(ParserContext context, char c) {
            if (c == ':') {
                context.addModifier();
            } else if (c == '(') {
                context.setModifierName();
                context.setState(MODIFIER_ARGUMENT);
                context.increaseParentheses();
            } else if (c == ' ') {
                context.addModifier();
                context.finishSelectorSegment();
                context.setState(START);
            } else if (c == ',' || c == '\u0000') {
                context.addModifier();
                context.finishSelectorSegment();
                context.finishSelector();
                context.setState(START);
            } else {
                context.append(c);
            }
        }
    }
    ,
    MODIFIER_ARGUMENT{

        @Override
        public void process(ParserContext context, char c) {
            if (c == ')') {
                if (context.decreaseParentheses() == 0) {
                    context.addModifier();
                    context.setState(IDLE);
                } else {
                    context.append(c);
                }
            } else if (c == '(') {
                context.increaseParentheses();
                context.append(c);
            } else {
                context.append(c);
            }
        }
    };

    private static final char[] OPERATORS;

    public abstract void process(ParserContext var1, char var2);

    static {
        OPERATORS = "*~$!^=".toCharArray();
    }
}

