/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.selector.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.query.selector.parser.ParserContext;
import org.apache.sling.query.selector.parser.Selector;
import org.apache.sling.query.selector.parser.SelectorSegment;

public final class SelectorParser {
    private SelectorParser() {
    }

    public static List<Selector> parse(String selector) {
        if (StringUtils.isEmpty((String)selector)) {
            return Arrays.asList(new Selector());
        }
        ParserContext context = new ParserContext();
        for (char c : selector.toCharArray()) {
            context.getState().process(context, c);
        }
        context.getState().process(context, '\u0000');
        return context.getSelectors();
    }

    public static List<SelectorSegment> getFirstSegmentFromEachSelector(List<Selector> selectors) {
        ArrayList<SelectorSegment> segments = new ArrayList<SelectorSegment>();
        for (Selector selector : selectors) {
            if (selector.getSegments().isEmpty()) continue;
            segments.add(selector.getSegments().get(0));
        }
        return segments;
    }
}

