/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.AbstractIterator;

public class SliceIterator<T>
extends AbstractIterator<Option<T>> {
    private final Iterator<Option<T>> iterator;
    private final int from;
    private final int to;
    private int current;

    public SliceIterator(Iterator<Option<T>> iterator, int from, int to) {
        this.iterator = iterator;
        this.current = -1;
        this.from = from;
        this.to = to;
    }

    public SliceIterator(Iterator<Option<T>> iterator, int from) {
        this(iterator, from, Integer.MAX_VALUE);
    }

    @Override
    protected Option<T> getElement() {
        if (this.current > this.to) {
            return null;
        }
        if (this.iterator.hasNext()) {
            Option<T> element = this.iterator.next();
            if (element.isEmpty()) {
                return element;
            }
            if (++this.current >= this.from && this.current <= this.to) {
                return element;
            }
            return Option.empty(element.getArgumentId());
        }
        return null;
    }
}

